﻿namespace Hims.Domain.Configurations
{
    /// <summary>
    /// The SalucroConfiguration interface.
    /// </summary>
    public interface ISalucroConfiguration
    {
        /// <summary>
        /// Gets the payment url.
        /// </summary>
        string PaymentURL { get; }

        /// <summary>
        /// Gets the user.
        /// </summary>
        string User { get; }

        /// <summary>
        /// Gets the key.
        /// </summary>
        string Key { get; }

        /// <summary>
        /// Gets the user name.
        /// </summary>
        string UserName { get; }

        /// <summary>
        /// Gets the payment fill.
        /// </summary>
        string PaymentFill { get; }

        /// <summary>
        /// Gets the response url.
        /// </summary>
        string ResponseURL { get; }

        /// <summary>
        /// Gets the return url.
        /// </summary>
        string ReturnURL { get; }

        /// <summary>
        /// Gets the mid.
        /// </summary>
        string MId { get; }

        /// <summary>
        /// Gets the secret key.
        /// </summary>
        string SecretKey { get; }

        /// <summary>
        /// Gets the mobile return url.
        /// </summary>
        string MobileReturnURL { get; }

        /// <summary>
        /// Gets the redirect success link.
        /// </summary>
        string RedirectSuccessLink { get; }

        /// <summary>
        /// Gets the redirect failure Link.
        /// </summary>
        string RedirectFailureLink { get; }

        /// <summary>
        /// Gets the salucro api.
        /// </summary>
        string SalucroAPI { get; }

        /// <summary>
        /// Gets the patient payment url.
        /// </summary>
        string PatientPaymentURL { get; }

        /// <summary>
        /// Gets the patient app user name.
        /// </summary>
        string PatientAppUserName { get; }

        /// <summary>
        /// Gets the payment source.
        /// </summary>
        string PaymentSource { get; }

        /// <summary>
        /// Gets the patient app return url.
        /// </summary>
        string PatientAppReturnURL { get; }
    }
}
