﻿using Hims.Shared.Dapper.Attributes;
using System.ComponentModel.DataAnnotations;

namespace Hims.Domain.Entities.Pharmacy
{
    /// <summary>
    /// The pharmacy department indent detail.
    /// </summary>
    public class PharmacyDepartmentIndentDetail
    {
        /// <summary>
        /// Gets or sets the pharmacy department indent detail identifier.
        /// </summary>
        /// <value>
        /// The pharmacy department indent detail identifier.
        /// </value>
        [Key,Identity]
        public long PharmacyDepartmentIndentDetailId { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy department indent header identifier.
        /// </summary>
        /// <value>
        /// The pharmacy department indent header identifier.
        /// </value>
        public long PharmacyDepartmentIndentHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy product identifier.
        /// </summary>
        /// <value>
        /// The pharmacy product identifier.
        /// </value>
        public int PharmacyProductId { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is replaced.
        /// </summary>
        /// <value>
        ///   <c>true</c> if this instance is replaced; otherwise, <c>false</c>.
        /// </value>
        public bool IsReplaced { get; set; }

        /// <summary>
        /// Gets or sets the requested quantity.
        /// </summary>
        /// <value>
        /// The requested quantity.
        /// </value>
        public int RequestedQuantity { get; set; }
    }
}
