﻿namespace Hims.Domain.Entities
{
    using System;
    using System.ComponentModel.DataAnnotations;
    using Shared.Dapper.Attributes;

    /// <summary>
    /// The ticket.
    /// </summary>
    public class Ticket
    {
        /// <summary>
        /// Gets or sets the ticket id.
        /// </summary>
        [Key, Identity]
        public long TicketId { get; set; }

        /// <summary>
        /// Gets or sets the ticket number.
        /// </summary>
        [IgnoreUpdate]
        public string TicketNumber { get; set; }

        /// <summary>
        /// Gets or sets the country id.
        /// </summary>
        public int CountryId { get; set; }

        /// <summary>
        /// Gets or sets the priority.
        /// </summary>
        public string Priority { get; set; }

        /// <summary>
        /// Gets or sets the support category id.
        /// </summary>
        public int SupportCategoryId { get; set; }

        /// <summary>
        /// Gets or sets the description.
        /// </summary>
        public string Description { get; set; }

        /// <summary>
        /// Gets or sets the attachment.
        /// </summary>
        public string Attachment { get; set; }

        /// <summary>
        /// Gets or sets the support conversation.
        /// </summary>
        public string SupportConversation { get; set; }

        /// <summary>
        /// Gets or sets the from when.
        /// </summary>
        public string FromWhen { get; set; }

        /// <summary>
        /// Gets or sets the raised by.
        /// </summary>
        public int? RaisedBy { get; set; }

        /// <summary>
        /// Gets or sets the mobile.
        /// </summary>
        public string Mobile { get; set; }

        /// <summary>
        /// Gets or sets the status.
        /// </summary>
        public string Status { get; set; }

        /// <summary>
        /// Gets or sets the comments.
        /// </summary>
        public string Comments { get; set; }

        /// <summary>
        /// Gets or sets the due date.
        /// </summary>
        public DateTime? DueDate { get; set; }

        /// <summary>
        /// Gets or sets the due time.
        /// </summary>
        public TimeSpan? DueTime { get; set; }

        /// <summary>
        /// Gets or sets the start date.
        /// </summary>
        [IgnoreUpdate]
        public DateTime StartDate { get; set; }

        /// <summary>
        /// Gets or sets the end date.
        /// </summary>
        public DateTime? EndDate { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        [IgnoreUpdate]
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; } 
        
        /// <summary>
        /// Gets or sets the location id.
        /// </summary>
        public int? LocationId { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether active.
        /// </summary>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the device type.
        /// </summary>
        public string DeviceType { get; set; }
    }
}
