﻿namespace Hims.Shared.DataFilters
{
    using System.Text.RegularExpressions;

    /// <summary>
    /// The replace filter.
    /// </summary>
    public static class ReplaceFilter
    {
        /// <summary>
        /// The replace.
        /// </summary>
        /// <param name="replaceWith">
        /// The replace with.
        /// </param>
        /// <param name="value">
        /// The value.
        /// </param>
        /// <returns>
        /// The <see cref="string"/>.
        /// </returns>
        public static string Replace(string replaceWith, string value)
        {
            value = Regex.Replace(value, string.Empty + replaceWith + string.Empty, string.Empty + replaceWith + replaceWith + string.Empty);
            return value;
        }

        /// <summary>
        /// The replace.
        /// </summary>
        /// <param name="value">
        /// The value.
        /// </param>
        /// <returns>
        /// The <see cref="string"/>.
        /// </returns>
        public static string Replace(string value)
        {
            value = Regex.Replace(value, "'", "''");
            value = Regex.Replace(value, "-", "--");
            value = Regex.Replace(value, "@", "@@");
            return value;
        }
    }
}
