﻿using System.Collections.Generic;

namespace Hims.Shared.UserModels.Labs
{

    /// <summary>
    /// The lab template observed value model.
    /// </summary>
    public class LabTemplateObservedValueModel
    {
        /// <summary>
        /// Gets or sets the lab template observed value identifier.
        /// </summary>
        /// <value>
        /// The lab template observed value identifier.
        /// </value>
        public long? LabTemplateObservedValueId { get; set; }

        /// <summary>
        /// Gets or sets the lab main detail identifier.
        /// </summary>
        /// <value>
        /// The lab main detail identifier.
        /// </value>
        public int LabMainDetailId { get; set; }

        /// <summary>
        /// Gets or sets the lab template header identifier.
        /// </summary>
        /// <value>
        /// The lab template header identifier.
        /// </value>
        public int LabTemplateHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the method text.
        /// </summary>
        /// <value>
        /// The method text.
        /// </value>
        public string MethodText { get; set; }

        /// <summary>
        /// Gets or sets the interpretation text.
        /// </summary>
        /// <value>
        /// The interpretation text.
        /// </value>
        public string InterpretationText { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this <see cref="LabTemplateObservedValueModel"/> is active.
        /// </summary>
        /// <value>
        ///   <c>true</c> if active; otherwise, <c>false</c>.
        /// </value>
        public bool Active { get; set; }


    }

    /// <summary>
    /// The template input model.
    /// </summary>
    public class TemplateInputModel
    {
        /// <summary>
        /// Gets or sets the templates.
        /// </summary>
        /// <value>
        /// The templates.
        /// </value>
        public List<LabTemplateObservedValueModel> Templates { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        /// <value>
        /// The created by.
        /// </value>
        public int? CreatedBy { get; set; }

        /// <summary>
        /// Creates new labbookingdetailid.
        /// </summary>
        /// <value>
        /// The new lab booking detail identifier.
        /// </value>
        public int NewLabBookingDetailId { get; set; }

        /// <summary>
        /// Gets or sets the lab sample collection detail identifier.
        /// </summary>
        /// <value>
        /// The lab sample collection detail identifier.
        /// </value>
        public int? LabSampleCollectionDetailId { get; set; }
    }
}
