﻿namespace Hims.Shared.UserModels.Pharmacy
{
    /// <summary>
    /// The raw products model.
    /// </summary>
    public class RawProductsModel
    {
        /// <summary>
        /// Gets or sets the product name.
        /// </summary>
        public string ProductName { get; set; }

        /// <summary>
        /// Gets or sets the company.
        /// </summary>
        public string Company { get; set; }

        /// <summary>
        /// Gets or sets the genetic name.
        /// </summary>
        public string GenericName { get; set; }

        /// <summary>
        /// Gets or sets the category.
        /// </summary>
        public string Category { get; set; }

        /// <summary>
        /// Gets or sets the purchase quantity.
        /// </summary>
        public string PurchaseQuantity { get; set; }

        /// <summary>
        /// Gets or sets the purchase unit.
        /// </summary>
        public string PurchaseUnit { get; set; }

        /// <summary>
        /// Gets or sets the sale quantity.
        /// </summary>
        public string SaleQuantity { get; set; }

        /// <summary>
        /// Gets or sets the sale unit.
        /// </summary>
        public string SaleUnit { get; set; }

        /// <summary>
        /// Gets or sets the gst.
        /// </summary>
        public string Gst { get; set; }

        /// <summary>
        /// Gets or sets the bar code required.
        /// </summary>
        public string BarCode { get; set; }

        /// <summary>
        /// Gets or sets the product expire.
        /// </summary>
        public string ProductExpire { get; set; }

        /// <summary>
        /// Gets or sets the bill number.
        /// </summary>
        public string BillNumber { get; set; }

        /// <summary>
        /// Gets or sets the batch number.
        /// </summary>
        public string BatchNumber { get; set; }

        /// <summary>
        /// Gets or sets the batch number required.
        /// </summary>
        public string BatchNumberRequired { get; set; }

        /// <summary>
        /// Gets or sets the purchase qty.
        /// </summary>
        public string PurchaseQty { get; set; }

        /// <summary>
        /// Gets or sets the HSN code.
        /// </summary>
        /// <value>
        /// The HSN code.
        /// </value>
        public string HSNCode { get; set; }

        /// <summary>
        /// Gets or sets the quantity.
        /// </summary>
        /// <value>
        /// The quantity.
        /// </value>
        public string Quantity { get; set; }

        /// <summary>
        /// Gets or sets the free.
        /// </summary>
        /// <value>
        /// The free.
        /// </value>
        public string Free { get; set; }

        /// <summary>
        /// Gets or sets the purchase rate.
        /// </summary>
        /// <value>
        /// The purchase rate.
        /// </value>
        public string PurchaseRate { get; set; }

        /// <summary>
        /// Gets or sets the MRP.
        /// </summary>
        /// <value>
        /// The MRP.
        /// </value>
        public string Mrp { get; set; }

        /// <summary>
        /// Gets or sets the expiry date.
        /// </summary>
        /// <value>
        /// The expiry date.
        /// </value>
        public string ExpiryDate { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        /// <value>
        /// The created by.
        /// </value>
        public int? CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the type of the GST.
        /// </summary>
        /// <value>
        /// The type of the GST.
        /// </value>
        public string GSTType { get; set; }
    }
}
