﻿using Hims.Domain.Entities.Enums;

namespace Hims.Shared.UserModels.Receipt
{
    using System;

    /// <summary>
    /// The receipt model
    /// </summary>
    public class InsertModel
    {
        /// <summary>
        /// Gets or sets the admission identifier.
        /// </summary>
        /// <value>
        /// The admission identifier.
        /// </value>
        public string Id { get; set; }

        /// <summary>
        /// Gets or sets the admission identifier.
        /// </summary>
        /// <value>
        /// The admission identifier.
        /// </value>
        public int AdmissionId { get; set; }

        /// <summary>
        /// Gets or sets the cost.
        /// </summary>
        /// <value>
        /// The cost.
        /// </value>
        public double Cost { get; set; }

        /// <summary>
        /// Gets or sets the receipt type identifier.
        /// </summary>
        /// <value>
        /// The receipt type identifier.
        /// </value>
        public ReceiptType ReceiptTypeId { get; set; }
        
        /// <summary>
        /// Gets or sets a value indicating whether this <see cref="Receipt"/> is active.
        /// </summary>
        /// <value>
        ///   <c>true</c> if active; otherwise, <c>false</c>.
        /// </value>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is advance.
        /// </summary>
        /// <value>
        ///   <c>true</c> if this instance is advance; otherwise, <c>false</c>.
        /// </value>
        public bool IsAdvance { get; set; }

        /// <summary>
        /// Gets or sets the is refunded.
        /// </summary>
        /// <value>
        /// The is refunded.
        /// </value>
        public bool? IsRefunded { get; set; }

        /// <summary>
        /// Gets or sets the pay type identifier.
        /// </summary>
        /// <value>
        /// The pay type identifier.
        /// </value>
        public int PayTypeId { get; set; }

        /// <summary>
        /// Gets or sets the payment details.
        /// </summary>
        /// <value>
        /// The payment details.
        /// </value>
        public string PaymentDetails { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        /// <value>
        /// The created by.
        /// </value>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        /// <value>
        /// The created date.
        /// </value>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is admission.
        /// </summary>
        /// <value>
        ///   <c>true</c> if this instance is admission; otherwise, <c>false</c>.
        /// </value>
        public bool IsAdmission { get; set; }

        /// <summary>
        /// Gets or sets the RoleId.
        /// </summary>
        public short? RoleId { get; set; }
        /// <summary>
        /// Gets or sets the RollName.
        /// </summary>
        public string? RollName { get; set; }
        /// <summary>
        /// Gets or sets the name of the created by.
        /// </summary>
        /// <value>
        /// The name of the created by.
        /// </value>
        public string?  CreatedByName { get; set; }
        /// <summary>
        /// Gets or sets the receipt identifier.
        /// </summary>
        /// <value>
        /// The receipt identifier.
        /// </value>
        public int ReceiptId { get; set; }
        // <summary>
        /// Gets or sets the full name.
        /// </summary>
        /// <value>
        /// The full name.
        /// </value>
        public string FullName { get; set; } = null;

        /// <summary>
        /// Gets or sets the receipt area type identifier.
        /// </summary>
        /// <value>
        /// The receipt area type identifier.
        /// </value>
        public ReceiptAreaType? ReceiptAreaTypeId { get; set; }

        /// <summary>
        /// Gets or sets the receipt area main identifier.
        /// </summary>
        /// <value>
        /// The receipt area main identifier.
        /// </value>
        public int? ReceiptAreaMainId { get; set; }

        /// <summary>
        /// Gets or sets the admission identifier.
        /// </summary>
        /// <value>
        /// The admission identifier.
        /// </value>
        public int? LocationId { get; set; }

        /// <summary>
        /// Gets or sets the transaction id.
        /// </summary>
        public string TransactionId { get; set; }

        /// <summary>
        /// Gets or sets the transaction.
        /// </summary>
        public string Transaction { get; set; }

        /// <summary>
        /// Gets or sets the transaction id.
        /// </summary>
        public int? SalucroStatusCode { get; set; }

        /// <summary>
        /// Gets or sets the transaction id.
        /// </summary>
        public string SalucroTransactionId { get; set; }

        /// <summary>
        /// Gets or sets the is salucro appointment.
        /// </summary>
        public bool IsSalucroAdmissionReceipt { get; set; }
        /// <summary>
        /// Gets or sets the is salucro appointment.
        /// </summary>
        public int PatientId { get; set; }
    }
}
