﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Hims.Shared.UserModels
{
    /// <summary>
    /// The SessionAddModel.
    /// </summary>
    public class SessionAddModel
    {
        /// <summary>
        /// Gets or sets the admission id.
        /// </summary>
        public int ProviderId { get; set; }

        /// <summary>
        /// Gets or sets the location id.
        /// </summary>
        public int LocationId { get; set; }

        /// <summary>
        /// Gets or sets the from date.
        /// </summary>
        public string FromDate { get; set; }

        /// <summary>
        /// Gets or sets the to date.
        /// </summary>
        public string ToDate { get; set; }

        /// <summary>
        /// Gets or sets the slots.
        /// </summary>
        /// <value>
        /// The slots.
        /// </value>
        public List<SessionSlotsModel> Slots { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        /// <value>
        /// The created by.
        /// </value>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        /// <value>
        /// The created date.
        /// </value>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the name of the created by.
        /// </summary>
        /// <value>
        /// The name of the created by.
        /// </value>
        public string CreatedByName { get; set; }

        /// <summary>
        /// Gets or sets the name of the modified by.
        /// </summary>
        /// <value>
        /// The name of the modified by.
        /// </value>
        public string ModifiedByName { get; set; }

        /// <summary>
        /// Gets or sets the name of the doctor.
        /// </summary>
        /// <value>
        /// The name of the doctor.
        /// </value>
        public string DoctorName { get; set; }
    }

    /// <summary>
    /// The SessionSlotsModel.
    /// </summary>
    public class SessionSlotsModel
    {
        /// <summary>
        /// Gets or sets the session type identifier.
        /// </summary>
        /// <value>
        /// The session type identifier.
        /// </value>
        public int SessionTypeId { get; set; }

        /// <summary>
        /// Gets or sets the from time.
        /// </summary>
        public string FromTime { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the to time.
        /// </summary>
        public string ToTime { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the availability count.
        /// </summary>
        /// <value>
        /// The availability count.
        /// </value>
        public int AvailabilityCount { get; set; }

        /// <summary>
        /// Gets or sets the admission id.
        /// </summary>
        public int? ProviderId { get; set; }

        /// <summary>
        /// Gets or sets the location id.
        /// </summary>
        public int? LocationId { get; set; }

        /// <summary>
        /// Gets or sets the from date.
        /// </summary>
        public string FromDate { get; set; }

        /// <summary>
        /// Gets or sets the to date.
        /// </summary>
        public string ToDate { get; set; }
    }
}
