﻿#nullable enable
namespace Hims.Domain.Entities
{
    using System;
    using System.ComponentModel.DataAnnotations;
    using Shared.Dapper.Attributes;

    /// <summary>
    /// The appointment.
    /// </summary>
    public class DashboardConfig
    {
        /// <summary>
        /// Gets or sets the config id.
        /// </summary>
        [Key, Identity]
        public int DashboardConfigId { get; set; }

        /// <summary>
        /// Gets or sets the widget  id.
        /// </summary>
        public int DashboardWidgetId { get; set; }

        /// <summary>
        /// Gets or sets the dashboard configuration master identifier.
        /// </summary>
        /// <value>
        /// The dashboard configuration master identifier.
        /// </value>
        public int DashboardConfigMasterId { get; set; }

        /// <summary>
        /// Gets or sets the parameters.
        /// </summary>
        /// <value>
        /// The parameters.
        /// </value>
        public string? DefaultValues { get; set; }

        /// <summary>
        /// Gets or sets the row number.
        /// </summary>
        public int RowNumber { get; set; }

        /// <summary>
        /// Gets or sets the size.
        /// </summary>
        public int Size { get; set; }

        /// <summary>
        /// Gets or sets the sequence number.
        /// </summary>
        public int SequenceNumber { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        [IgnoreUpdate]
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }
    }
}
