﻿namespace Hims.Domain.Entities
{
    using System;
    using System.ComponentModel.DataAnnotations;
    using Shared.Dapper.Attributes;

    /// <summary>
    /// The pharmacyLog.
    /// </summary>
    public class InventoryLog
    {
        /// <summary>
        /// Gets or sets the pharmacyLog id.
        /// </summary>
        [Key, Identity]
        public int InventoryLogId { get; set; }

        /// <summary>
        /// Gets or sets the Log type.
        /// </summary>
        public int InventoryLogTypeId { get; set; }

        /// <summary>
        /// Gets or sets the log date.
        /// </summary>
        [IgnoreUpdate]
        public DateTime LogDate { get; set; }

        /// <summary>
        /// Gets or sets the app type.
        /// </summary>
        public short LogFrom { get; set; }

        /// <summary>
        /// Gets or sets the user id.
        /// </summary>
        public int? AccountId { get; set; }

        /// <summary>
        /// Gets or sets the pharmacyLog code.
        /// </summary>
        public string LogDescription { get; set; }
    }
}