﻿namespace Hims.Infrastructure.Services
{
    using Dapper;
    using Hims.Domain.Entities;
    using Hims.Domain.Repositories.UnitOfWork;
    using Hims.Domain.Services;
    using Hims.Shared.UserModels;
    using Hims.Shared.UserModels.DynamicTemplate;
    using System;
    using System.Collections.Generic;
    using System.Text;
    using System.Threading.Tasks;

    public class DynamicTemplateService : IDynamicTemplateService
    {
        /// <summary>
        /// The unit of work.
        /// </summary>
        private readonly IUnitOfWork unitOfWork;

        public DynamicTemplateService(IUnitOfWork unitOfWork) => this.unitOfWork = unitOfWork;

        public async Task<int> DeleteAsync(InsertModel model)
        {
            var query = $@"Delete from ""DynamicTemplate"" where ""DynamicTemplateId"" = {model.DynamicTemplateId}";
            return await this.unitOfWork.Current.ExecuteAsync(query);
        }

        public async Task<IEnumerable<FetchModel>> FetchAsync(FetchModel model)
        {
            var query = $@"Select dt.""DynamicTemplateId"",dt.""TemplateName"",dt.""Value"",dt.""CreatedDate"",dt.""ModifiedDate"",ac.""FullName"" as ""CreatedByName"",cc.""FullName"" as ""ModifiedByName"" from ""DynamicTemplate"" dt
                            left join ""Account"" ac on ac.""AccountId"" = dt.""CreatedBy""
                            left join ""Account"" cc on cc.""AccountId"" = dt.""ModifiedBy""";
            return await this.unitOfWork.Current.QueryAsync<FetchModel>(query);
        }

        public async Task<int> InsertAsync(InsertModel model)
        {
            var checkIf = await this.unitOfWork.Current.QuerySingleOrDefaultAsync<int>($@"Select count(*) from ""DynamicTemplate"" where lower(""TemplateName"") = '{model.TemplateName.ToLower()}'");
            if (checkIf > 0)
            {
                return -1;
            }
            var dynamicTemplate = new DynamicTemplate
            {
                TemplateName = model.TemplateName,
                Value = model.Value,
                Active = true,
                CreatedBy = model.CreatedBy,
                CreatedDate = DateTime.Now
            };
            return await this.unitOfWork.DynamicTemplates.InsertAsync(dynamicTemplate);
        }

        public async Task<int> UpdateAsync(InsertModel model)
        {
            var checkIf = await this.unitOfWork.Current.QuerySingleOrDefaultAsync<int>($@"Select count(*) from ""DynamicTemplate"" where ""TemplateName"" ='{model.TemplateName}' and ""DynamicTemplateId"" <> {model.DynamicTemplateId}");
            if (checkIf > 0)
            {
                return -1;
            }
            var record = await this.unitOfWork.DynamicTemplates.FindAsync(x => x.DynamicTemplateId == model.DynamicTemplateId);

            record.Active = true;
            record.TemplateName = model.TemplateName;
            record.Value = model.Value;
            record.ModifiedBy = model.ModifiedBy;
            record.ModifiedDate = DateTime.Now;
            return await this.unitOfWork.DynamicTemplates.UpdateAsync(record);
        }
    }
}
