import { NgModule } from '@angular/core';
import { Routes, RouterModule } from '@angular/router';
import { CubiclePage } from './pages/cubicle/cubicle.page';
import { MastersPage } from './masters.page';
import { AuthGuard } from '@src/app/shared/guards';
import { AppointmentTypePage } from './pages/appointment-types/appointment-types.page';
import { RolePage } from './pages/roles/roles.page';
import { CaseTypePage } from './pages/case-type/case-type.page';
import { ChargeManagementPage } from './pages/charge-management/charge-management.page';
import { ChargeTypesPage } from './pages/charge-types/charge-types.page';
import { ChargeCategoryPage } from './pages/charge-category/charge-category.page';
//import { ConsultationTypePage } from './pages/consultation-type/consultation-type.page';
import { AssessmentTypePage } from './pages/assessment-type/assessment-type.page';
import { DepartmentPage } from './pages/departments/department.page';
import { DietGuidLinesPage } from './pages/diet-guidlines/diet-guidlines.page';
import { SpecializationPage } from './pages/specializations/specializations.page';
import { DiscountManagementPage } from './pages/discount-management/discount-management.page';
import { DoctorAppointmentNotice } from './pages/doctor-appointment-notice/doctor-appointment-notice.page';
import { DoctorUnitPage } from './pages/doctor-unit/doctor-unit.page';
import { DynamicTemplatePage } from './pages/dynamic-template/dynamic-template.page';
import { EncounterOrderMasterPage } from './pages/encounter-order-master/encounter-order-master.page';
import { EncounterOrderTemplatesPage } from './pages/encounter-order-templates/encounter-order-templates.page';
import { EncounterTypePage } from './pages/encounter-type/encounter-type.page';
import { DischargeInstructionsPage } from './pages/discharge-instructions/discharge-instructions.page';
import { PatientImportPage } from './pages/patient-import/patient-import.page';
import { PatientRegistrationChargePage } from './pages/patient-registration/patient-registration.page';
import { PayCategoryPage } from './pages/pay-categories/pay-categories.page';
import { PayTypePage } from './pages/pay-type/pay-type.page';
import { ProviderScheduleChargesPage } from './pages/provider-schedule-charges/provider-schedule-charges.page';
import { ProviderScheduleVisitsPage } from './pages/provider-schedule-visits/provider-schedule-visits.page';
import { ReasonPage } from './pages/reasons/reasons.page';
import { ReferenceTypePage } from './pages/reference-types/reference-types.page';


const routes: Routes = [
  {
    path: "",
    data: { title: "Masters" },
    canActivate: [AuthGuard],
    canActivateChild: [AuthGuard],
    component: MastersPage,
    children: [
        { path: "", redirectTo: "cubicle", pathMatch: "full" },
        { path: "cubicle", component: CubiclePage, data: { title: "cubicle" } },
        { path: "case-type", component: CaseTypePage, data: { title: "Case-Type" } },
        { path: "appointment-types", component: AppointmentTypePage, data: { title: "Appointment Types" } },
        { path: "charge-management", component: ChargeManagementPage, data: { title: "Charge Management" } },
        { path: "charge-type", component: ChargeTypesPage, data: { title: "Charge Types" } },
        { path: "charge-category", component: ChargeCategoryPage, data: { title: "Charge Category" } },
        { path: "assessment-type", component: AssessmentTypePage, data: { title: "Assessment Management" } },
        { path: "departments", component: DepartmentPage, data: { title: "Departments" } },
        // { path: "insurances", component: InsuranceCompanyPage, data: { title: "Insurances" } },
        { path: "role", component: RolePage, data: { title: "Roles" } },
        { path: "specializations", component: SpecializationPage, data: { title: "Specializations" } },
        { path: "diet-guidlines", component: DietGuidLinesPage, data: { title: "Diet GuidLines" } },
        { path: "discharge-instructions", component: DischargeInstructionsPage, data: { title: "Discharge Instructions" } },        
        { path: "discount-management", component: DiscountManagementPage, data: { title: "Discount Management" } },
        { path: "doctor-appointment-notice", component: DoctorAppointmentNotice, data: { title: "Doctor Appointment Notice" } },
        { path: "doctor-unit", component: DoctorUnitPage, data: { title: "Doctor Unit" } },
        { path: "dynamic-template", component: DynamicTemplatePage, data: { title: "Dynamic Template" } },
        { path: "encounter-order-master", component: EncounterOrderMasterPage, data: { title: "Order Prescription Master" } },
        { path: "encounter-type", component: EncounterTypePage, data: { title: "Encounter Type" } },
        { path: "patient-import", component: PatientImportPage, data: { title: "Patient Import" } },
        { path: "patient-registration", component: PatientRegistrationChargePage, data: { title: "Patient Registration Charge" } },
        { path: "pay-categories", component: PayCategoryPage, data: { title: "Pay Categories" } },
        { path: "pay-type", component: PayTypePage, data: { title: "PayTypes" } },
        { path: "provider-schedule-charges", component: ProviderScheduleChargesPage, data: { title: "Doctor Charges" } },
        { path: "Provider-schedule-visits", component: ProviderScheduleVisitsPage, data: { title: "Doctor Visits" } },
        { path: "reason", component: ReasonPage, data: { title: "Reasons" } },
        { path: "reference-types", component: ReferenceTypePage, data: { title: "ReferenceTypes" } },
        { path: "**", redirectTo: "cubicle" },
    
    ]
  }
];

@NgModule({
  imports: [RouterModule.forChild(routes)],
  exports: [RouterModule]
})
export class MastersRoutingModule { }
