﻿import { RepeatType } from "./repeat-type.model";
import { AutomaticType } from "./automatic-type.model";

export class NewServicesModel {
    charges: Array<LabMainDetailCharge>;
    constructor() {
        this.charges = new Array<LabMainDetailCharge>();
    }

    chargeId: number;
    productId: number;
    cost: number;
    opCost: number;
    chargeName: string;
    chargeGroupName: string;
    departmentName: string;

    serviceOrderId: number;
    unit: number;
    totalCost: number;
    discountAmount: number;
    discountPercentage: number;
    status: boolean;
    repeatTypeId: RepeatType;
    automaticTypeId: AutomaticType;

    active: boolean;
    createdDate: Date;
    modifiedDate: Date;
    createdByName: string;
    modifiedByName: string;

    isMain: boolean;

    departmentId: number;
    chargeGroupId: number;

    repeatTypeName: string;
    automaticTypeName: string;

    deleting: boolean;

    totalItems: number;

    chargeTypeMainId: number;
    chargeTypeMainName: string;

    chargeTypeId: number;
    chargeTypeName: string;

    // Package Module
    showAmount: boolean;
    isInPackage: boolean;
    admissionPackageId?: number;
    packageModuleDetailId?: number;
    usedQuantity?: number;
    usedCost?: number;
}

export class LabMainDetailCharge {
    labMainDetailChargeId: number;
    labMainDetailId: number;
    chargeCategoryId: number;
    rate?: number;
    amount?: number;
    locationId: number;
    locationName: string;
    chargeCategoryName: string;
    default: boolean;
}