﻿import { RepeatType } from "./repeat-type.model";
import { AutomaticType } from "./automatic-type.model";
import { ScanChargeModel } from "../../../../shared/entities/scan-charge.entity";

export interface IScanChargeModel {
    chargeId: number;
    productId: number;
    cost: number;
    opCost: number;
    chargeName: string;
    chargeGroupName: string;
    departmentName: string;

    scanServiceId: number;
    unit: number;
    totalCost: number;
    discountAmount: number;
    discountPercentage: number;
    status: boolean;
    repeatTypeId: RepeatType;
    automaticTypeId: AutomaticType;

    active: boolean;
    createdDate: Date;
    modifiedDate: Date;
    createdByName: string;
    modifiedByName: string;

    isMain: boolean;

    departmentId: number;
    chargeGroupId: number;

    repeatTypeName: string;
    automaticTypeName: string;

    deleting: boolean;

    totalItems: number;

    chargeTypeMainId: number;
    chargeTypeMainName: string;

    chargeTypeId: number;
    chargeTypeName: string;

    // Package Module
    showAmount: boolean;
    isInPackage: boolean;
    admissionPackageId?: number;
    packageModuleDetailId?: number;
    usedQuantity?: number;
    usedCost?: number;

    modulesMasterId?: number;
    scanTestMasterId: number;
    scanTestName: string;
    charges: Array<ScanChargeModel>;
    chargeCategoryName: string;
    chargeCategoryId: number;
    name: string;
    selected: boolean;
    isSelected: boolean;

    admissionId:number;
}