﻿#nullable enable
namespace Hims.Shared.EntityModels
{
    using System;

    /// <summary>
    /// The practice location.
    /// </summary>
    public class PracticeLocationModel
    {
        /// <summary>
        /// Gets or sets the practice location id.
        /// </summary>
        public int PracticeLocationId { get; set; }

        /// <summary>
        /// Gets or sets the encrypted practice location id.
        /// </summary>
        public string? EncryptedPracticeLocationId { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the encrypted practice id.
        /// </summary>
        public string? EncryptedPracticeId { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the practice id.
        /// </summary>
        public int PracticeId { get; set; }

        /// <summary>
        /// Gets or sets the practice name.
        /// </summary>
        public string? PracticeName { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the practice TIN.
        /// </summary>
        public string? PracticeTIN { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the practice type.
        /// </summary>
        public string? PracticeType { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the full name.
        /// </summary>
        public string FullName { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the email.
        /// </summary>
        public string Email { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the phone.
        /// </summary>
        public string? Phone { get; set; }

        /// <summary>
        /// Gets or sets the extension.
        /// </summary>
        public string? Extension { get; set; }

        /// <summary>
        /// Gets or sets the street address.
        /// </summary>
        public string StreetAddress { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the address line 2.
        /// </summary>
        public string? AddressLine2 { get; set; }

        /// <summary>
        /// Gets or sets the city.
        /// </summary>
        public int City { get; set; }

        /// <summary>
        /// Gets or sets the state.
        /// </summary>
        public int State { get; set; } 

        /// <summary>
        /// Gets or sets the Zipcode.
        /// </summary>
        public string Zipcode { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the country id.
        /// </summary>
        public int CountryId { get; set; }

        /// <summary>
        /// Gets or sets the country code.
        /// </summary>
        public string CountryCode { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets a value indicating whether active.
        /// </summary>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the total items.
        /// </summary>
        public long TotalItems { get; set; }
        /// <summary>
        /// Gets or sets the locationId.
        /// </summary>
        public int LocationId { get; set; }
        /// <summary>
        /// Gets or sets the extension.
        /// </summary>
        public string? Name { get; set; }

        /// <summary>
        /// Gets or sets the location.
        /// </summary>
        /// <value>
        /// The location.
        /// </value>
        public string? Location { get; set; }

        /// <summary>
        /// Gets or sets the name loc.
        /// </summary>
        /// <value>
        /// The name loc.
        /// </value>
        public string? NameLoc { get; set; }
    }
}
