﻿namespace Hims.Shared.UserModels.Inventory
{
    using System;

    /// <summary>
    /// The inventory departmental stock model.
    /// </summary>
    public class InventoryDepartmentalStockModel
    {
        /// <summary>
        /// Gets or sets the inventory departmental stock id.
        /// </summary>
        public int InventoryDepartmentalStockId { get; set; }
                
        /// <summary>
        /// Gets or sets the inventory product id.
        /// </summary>
        public int? InventoryProductId { get; set; }

        /// <summary>
        /// Gets or sets the location identifier.
        /// </summary>
        /// <value>
        /// The location identifier.
        /// </value>
        public int? LocationId { get; set; }

        /// <summary>
        /// Gets or sets the tax id.
        /// </summary>
        public int TaxId { get; set; }

        /// <summary>
        /// Gets or sets the quantity in.
        /// </summary>
        public int QuantityIn { get; set; }

        /// <summary>
        /// Gets or sets the quantity out.
        /// </summary>
        public int QuantityOut { get; set; }

        /// <summary>
        /// Gets or sets the batch number.
        /// </summary>
        public string BatchNumber { get; set; }

        /// <summary>
        /// Gets or sets the expiry date.
        /// </summary>
        public DateTime? ExpiryDate { get; set; }

        /// <summary>
        /// Gets or sets the purchase rate.
        /// </summary>
        public double PurchaseRate { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the product name.
        /// </summary>
        public string ProductName { get; set; }

        /// <summary>
        /// Gets or sets the category name.
        /// </summary>
        public string CategoryName { get; set; }

        /// <summary>
        /// Gets or sets the tax percentage.
        /// </summary>
        public string TaxPercentage { get; set; }

        /// <summary>
        /// Gets or sets the available quantity.
        /// </summary>
        public int AvailableQuantity { get; set; }

        /// <summary>
        /// Gets or sets the discount percentage.
        /// </summary>
        public double? DiscountPercentage { get; set; }

        /// <summary>
        /// Gets or sets the page size.
        /// </summary>
        public int? PageSize { get; set; }

        /// <summary>
        /// Gets or sets the page index.
        /// </summary>
        public int? PageIndex { get; set; }

        /// <summary>
        /// Gets or sets the total items.
        /// </summary>
        public int? TotalItems { get; set; }
        
        /// <summary>
        /// Gets or sets the inventory ware house identifier.
        /// </summary>
        /// <value>
        /// The inventory ware house identifier.
        /// </value>
        public int? InventoryWareHouseId { get; set; }

        /// <summary>
        /// Gets or sets the modified name.
        /// </summary>
        public string ModifiedName { get; set; }

        /// <summary>
        /// Gets or sets the inventory department identifier.
        /// </summary>
        /// <value>
        /// The inventory department identifier.
        /// </value>
        public int? InventoryDepartmentId { get; set; }

        /// <summary>
        /// Gets or sets the name of the department.
        /// </summary>
        /// <value>
        /// The name of the department.
        /// </value>
        public string DepartmentName { get; set; }

        /// <summary>
        /// Gets or sets the name of the rack.
        /// </summary>
        /// <value>
        /// The name of the rack.
        /// </value>
        public string RackName { get; set; }

        /// <summary>
        /// Gets or sets the unavailable stock.
        /// </summary>
        /// <value>
        /// The unavailable stock.
        /// </value>
        public string UnavailableStock { get; set; }

        /// <summary>
        /// Gets or sets the inventory product detail identifier.
        /// </summary>
        /// <value>
        /// The inventory product detail identifier.
        /// </value>
        public int? InventoryProductDetailId { get; set; }

        /// <summary>
        /// Gets or sets the roq.
        /// </summary>
        /// <value>
        /// The roq.
        /// </value>
        public int? ROQ { get; set; }

        /// <summary>
        /// Gets or sets the rol.
        /// </summary>
        /// <value>
        /// The rol.
        /// </value>
        public int? ROL { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is expiry product.
        /// </summary>
        /// <value>
        ///   <c>true</c> if this instance is expiry product; otherwise, <c>false</c>.
        /// </value>
        public bool IsExpiryProduct { get; set; }
    }
}
