﻿using System;
using System.Collections.Generic;

namespace Hims.Shared.UserModels.NurseShift
{
    /// <summary>
    /// The basic bed Nurse Shift Map.
    /// </summary>
    public class UpdateModel
    {
        /// <summary>
        /// Gets or sets the nurse identifier.
        /// </summary>
        /// <value>
        /// The nurse identifier.
        /// </value>
        public string Id { get; set; }

        /// <summary>
        /// Gets or sets the nurse identifier.
        /// </summary>
        /// <value>
        /// The nurse identifier.
        /// </value>
        public int NurseId { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        /// <value>
        /// The created by.
        /// </value>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is single.
        /// </summary>
        /// <value>
        ///   <c>true</c> if this instance is single; otherwise, <c>false</c>.
        /// </value>
        public bool IsSingle { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is remove.
        /// </summary>
        /// <value>
        ///   <c>true</c> if this instance is remove; otherwise, <c>false</c>.
        /// </value>
        public bool IsRemove { get; set; }

        /// <summary>
        /// Gets or sets the shifts.
        /// </summary>
        /// <value>
        /// The shifts.
        /// </value>
        public List<UpdateShiftModel> Shifts { get; set; }
    }

    /// <summary>
    /// The basic bed Nurse Shift Map.
    /// </summary>
    public class UpdateShiftModel
    {
        /// <summary>
        /// Gets or sets the bed ids.
        /// </summary>
        /// <value>
        /// The bed ids.
        /// </value>
        public List<int> RemovedBedIds { get; set; }

        /// <summary>
        /// Gets or sets the added bed ids.
        /// </summary>
        /// <value>
        /// The added bed ids.
        /// </value>
        public List<int> AddedBedIds { get; set; }

        /// <summary>
        /// Gets or sets the bed ids.
        /// </summary>
        /// <value>
        /// The bed ids.
        /// </value>
        public List<int> BedIds { get; set; }

        /// <summary>
        /// Gets or sets the nurse shift map identifier.
        /// </summary>
        /// <value>
        /// The nurse shift map identifier.
        /// </value>
        public int? NurseShiftMapId { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is remove.
        /// </summary>
        /// <value>
        ///   <c>true</c> if this instance is remove; otherwise, <c>false</c>.
        /// </value>
        public bool IsRemove { get; set; }

        /// <summary>
        /// Gets or sets the shift identifier.
        /// </summary>
        /// <value>
        /// The shift identifier.
        /// </value>
        public int ShiftId { get; set; }

        /// <summary>
        /// Gets or sets from date.
        /// </summary>
        /// <value>
        /// From date.
        /// </value>
        public DateModel FromDate { get; set; }

        /// <summary>
        /// Converts to date.
        /// </summary>
        /// <value>
        /// To date.
        /// </value>
        public DateModel ToDate { get; set; }
    }
}