﻿namespace Hims.Shared.UserModels.PackageModule
{
    public class ModuleModel
    {
        /// <summary>
        /// Gets or sets the modules master identifier.
        /// </summary>
        /// <value>
        /// The modules master identifier.
        /// </value>
        public int ModulesMasterId { get; set; }

        /// <summary>
        /// Gets or sets the name of the module.
        /// </summary>
        /// <value>
        /// The name of the module.
        /// </value>
        public string ModuleName { get; set; }

        /// <summary>
        /// Gets or sets the module icon.
        /// </summary>
        /// <value>
        /// The module icon.
        /// </value>
        public string ModuleIcon { get; set; }

        /// <summary>
        /// Gets or sets the type of the package.
        /// </summary>
        /// <value>
        /// The type of the package.
        /// </value>
        public string PackageType { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is charge category applicable.
        /// </summary>
        /// <value>
        ///   <c>true</c> if this instance is charge category applicable; otherwise, <c>false</c>.
        /// </value>
        public bool IsChargeCategoryApplicable { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is package applicable.
        /// </summary>
        /// <value>
        ///   <c>true</c> if this instance is package applicable; otherwise, <c>false</c>.
        /// </value>
        public bool IsPackageApplicable { get; set; }
    }
}