﻿namespace Hims.Domain.Entities
{
    using Hims.Shared.Dapper.Attributes;
    using System;
    using System.ComponentModel.DataAnnotations;

    /// <summary>
    /// The lab booking package detail.
    /// </summary>
    public class LabBookingPackageDetail
    {
        /// <summary>
        /// Gets or sets the lab booking package detail id.
        /// </summary>
        [Key, Identity]
        public int LabBookingPackageDetailId { get; set; }

        /// <summary>
        /// Gets or sets the lab booking detail id.
        /// </summary>
        public int LabBookingDetailId { get; set; }

        /// <summary>
        /// Gets or sets the lab header id.
        /// </summary>
        public int LabHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the status.
        /// </summary>
        public string Status { get; set; }

        /// <summary>
        /// Gets or sets the is report generated.
        /// </summary>
        public bool? IsReportGenerated { get; set; }

        /// <summary>
        /// Gets or sets the is sample collected.
        /// </summary>
        public bool? IsSampleCollected { get; set; }

        /// <summary>
        /// Gets or sets the report date.
        /// </summary>
        public DateTime? ReportDate { get; set; }

        /// <summary>
        /// Gets or sets the sample date.
        /// </summary>
        public DateTime? SampleDate { get; set; }

        /// <summary>
        /// Gets or sets the typed date.
        /// </summary>
        public DateTime? TypedDate { get; set; }

        /// <summary>
        /// Gets or sets the typed by.
        /// </summary>
        public int? TypedBy { get; set; }

        /// <summary>
        /// Gets or sets the verified by.
        /// </summary>
        public int? VerifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the verified by doctor identifier.
        /// </summary>
        /// <value>
        /// The verified by doctor identifier.
        /// </value>
        public int? VerifiedByDoctorId { get; set; }

        /// <summary>
        /// Gets or sets the collected sample received by.
        /// </summary>
        /// <value>
        /// The collected sample received by.
        /// </value>
        public int? CollectedSampleReceivedBy { get; set; }

        /// <summary>
        /// Gets or sets the collected sample received by.
        /// </summary>
        /// <value>
        /// The collected sample received by.
        /// </value>
        public int? SampleCollectedBy { get; set; }

        /// <summary>
        /// Gets or sets the barcode identifier.
        /// </summary>
        /// <value>
        /// The barcode identifier.
        /// </value>

        public bool Barcode { get; set; }

        /// <summary>
        /// Gets or sets the barcode generated by identifier.
        /// </summary>
        /// <value>
        /// The barcode  generated by identifier.
        /// </value>

        public int? BarcodeGeneratedBy { get; set; }

        /// <summary>
        /// Gets or sets the borcode generated date.
        /// </summary>
        /// <value>
        /// The borcode generated date identifier.
        /// </value>

        public DateTime? BarcodeGeneratedDate { get; set; }

    }
}
