﻿#nullable enable
namespace Hims.Domain.Entities
{
    using System;
    using System.ComponentModel.DataAnnotations;
    using Shared.Dapper.Attributes;

    /// <summary>
    /// The account.
    /// </summary>
    public class ProgressReportMedicationDaily
    {
        /// <summary>
        /// Gets or sets the account id.
        /// </summary>
        [Key, Identity]
        public int ProgressReportMedicationDailyId { get; set; }

        /// <summary>
        /// Gets or sets the role id.
        /// </summary>
        public int ProgressReportMedicationFrequencyId { get; set; }

        /// <summary>
        /// Gets or sets the salt key.
        /// </summary>
        [IgnoreUpdate]
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the Guid.
        /// </summary>
        [IgnoreUpdate]
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the medication date.
        /// </summary>
        /// <value>
        /// The medication date.
        /// </value>
        public DateTime MedicationDate { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        /// <value>
        /// The modified date.
        /// </value>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        /// <value>
        /// The modified by.
        /// </value>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this <see cref="ProgressReportMedicationDaily"/> is status.
        /// </summary>
        /// <value>
        ///   <c>true</c> if status; otherwise, <c>false</c>.
        /// </value>
        public bool Status { get; set; }

    }
}