﻿namespace Hims.Domain.Entities
{
    using System;
    using System.ComponentModel.DataAnnotations;
    using Shared.Dapper.Attributes;

    /// <summary>
    /// The Scan Appointment Notice.
    /// </summary>
    public class ScanAppointmentNotice
    {
        /// <summary>
        /// Gets or sets Scan Appointment Notice Id.
        /// </summary>
        [Key, Identity]
        public int ScanAppointmentNoticeId { get; set; }

        /// <summary>
        /// Gets or sets Location Id.
        /// </summary>
        public int LocationId { get; set; }

        /// <summary>
        /// Gets or sets Machine Id.
        /// </summary>
        public int MachineId { get; set; }

        /// <summary>
        /// Gets or sets From Date.
        /// </summary>
        public DateTime FromDate { get; set; }

        /// <summary>
        /// Gets or sets To Date.
        /// </summary>
        public DateTime ToDate { get; set; }

        /// <summary>
        /// Gets or sets Description.
        /// </summary>
        public string Description { get; set; }      

        /// <summary>
        /// Gets or sets a value indicating whether active.
        /// </summary>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        [IgnoreUpdate]
        public int? CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        [IgnoreUpdate]
        public DateTime? CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the availability.
        /// </summary>
        public string? Availability { get; set; }

        /// <summary>
        /// gets or sets the available days.
        /// </summary>
        public string? AvailableDays { get; set; }

    }
}
