﻿namespace Hims.Domain.Repositories.UnitOfWork
{
    using System;
    using System.Collections.Generic;
    using System.Data;
    using System.Threading.Tasks;
    using Dapper;
    using Entities;
    using Entities.Pharmacy;
    using Entities.Inventory;
    using Entities.ProviderMedication;
    using Entities.Labs;
    using Entities.ChargeModules;
    using Entities.Vendors;
    using Entities.EncounterTemplates;
    using Hims.Shared.EntityModels;
    using Hims.Domain.Entities.Vaccine;
    using Hims.Domain.Entities.PediatricGraph;

    /// <inheritdoc />
    /// <summary>
    /// The Unit Of Work.
    /// </summary>
    public interface IUnitOfWork : IDisposable
    {
        /// <summary>
        /// Gets the connection.
        /// </summary>
        IDbConnection Current { get; }

        /// <summary>
        /// Gets the accounts.
        /// </summary>
        IDapperRepository<Account> Accounts { get; }

        /// <summary>
        /// Gets the account credential.
        /// </summary>
        IDapperRepository<AccountCredential> AccountCredentials { get; }

        /// <summary>
        /// Gets the account sessions.
        /// </summary>
        IDapperRepository<AccountSession> AccountSessions { get; }

        /// <summary>
        /// Gets the users.
        /// </summary>
        IDapperRepository<User> Users { get; }

        /// <summary>
        /// Gets the appointments.
        /// </summary>
        IDapperRepository<Appointment> Appointments { get; }

        IDapperRepository<Counselling> Counsellings { get; }


        /// <summary>
        /// Gets the bedManagements.
        /// </summary>
        IDapperRepository<Ward> Wards { get; }

        /// <summary>
        /// Gets the bedManagements.
        /// </summary>
        IDapperRepository<Bed> Beds { get; }
        /// <summary>
        /// Gets the bedManagements.
        /// </summary>
        IDapperRepository<ContactDetails> contactDetailss { get; }
        /// <summary>
        /// Gets the bedManagements.
        /// </summary>
        IDapperRepository<FeedbackDetails> Feedbackdetails { get; }
        
        /// <summary>
        /// Gets the bedManagements.
        /// </summary>
        IDapperRepository<CallHistory> CallHistorys { get; }

        /// <summary>
        /// Gets the bedManagements.
        /// </summary>
        IDapperRepository<Room> Rooms { get; }

        /// <summary>
        /// Gets the bedManagements.
        /// </summary>
        IDapperRepository<Department> Departments { get; }

        /// <summary>
        /// Gets the bedManagements.
        /// </summary>
        IDapperRepository<ChargeGroup> ChargeGroups { get; }

        /// <summary>
        /// Gets the bedManagements.
        /// </summary>
        IDapperRepository<Charge> Charges { get; }

        /// <summary>
        /// Gets the appointment symptoms.
        /// </summary>
        IDapperRepository<AppointmentSymptom> AppointmentSymptoms { get; }

        /// <summary>
        /// Gets the appointment logs.
        /// </summary>
        IDapperRepository<AppointmentLog> AppointmentLogs { get; }

        /// <summary>
        /// Gets the appointment status.
        /// </summary>
        IDapperRepository<AppointmentTransaction> AppointmentTransactions { get; }

        /// <summary>
        /// Gets the appointment exception log.
        /// </summary>
        IDapperRepository<AppointmentExceptionLog> AppointmentExceptionLogs { get; }

        /// <summary>
        /// Gets the Admission.
        /// </summary>
        IDapperRepository<Admission> Admission { get; }

        /// <summary>
        /// Gets the audit logs.
        /// </summary>
        IDapperRepository<AuditLog> AuditLogs { get; }

        /// <summary>
        /// Gets the patients.
        /// </summary>
        IDapperRepository<Country> Countries { get; }

        /// <summary>
        /// Gets the coupons.
        /// </summary>
        IDapperRepository<Coupon> Coupons { get; }

        /// <summary>
        /// Gets the insurance companies.
        /// </summary>
        IDapperRepository<InsuranceCompany> InsuranceCompanies { get; }

        /// <summary>
        /// Gets the patients.
        /// </summary>
        IDapperRepository<Patient> Patients { get; }
        /// <summary>
        /// Gets the patient documents.
        /// </summary>
        IDapperRepository<PatientDocument> PatientDocuments { get; }

        /// <summary>
        /// Gets the payment documents.
        /// </summary>
        IDapperRepository<PaymentDocument> PaymentDocuments { get; }

        /// <summary>
        /// Gets the patient emergencies.
        /// </summary>
        IDapperRepository<PatientEmergency> PatientEmergencies { get; }

        /// <summary>
        /// Gets the patient insurances.
        /// </summary>
        IDapperRepository<PatientInsurance> PatientInsurances { get; }

        /// <summary>
        /// Gets the insurances approval.
        /// </summary>
        IDapperRepository<InsuranceApproval> InsuranceApproval { get; }

        /// <summary>
        /// Gets the practices.
        /// </summary>
        IDapperRepository<Practice> Practices { get; }

        /// <summary>
        /// Gets the providers.
        /// </summary>
        IDapperRepository<Provider> Providers { get; }

        /// <summary>
        /// Gets the provider encounters.
        /// </summary>
        IDapperRepository<ProviderEncounter> ProviderEncounters { get; }

        /// <summary>
        /// Gets the lab order value.
        /// </summary>
        IDapperRepository<LabOrderValue> LabOrderValues { get; }

        /// <summary>Gets the lab order.</summary>
        IDapperRepository<LabOrder> LabOrder { get; }

        /// <summary>Gets the radiology.</summary>
        IDapperRepository<Radiology> Radiology { get; }

        /// <summary>Gets the radiology values.</summary>
        IDapperRepository<RadiologyValue> RadiologyValues { get; }

        /// <summary>
        /// Gets the provider bank accounts.
        /// </summary>
        IDapperRepository<ProviderBankAccount> ProviderBankAccounts { get; }

        /// <summary>
        /// Gets the provider locations.
        /// </summary>
        IDapperRepository<ProviderLocation> ProviderLocations { get; }

        /// <summary>
        /// Gets the provider documents.
        /// </summary>
        IDapperRepository<ProviderDocument> ProviderDocuments { get; }

        /// <summary>
        /// Gets the roles.
        /// </summary>
        IDapperRepository<Role> Roles { get; }

        /// <summary>
        /// Gets the roles.
        /// </summary>
        IDapperRepository<DischargeInstruction> DischargeInstructions { get; }

        /// <summary>
        /// Gets the services.
        /// </summary>
        IDapperRepository<Service> Services { get; }

        /// <summary>
        /// Gets the specializations.
        /// </summary>
        IDapperRepository<Specialization> Specializations { get; }

        /// <summary>
        /// Gets the Lookups.
        /// </summary>
        IDapperRepository<Lookup> Lookups { get; }

        /// <summary>
        /// Gets the LookupValues.
        /// </summary>
        IDapperRepository<LookupValue> LookupValues { get; }

        /// <summary>
        /// Gets the ICDCodes.
        /// </summary>
        IDapperRepository<ICDCode> ICDCodes { get; }

        /// <summary>
        /// Gets the CPTCodes.
        /// </summary>
        IDapperRepository<CPTCode> CPTCodes { get; }

        /// <summary>
        /// Gets the Encounters.
        /// </summary>
        IDapperRepository<Encounter> Encounters { get; }

        /// <summary>
        /// Gets the provider leave.
        /// </summary>
        IDapperRepository<ProviderLeave> ProviderLeaves { get; }

        /// <summary>
        /// Gets the video call histories.
        /// </summary>
        IDapperRepository<VideoCallHistory> VideoCallHistories { get; }

        /// <summary>
        /// Gets the doctor device details.
        /// </summary>
        IDapperRepository<DoctorDeviceDetails> DoctorDeviceDetails { get; }

        /// <summary>
        /// Gets the patient device details.
        /// </summary>
        IDapperRepository<PatientDeviceDetails> PatientDeviceDetails { get; }

        /// <summary>
        /// Gets the patient device details.
        /// </summary>
        IDapperRepository<BehavioralHealth> BehavioralHealth { get; }

        /// <summary>Gets the homeopathy.</summary>
        IDapperRepository<Homeopathy> Homeopathy { get; }

        /// <summary>
        /// Gets the ticket.
        /// </summary>
        IDapperRepository<Ticket> Tickets { get; }

        /// <summary>
        /// Gets the dental encounter.
        /// </summary>
        IDapperRepository<DentalEncounter> DentalEncounter { get; }

        /// <summary>
        /// Gets the web telemedicine.
        /// </summary>
        IDapperRepository<WebTelemedicine> WebTelemedicine { get; }

        /// <summary>
        /// Gets the web telemedicine.
        /// </summary>
        IDapperRepository<SupportCategory> SupportCategory { get; }

        /// <summary>
        /// Gets the ticket timeline.
        /// </summary>
        IDapperRepository<TicketTimeline> TicketTimeline { get; }

        /// <summary>Gets the chats.</summary>
        IDapperRepository<Chat> Chats { get; }

        /// <summary>Gets the general advices.</summary>
        IDapperRepository<GeneralAdvice> GeneralAdvices { get; }

        /// <summary>
        /// Gets the refunds.
        /// </summary>
        IDapperRepository<Refund> Refunds { get; }

        /// <summary>
        /// Gets the refunds.
        /// </summary>
        IDapperRepository<Feedback> Feedbacks { get; }

        /// <summary>
        /// Gets the refunds.
        /// </summary>
        IDapperRepository<QuestionFeedback> QuestionFeedbacks { get; }

        /// <summary>
        /// Gets the telemedicine history.
        /// </summary>
        IDapperRepository<TelemedicineHistory> TelemedicineHistory { get; }

        /// <summary>
        /// Gets the telemedicine users history.
        /// </summary>
        IDapperRepository<TelemedicineCallHistory> TelemedicineCallHistory { get; }

        /// <summary>
        /// Gets the telemedicine users history.
        /// </summary>
        IDapperRepository<TelemedicineUsersHistory> TelemedicineUsersHistory { get; }

        /// <summary>
        /// Gets the telemedicine domain.
        /// </summary>
        IDapperRepository<TelemedicineDomain> TelemedicineDomain { get; }

        /// <summary>
        /// Gets the ticket assignees.
        /// </summary>
        IDapperRepository<TicketAssignee> TicketAssignees { get; }

        /// <summary>
        /// Gets the payment status.
        /// </summary>
        IDapperRepository<PaymentStatus> PaymentStatus { get; }

        /// <summary>
        /// Gets the web hook.
        /// </summary>
        IDapperRepository<WebHook> WebHook { get; }

        /// <summary>
        /// Gets the problem list.
        /// </summary>
        IDapperRepository<ProblemList> ProblemList { get; }

        /// <summary>
        /// Gets the login.
        /// </summary>
        IDapperRepository<Login> Login { get; }

        /// <summary>
        /// Gets the appointment support log repository.
        /// </summary>
        IDapperRepository<AppointmentSupportLog> AppointmentSupportLogRepository { get; }

        /// <summary>
        /// Gets the timeline repository.
        /// </summary>
        IDapperRepository<Timeline> Timeline { get; }

        /// <summary>
        /// Gets the timeline data.
        /// </summary>
        IDapperRepository<TimelineData> TimelineData { get; }

        /// <summary>
        /// Gets the patient family.
        /// </summary>
        IDapperRepository<PatientFamily> PatientFamily { get; }

        /// <summary>
        /// Gets the languages.
        /// </summary>
        IDapperRepository<Language> Languages { get; }

        /// <summary>
        /// Gets the icons.
        /// </summary>
        IDapperRepository<Icons> Icons { get; }

        /// <summary>
        /// Gets the notification log.
        /// </summary>
        IDapperRepository<NotificationLog> NotificationLog { get; }

        /// <summary>
        /// Gets the message.
        /// </summary>
        IDapperRepository<Message> Message { get; }

        /// <summary>
        /// Gets the wallet.
        /// </summary>
        IDapperRepository<Wallet> Wallet { get; }

        /// <summary>
        /// Gets the supplier.
        /// </summary>
        IDapperRepository<Supplier> Supplier { get; }

        /// <summary>
        /// Gets the company.
        /// </summary>
        IDapperRepository<Company> Company { get; }

        /// <summary>
        /// Gets the inventory products.
        /// </summary>
        IDapperRepository<InventoryProduct> InventoryProducts { get; }

        /// <summary>
        /// Gets the inventory purchase headers.
        /// </summary>
        IDapperRepository<InventoryPurchaseHeader> InventoryPurchaseHeaders { get; }

        /// <summary>
        /// Gets the inventory stocks.
        /// </summary>
        IDapperRepository<InventoryStock> InventoryStocks { get; }

        /// <summary>
        /// Gets the inventory purchase details.
        /// </summary>
        IDapperRepository<InventoryPurchaseDetail> InventoryPurchaseDetails { get; }

        /// <summary>
        /// Gets the inventory purchase return headers.
        /// </summary>
        IDapperRepository<InventoryPurchaseReturnHeader> InventoryPurchaseReturnHeaders { get; }

        /// <summary>
        /// Gets the inventory purchase return details.
        /// </summary>
        IDapperRepository<InventoryPurchaseReturnDetail> InventoryPurchaseReturnDetails { get; }

        /// <summary>
        /// Gets the receipt.
        /// </summary>
        /// <value>
        /// The receipt.
        /// </value>
        IDapperRepository<Receipt> Receipt { get; }

        /// <summary>
        /// Gets the service order.
        /// </summary>
        /// <value>
        /// The service order.
        /// </value>
        IDapperRepository<ServiceOrder> ServiceOrder { get; }

        /// <summary>
        /// Gets the service order.
        /// </summary>
        /// <value>
        /// The service order.
        /// </value>
        IDapperRepository<LabServices> LabServices { get; }

        /// <summary>
        /// Gets the final bill.
        /// </summary>
        /// <value>
        /// The final bill.
        /// </value>
        IDapperRepository<FinalBill> FinalBill { get; }

        /// <summary>
        /// Gets the final bill service order.
        /// </summary>
        /// <value>
        /// The final bill service order.
        /// </value>
        IDapperRepository<FinalBillServiceOrder> FinalBillServiceOrder { get; }

        /// <summary>
        /// Gets the indent headers.
        /// </summary>
        IDapperRepository<IndentHeader> IndentHeaders { get; }

        /// <summary>
        /// Gets the indent details.
        /// </summary>
        IDapperRepository<IndentDetail> IndentDetails { get; }

        /// <summary>
        /// Gets the issue headers.
        /// </summary>
        IDapperRepository<IssueHeader> IssueHeaders { get; }

        /// <summary>
        /// Gets the issue details.
        /// </summary>
        IDapperRepository<IssueDetail> IssueDetails { get; }

        /// <summary>
        /// Gets the discharge.
        /// </summary>
        /// <value>
        /// The discharge.
        /// </value>
        IDapperRepository<Discharge> Discharge { get; }

        /// <summary>
        /// Gets the menu.
        /// </summary>
        IDapperRepository<Menu> Menu { get; }

        /// <summary>
        /// Gets the menu access.
        /// </summary>
        /// <value>
        /// The menu access.
        /// </value>
        IDapperRepository<MenuAccess> MenuAccess { get; }

        /// <summary>
        /// Gets the menu relationship.
        /// </summary>
        /// <value>
        /// The menu relationship.
        /// </value>
        IDapperRepository<MenuRelationship> MenuRelationship { get; }

        /// <summary>
        /// Gets the pharmacy products.
        /// </summary>
        IDapperRepository<PharmacyProduct> PharmacyProducts { get; }

        /// <summary>
        /// Gets the pharmacy purchase headers.
        /// </summary>
        IDapperRepository<PharmacyPurchaseHeader> PharmacyPurchaseHeaders { get; }

        /// <summary>
        /// Gets the pharmacy stocks.
        /// </summary>
        IDapperRepository<PharmacyStock> PharmacyStocks { get; }

        /// <summary>
        /// Gets the pharmacy purchase details.
        /// </summary>
        IDapperRepository<PharmacyPurchaseDetail> PharmacyPurchaseDetails { get; }

        /// <summary>
        /// Gets the pharmacy purchase details.
        /// </summary>
        IDapperRepository<PatientConfiguration> PatientConfigurations { get; }

        /// <summary>
        /// Gets the pharmacy retail stocks.
        /// </summary>
        IDapperRepository<PharmacyRetailStock> PharmacyRetailStocks { get; }

        /// <summary>
        /// Gets the pharmacy sale headers.
        /// </summary>
        IDapperRepository<PharmacySaleHeader> PharmacySaleHeaders { get; }

        /// <summary>
        /// Gets the pharmacy sale details.
        /// </summary>
        IDapperRepository<PharmacySaleDetail> PharmacySaleDetails { get; }

        /// <summary>
        /// Gets the surgery kit headers.
        /// </summary>
        IDapperRepository<SurgeryKitHeader> SurgeryKitHeaders { get; }

        /// <summary>
        /// Gets the surgery kit details.
        /// </summary>
        IDapperRepository<SurgeryKitDetail> SurgeryKitDetails { get; }

        /// <summary>
        /// Gets the pharmacy indent headers.
        /// </summary>
        IDapperRepository<PharmacyIndentHeader> PharmacyIndentHeaders { get; }

        /// <summary>
        /// Gets the pharmacy indent details.
        /// </summary>
        IDapperRepository<PharmacyIndentDetail> PharmacyIndentDetails { get; }

        /// <summary>
        /// Gets the pharmacy issue headers.
        /// </summary>
        IDapperRepository<PharmacyIssueHeader> PharmacyIssueHeaders { get; }

        /// <summary>
        /// Gets the pharmacy issue details.
        /// </summary>
        IDapperRepository<PharmacyIssueDetail> PharmacyIssueDetails { get; }

        /// <summary>
        /// Gets the sale return headers.
        /// </summary>
        IDapperRepository<SaleReturnHeader> SaleReturnHeaders { get; }

        /// <summary>
        /// Gets the sale return details.
        /// </summary>
        IDapperRepository<SaleReturnDetail> SaleReturnDetails { get; }

        /// <summary>
        /// Gets the package.
        /// </summary>
        /// <value>
        /// The package.
        /// </value>
        IDapperRepository<Package> Package { get; }

        /// <summary>
        /// Gets the package charge.
        /// </summary>
        /// <value>
        /// The package charge.
        /// </value>
        IDapperRepository<PackageCharge> PackageCharge { get; }

        /// <summary>
        /// Gets the admission package.
        /// </summary>
        /// <value>
        /// The admission package.
        /// </value>
        IDapperRepository<AdmissionPackage> AdmissionPackage { get; }

        /// <summary>
        /// Gets the lab headers.
        /// </summary>
        IDapperRepository<LabHeader> LabHeaders { get; }

        /// <summary>
        /// Gets the lab details.
        /// </summary>
        IDapperRepository<LabDetail> LabDetails { get; }

        /// <summary>
        /// Gets the lab booking headers.
        /// </summary>
        IDapperRepository<LabBookingHeader> LabBookingHeaders { get; }

        /// <summary>
        /// Gets the lab booking details.
        /// </summary>
        IDapperRepository<LabBookingDetail> LabBookingDetails { get; }

        /// <summary>
        /// Gets the lab patient parameters.
        /// </summary>
        IDapperRepository<LabPatientParameter> LabPatientParameters { get; }

        /// <summary>
        /// Gets the progress report.
        /// </summary>
        /// <value>
        /// The progress report.
        /// </value>
        IDapperRepository<ProgressReport> ProgressReport { get; }

        /// <summary>
        /// Gets the progress report medication.
        /// </summary>
        /// <value>
        /// The progress report medication.
        /// </value>
        IDapperRepository<ProgressReportMedication> ProgressReportMedication { get; }

        /// <summary>
        /// Gets the progress report medication daily.
        /// </summary>
        /// <value>
        /// The progress report medication daily.
        /// </value>
        IDapperRepository<ProgressReportMedicationDaily> ProgressReportMedicationDaily { get; }

        /// <summary>
        /// Gets the pharmacy retail to mains.
        /// </summary>
        IDapperRepository<PharmacyRetailToMain> PhamrmacyRetailToMains { get; }

        /// <summary>
        /// Gets the pharmacy purchase return headers.
        /// </summary>
        IDapperRepository<PharmacyPurchaseReturnHeader> PharmacyPurchaseReturnHeaders { get; }

        /// <summary>
        /// Gets the pharmacy purchase return details.
        /// </summary>
        IDapperRepository<PharmacyPurchaseReturnDetail> PharmacyPurchaseReturnDetails { get; }

        /// <summary>
        /// Gets the lab packages.
        /// </summary>
        IDapperRepository<LabPackage> LabPackages { get; }

        /// <summary>
        /// Gets the lab packages details.
        /// </summary>
        IDapperRepository<LabPackageDetail> LabPackageDetails { get; }

        /// <summary>
        /// Gets the lab booking package detail.
        /// </summary>
        IDapperRepository<LabBookingPackageDetail> LabBookingPackageDetails { get; }

        /// <summary>
        /// Gets the sms log.
        /// </summary>
        IDapperRepository<SMSLog> SMSLogs { get; }

        /// <summary>
        /// Gets the excel upload history.
        /// </summary>
        IDapperRepository<ExcelUploadHistory> ExcelUploadHistory { get; }

        /// <summary>
        /// Gets the Widget.
        /// </summary>
        IDapperRepository<DashboardWidget> DashboardWidget { get; }


        /// <summary>
        /// Gets the config.
        /// </summary>
        IDapperRepository<DashboardConfig> DashboardConfig { get; }


        /// <summary>
        /// Gets the Widget.
        /// </summary>
        IDapperRepository<DashboardWidgetRole> DashboardWidgetRole { get; }

        /// <summary>
        /// Gets the dashboard configuration master.
        /// </summary>
        /// <value>
        /// The dashboard configuration master.
        /// </value>
        IDapperRepository<DashboardConfigMaster> DashboardConfigMaster { get; }

        /// <summary>
        /// Gets the pharmacy logs.
        /// </summary>
        IDapperRepository<PharmacyLog> PharmacyLogs { get; }
        /// <summary>
        /// Gets the inventory logs.
        /// </summary>
        IDapperRepository<InventoryLog> InventoryLogs { get; }

        /// <summary>
        /// Gets the pharmacy logs.
        /// </summary>
        IDapperRepository<LabLog> LabLogs { get; }

        /// <summary>
        /// Gets the Scan logs.
        /// </summary>
        IDapperRepository<ScanLog> ScanLogs { get; }

        /// <summary>
        /// Gets the DynamicReports .
        /// </summary>
        IDapperRepository<DynamicReport> DynamicReports { get; }

        /// <summary>
        /// Gets the visit types.
        /// </summary>
        IDapperRepository<VisitType> Visitors { get; }

        /// <summary>
        /// Gets the charge types.
        /// </summary>
        IDapperRepository<ChargeTypes> ChargeTypes { get; }

        /// <summary>
        /// Gets the charge types.
        /// </summary>
        IDapperRepository<PrintSetting> PrintSetting { get; }

        /// <summary>
        /// Gets the bedManagements.
        /// </summary>
        IDapperRepository<Floor> Floors { get; }

        /// <summary>
        /// Gets the tpa.
        /// </summary>
        /// <value>
        /// The tpa.
        /// </value>
        IDapperRepository<Tpa> Tpa { get; }

        /// <summary>
        /// Gets the retail pharmacy.
        /// </summary>
        IDapperRepository<RetailPharmacy> RetailPharmacy { get; }

        /// <summary>
        /// Gets the surgeons.
        /// </summary>
        /// <value>
        /// The surgeons.
        /// </value>
        IDapperRepository<Surgeons> Surgeons { get; }

        /// <summary>
        /// Gets the ot Call Log,
        /// </summary>
        IDapperRepository<CallLog> CallLog { get; }


        /// <summary>
        /// Gets the telemedicine template history.
        /// </summary>
        /// <value>
        /// The telemedicine template history.
        /// </value>
        IDapperRepository<TelemedicineTemplateHistory> TelemedicineTemplateHistory { get; }

        /// <summary>
        /// Gets the telemedicine template.
        /// </summary>
        /// <value>
        /// The telemedicine template.
        /// </value>
        IDapperRepository<TelemedicineTemplate> TelemedicineTemplate { get; }

        /// <summary>
        /// Gets the insurance for admissions.
        /// </summary>
        IDapperRepository<InsuranceForAdmission> InsuranceForAdmissions { get; }

        /// <summary>
        /// Gets the insurance timelines.
        /// </summary>
        IDapperRepository<InsuranceTimeline> InsuranceTimelines { get; }

        /// <summary>
        /// Gets the slots.
        /// </summary>
        IDapperRepository<ShiftSlot> ShiftSlots { get; }

        /// <summary>
        /// Gets the shifts.
        /// </summary>
        IDapperRepository<Shift> Shifts { get; }

        /// <summary>
        /// Gets the shift slot map.
        /// </summary>
        IDapperRepository<ShiftSlotMap> ShiftSlotMap { get; }

        /// <summary>
        /// Gets the progress report medication frequency.
        /// </summary>
        /// <value>
        /// The progress report medication frequency.
        /// </value>
        IDapperRepository<ProgressReportMedicationFrequency> ProgressReportMedicationFrequency { get; }

        /// <summary>
        /// Gets the progress report note.
        /// </summary>
        /// <value>
        /// The progress report note.
        /// </value>
        IDapperRepository<ProgressReportNote> ProgressReportNote { get; }

        /// <summary>
        /// Gets the nurse Shift map.
        /// </summary>
        IDapperRepository<NurseShiftMap> NurseShiftMap { get; }

        /// <summary>
        /// Gets the nurse Shift map.
        /// </summary>
        IDapperRepository<NurseShiftBedMap> NurseShiftBedMap { get; }

        /// <summary>
        /// Gets the nurse Shift map.
        /// </summary>
        IDapperRepository<FinalBillInsurance> FinalBillInsurance { get; }

        /// <summary>
        /// Gets the nurse Shift map.
        /// </summary>
        IDapperRepository<FontType> FontType { get; }


        /// <summary>
        /// Gets the vital type.
        /// </summary>
        IDapperRepository<VitalType> VitalType { get; }


        /// <summary>
        /// Gets the progress report vitals.
        /// </summary>
        /// <value>
        /// The progress report vitals.
        /// </value>
        IDapperRepository<ProgressReportVitals> ProgressReportVitals { get; }


        /// <summary>
        /// Gets the progress report assessments.
        /// </summary>
        /// <value>
        /// The progress report assessments.
        /// </value>
        IDapperRepository<ProgressReportAssessments> ProgressReportAssessments { get; }

        /// <summary>
        /// Gets the unit type.
        /// </summary>
        IDapperRepository<UnitType> UnitType { get; }

        /// <summary>
        /// Gets the assessment type.
        /// </summary>
        IDapperRepository<AssessmentType> AssessmentType { get; }

        /// <summary>
        /// Gets the discount modules.
        /// </summary>
        IDapperRepository<DiscountModule> DiscountModules { get; }

        /// <summary>
        /// Gets the discount per modules.
        /// </summary>
        IDapperRepository<DiscountsPerModule> DiscountsPerModules { get; }

        /// <summary>
        /// Gets the supplier products.
        /// </summary>
        IDapperRepository<SupplierProduct> SupplierProducts { get; }

        /// <summary>
        /// Gets the patient timing.
        /// </summary>
        /// <value>
        /// The patient timing.
        /// </value>
        IDapperRepository<PatientTiming> PatientTiming { get; }

        /// <summary>
        /// Gets the medication move.
        /// </summary>
        /// <value>
        /// The medication move.
        /// </value>
        IDapperRepository<MedicationMove> MedicationMove { get; }

        /// <summary>
        /// Gets the operation indent headers.
        /// </summary>
        /// <value>
        /// The operation indent headers.
        /// </value>
        IDapperRepository<OperationIndentHeader> OperationIndentHeaders { get; }

        /// <summary>
        /// Gets the operation indent details.
        /// </summary>
        /// <value>
        /// The operation indent details.
        /// </value>
        IDapperRepository<OperationIndentDetail> OperationIndentDetails { get; }

        /// <summary>
        /// Gets the operation stocks.
        /// </summary>
        /// <value>
        /// The operation stocks.
        /// </value>
        IDapperRepository<OperationStock> OperationStocks { get; }

        /// <summary>
        /// Gets the provider location operations.
        /// </summary>
        /// <value>
        /// The provider location operations.
        /// </value>
        IDapperRepository<ProviderLocationOperation> ProviderLocationOperations { get; }

        /// <summary>
        /// Gets the surgerys.
        /// </summary>
        /// <value>
        /// The surgerys.
        /// </value>
        IDapperRepository<Surgery> Surgerys { get; }

        /// <summary>
        /// Gets the surgery charges.
        /// </summary>
        /// <value>
        /// The surgery charges.
        /// </value>
        IDapperRepository<SurgeryCharge> SurgeryCharges { get; }

        /// <summary>
        /// Gets the ot rooms.
        /// </summary>
        /// <value>
        /// The ot rooms.
        /// </value>
        IDapperRepository<OTRoom> OTRooms { get; }

        /// <summary>
        /// Gets the demand books.
        /// </summary>
        /// <value>
        /// The demand books.
        /// </value>
        IDapperRepository<DemandBook> DemandBooks { get; }

        /// <summary>Gets the modules.</summary>
        IDapperRepository<ModulesMaster> ModulesMasters { get; }

        /// <summary>Gets the modules.</summary>
        IDapperRepository<PatientReferredBy> ReferenceTypes { get; }
        /// <summary>
        /// Gets the pharmacy stores.
        /// </summary>
        /// <value>
        /// The pharmacy store.
        /// </value>
        IDapperRepository<PharmacyStore> PharmacyStores { get; }

        /// <summary>
        /// Gets the demand books.
        /// </summary>
        /// <value>
        /// The demand books.
        /// </value>
        IDapperRepository<PharmacyRetailUser> PharmacyRetailUsers { get; }

        /// <summary>
        /// Gets the meal types.
        /// </summary>
        /// <value>
        /// The demand books.
        /// </value>
        IDapperRepository<MealTypes> MealTypes { get; }

        /// <summary>
        /// Gets the pharmacy ware houses.
        /// </summary>
        /// <value>
        /// The pharmacy ware houses.
        /// </value>
        IDapperRepository<PharmacyWareHouse> PharmacyWareHouses { get; }

        /// <summary>
        /// Gets the pharmacy ware house users.
        /// </summary>
        /// <value>
        /// The pharmacy ware house users.
        /// </value>
        IDapperRepository<PharmacyWareHouseUser> PharmacyWareHouseUsers { get; }

        /// <summary>
        /// Gets the pharmacy ware house users.
        /// </summary>
        /// <value>
        /// The pharmacy ware house users.
        /// </value>
        IDapperRepository<ProgressReportDiet> ProgressReportDiets { get; }

        /// <summary>
        /// Gets the retail ware house links.
        /// </summary>
        /// <value>
        /// The retail ware house links.
        /// </value>
        IDapperRepository<RetailWareHouseLink> RetailWareHouseLinks { get; }

        /// <summary>
        /// Gets the gyn encounter.
        /// </summary>
        /// <value>
        /// The retail ware house links.
        /// </value>
        IDapperRepository<GynEncounter> GynEncounters { get; }

        /// <summary>
        /// Gets the payment documents.
        /// </summary>
        IDapperRepository<PayType> PayTypes { get; }

        /// <summary>
        /// Gets the employee shifts.
        /// </summary>
        IDapperRepository<EmployeeShift> EmployeeShifts { get; }

        /// <summary>
        /// Gets the leave types.
        /// </summary>
        IDapperRepository<LeaveType> LeaveTypes { get; }

        /// <summary>
        /// Gets the location account map.
        /// </summary>
        /// <value>
        /// The location account map.
        /// </value>
        IDapperRepository<LocationAccountMap> LocationAccountMap { get; }

        /// <summary>
        /// Gets the location department map.
        /// </summary>
        /// <value>
        /// The location department map.
        /// </value>
        IDapperRepository<LocationDepartmentMap> LocationDepartmentMap { get; }


        /// <summary>
        /// Gets the location lab package map.
        /// </summary>
        /// <value>
        /// The location lab package map.
        /// </value>
        IDapperRepository<LocationLabPackageMap> LocationLabPackageMap { get; }

        /// <summary>
        /// Gets the location lab header map.
        /// </summary>
        /// <value>
        /// The location lab header map.
        /// </value>
        IDapperRepository<LocationLabHeaderMap> LocationLabHeaderMap { get; }

        /// <summary>
        /// Gets the location master package map.
        /// </summary>
        /// <value>
        /// The location Package map.
        /// </value>
        IDapperRepository<LocationPackageMap> LocationPackageMap { get; }

        /// <summary>
        /// Gets the location master meal type map.
        /// </summary>
        /// <value>
        /// The location master meal type map.
        /// </value>
        IDapperRepository<LocationMealTypesMap> LocationMealTypesMap { get; }

        /// <summary>
        /// Gets the location master floor map.
        /// </summary>
        /// <value>
        /// The location master floor  map.
        /// </value>
        IDapperRepository<LocationFloorMap> LocationFloorMap { get; }

        /// <summary>
        /// Gets the location master specialization map.
        /// </summary>
        /// <value>
        /// The location master specialization  map.
        /// </value>
        IDapperRepository<LocationSpecializationMap> LocationSpecializationMap { get; }

        /// <summary>
        /// Gets the locations.
        /// </summary>
        /// <value>
        /// The locations.
        /// </value>
        IDapperRepository<Location> Locations { get; }


        /// <summary>
        /// Gets the ob encounter.
        /// </summary>
        /// <value>
        /// The ob encounter.
        /// </value>
        IDapperRepository<ObEncounter> ObEncounters { get; }

        /// <summary>
        /// Gets the ob encounter.
        /// </summary>
        /// <value>
        /// The ob encounter.
        /// </value>
        IDapperRepository<ScanTestMaster> ScanTestMasters { get; }

        /// <summary>
        /// Gets the ob encounter.
        /// </summary>
        /// <value>
        /// The ob encounter.
        /// </value>
        IDapperRepository<LocationScanTestMasterMap> LocationScanTestMasterMaps { get; }

        /// <summary>
        /// Gets the ob encounter.
        /// </summary>
        /// <value>
        /// The ob encounter.
        /// </value>
        IDapperRepository<ScanMachineMaster> ScanMachineMasters { get; }

        /// <summary>
        /// Gets the ob encounter.
        /// </summary>
        /// <value>
        /// The ob encounter.
        /// </value>
        IDapperRepository<ScanMachineTestMap> ScanMachineTestMaps { get; }

        /// <summary>
        /// Gets the ob encounter.
        /// </summary>
        /// <value>
        /// The ob encounter.
        /// </value>
        IDapperRepository<ChargeCategory> ChargeCategorys { get; }


        /// <summary>
        /// Gets the HWC patients.
        /// </summary>
        /// <value>
        /// The HWC patients.
        /// </value>
        IDapperRepository<HWCPatient> HwcPatients { get; }

        /// <summary>
        /// Gets the patient registration charges.
        /// </summary>
        /// <value>
        /// The patient registration charges.
        /// </value>
        IDapperRepository<PatientRegistrationCharge> PatientRegistrationCharges { get; }

        /// <summary>
        /// Gets the patient registration details.
        /// </summary>
        /// <value>
        /// The patient registration details.
        /// </value>
        IDapperRepository<PatientRegistrationDetail> PatientRegistrationDetails { get; }

        /// <summary>
        /// Gets the id prrof details.
        /// </summary>
        /// <value>
        /// The id proof details.
        /// </value>
        IDapperRepository<IdProof> IdProofs { get; }


        /// <summary>
        /// Gets the lab departments.
        /// </summary>
        /// <value>
        /// The lab departments.
        /// </value>
        IDapperRepository<LabDepartment> LabDepartments { get; }

        /// <summary>
        /// Gets the scan machine availability.
        /// </summary>
        /// <value>
        /// The  scan machine availability.
        /// </value>
        IDapperRepository<ScanMachineAvailability> ScanMachineAvailabilitys { get; }

        /// <summary>
        /// Gets the patient medication headers.
        /// </summary>
        /// <value>
        /// The patient medication headers.
        /// </value>
        IDapperRepository<PatientMedicationHeader> PatientMedicationHeaders { get; }

        /// <summary>
        /// Gets the patient medication details.
        /// </summary>
        /// <value>
        /// The patient medication details.
        /// </value>
        IDapperRepository<PatientMedicationDetail> PatientMedicationDetails { get; }

        /// <summary>
        /// Gets the web notifications.
        /// </summary>
        /// <value>
        /// The web notifications.
        /// </value>
        IDapperRepository<WebNotification> WebNotifications { get; }

        /// <summary>
        /// Gets the book scan appointment.
        /// </summary>
        /// <value>
        /// The book scan appointment.
        /// </value>
        IDapperRepository<BookScanAppointment> BookScanAppointments { get; }

        /// <summary>
        /// Gets the patient lab headers.
        /// </summary>
        /// <value>
        /// The patient lab headers.
        /// </value>
        IDapperRepository<PatientLabHeader> PatientLabHeaders { get; }

        /// <summary>
        /// Gets the patient lab details.
        /// </summary>
        /// <value>
        /// The patient lab details.
        /// </value>
        IDapperRepository<PatientLabDetail> PatientLabDetails { get; }

        /// <summary>
        /// Gets the pharmacy product racks.
        /// </summary>
        /// <value>
        /// The pharmacy product racks.
        /// </value>
        IDapperRepository<PharmacyProductRack> PharmacyProductRacks { get; }

        /// <summary>
        /// Gets the pharmacy product details.
        /// </summary>
        /// <value>
        /// The pharmacy product details.
        /// </value>
        IDapperRepository<PharmacyProductDetail> PharmacyProductDetails { get; }

        /// <summary>
        /// Gets the pharmacy departmental stocks.
        /// </summary>
        /// <value>
        /// The pharmacy departmental stocks.
        /// </value>
        IDapperRepository<PharmacyDepartmentalStock> PharmacyDepartmentalStocks { get; }

        /// <summary>
        /// Gets the pharmacy departments.
        /// </summary>
        /// <value>
        /// The pharmacy departments.
        /// </value>
        IDapperRepository<PharmacyDepartment> PharmacyDepartments { get; }

        /// <summary>
        /// Gets the pharmacy department users.
        /// </summary>
        /// <value>
        /// The pharmacy department users.
        /// </value>
        IDapperRepository<PharmacyDepartmentUser> PharmacyDepartmentUsers { get; }

        /// <summary>
        /// Gets the scan classification details.
        /// </summary>
        /// <value>
        /// The scan classification details.
        /// </value>
        IDapperRepository<ScanClassification> ScanClassifications { get; }

        /// <summary>
        /// Gets the scan classification details.
        /// </summary>
        /// <value>
        /// The scan classification details.
        /// </value>
        IDapperRepository<ScanSubClassification> ScanSubClassifications { get; }

        /// <summary>
        /// Gets the department consumptions.
        /// </summary>
        /// <value>
        /// The department consumptions.
        /// </value>
        IDapperRepository<DepartmentConsumption> DepartmentConsumptions { get; }

        /// <summary>
        /// Gets the pharmacy issued stock headers.
        /// </summary>
        /// <value>
        /// The pharmacy issued stock headers.
        /// </value>
        IDapperRepository<PharmacyIssuedStockHeader> PharmacyIssuedStockHeaders { get; }

        /// <summary>
        /// Gets the pharmacy issued stock details.
        /// </summary>
        /// <value>
        /// The pharmacy issued stock details.
        /// </value>
        IDapperRepository<PharmacyIssuedStockDetail> PharmacyIssuedStockDetails { get; }

        /// <summary>
        /// Gets the inventory ware houses.
        /// </summary>
        /// <value>
        /// The inventory ware houses.
        /// </value>
        IDapperRepository<InventoryWareHouse> InventoryWareHouses { get; }

        /// <summary>
        /// Gets the inventory ware house users.
        /// </summary>
        /// <value>
        /// The inventory ware house users.
        /// </value>
        IDapperRepository<InventoryWareHouseUser> InventoryWareHouseUsers { get; }

        /// <summary>
        /// Gets the inventory departments.
        /// </summary>
        /// <value>
        /// The inventory departments.
        /// </value>
        IDapperRepository<InventoryDepartment> InventoryDepartments { get; }

        /// <summary>
        /// Gets the inventory department users.
        /// </summary>
        /// <value>
        /// The inventory department users.
        /// </value>
        IDapperRepository<InventoryDepartmentUser> InventoryDepartmentUsers { get; }

        /// <summary>
        /// Gets the inventory departmental stocks.
        /// </summary>
        /// <value>
        /// The inventory departmental stocks.
        /// </value>
        IDapperRepository<InventoryDepartmentalStock> InventoryDepartmentalStocks { get; }
        /// <summary>
        /// Gets the machines
        /// </summary>
        /// <value>
        /// The machines.
        /// </value>
        IDapperRepository<Machine> Machines { get; }

        /// <summary>
        /// Gets the provider consultation rooms.
        /// </summary>
        /// <value>
        /// The provider consultation rooms.
        /// </value>
        IDapperRepository<ProviderConsultationRoom> ProviderConsultationRooms { get; }

        /// <summary>
        /// Gets the inventory issued stock headers.
        /// </summary>
        /// <value>
        /// The inventory issued stock headers.
        /// </value>
        IDapperRepository<InventoryIssuedStockHeader> InventoryIssuedStockHeaders { get; }

        /// <summary>
        /// Gets the inventory issued stock details.
        /// </summary>
        /// <value>
        /// The inventory issued stock details.
        /// </value>
        IDapperRepository<InventoryIssuedStockDetail> InventoryIssuedStockDetails { get; }

        /// <summary>
        /// Gets the inventory product details.
        /// </summary>
        /// <value>
        /// The inventory product details.
        /// </value>
        IDapperRepository<InventoryProductDetail> InventoryProductDetails { get; }

        /// <summary>
        /// Gets the inventory product racks.
        /// </summary>
        /// <value>
        /// The inventory product racks.
        /// </value>
        IDapperRepository<InventoryProductRack> InventoryProductRacks { get; }

        /// <summary>
        /// Gets the inventory department consumptions.
        /// </summary>
        /// <value>
        /// The inventory department consumptions.
        /// </value>
        IDapperRepository<InventoryDepartmentConsumption> InventoryDepartmentConsumptions { get; }

        /// <summary>
        /// Gets the provider medication groups.
        /// </summary>
        /// <value>
        /// The provider medication groups.
        /// </value>
        IDapperRepository<ProviderMedicationGroup> ProviderMedicationGroups { get; }

        /// <summary>
        /// Gets the provider medication masters.
        /// </summary>
        /// <value>
        /// The provider medication masters.
        /// </value>
        IDapperRepository<ProviderMedicationMaster> ProviderMedicationMasters { get; }

        /// <summary>
        /// Gets the provider medication maps.
        /// </summary>
        /// <value>
        /// The provider medication maps.
        /// </value>
        IDapperRepository<ProviderMedicationMap> ProviderMedicationMaps { get; }


        /// <summary>
        /// Gets the order prescription values.
        /// </summary>
        /// <value>
        /// The order prescription values.
        /// </value>
        IDapperRepository<OrderPrescriptionValue> OrderPrescriptionValues { get; }

        /// <summary>
        /// Gets the lab parameter headers.
        /// </summary>
        /// <value>
        /// The lab parameter headers.
        /// </value>
        IDapperRepository<LabParameterHeader> LabParameterHeaders { get; }

        /// <summary>
        /// Gets the lab parameter details.
        /// </summary>
        /// <value>
        /// The lab parameter details.
        /// </value>
        IDapperRepository<LabParameterDetail> LabParameterDetails { get; }

        /// <summary>
        /// Gets the lab component headers.
        /// </summary>
        /// <value>
        /// The lab component headers.
        /// </value>
        IDapperRepository<LabComponentHeader> LabComponentHeaders { get; }

        /// <summary>
        /// Gets the lab component details.
        /// </summary>
        /// <value>
        /// The lab component details.
        /// </value>
        IDapperRepository<LabComponentDetail> LabComponentDetails { get; }

        /// <summary>
        /// Gets the lab template headers.
        /// </summary>
        /// <value>
        /// The lab template headers.
        /// </value>
        IDapperRepository<LabTemplateHeader> LabTemplateHeaders { get; }

        /// <summary>
        /// Gets the lab template details.
        /// </summary>
        /// <value>
        /// The lab template details.
        /// </value>
        IDapperRepository<LabTemplateDetail> LabTemplateDetails { get; }
        /// <summary>
        /// Gets the appointments.
        /// </summary>
        IDapperRepository<AppointmentHangfireMap> AppointmentHangfireMaps { get; }

        /// <summary>
        /// Gets the appointments type.
        /// </summary>
        IDapperRepository<AppointmentType> AppointmentTypes { get; }


        /// <summary>
        /// Gets the lab parameter methods.
        /// </summary>
        /// <value>
        /// The lab parameter methods.
        /// </value>
        IDapperRepository<LabParameterMethod> LabParameterMethods { get; }

        /// <summary>
        /// Gets the lab sample types.
        /// </summary>
        /// <value>
        /// The lab sample types.
        /// </value>
        IDapperRepository<LabSampleType> LabSampleTypes { get; }

        /// <summary>
        /// Gets the lab main details.
        /// </summary>
        /// <value>
        /// The lab main details.
        /// </value>
        IDapperRepository<LabMainDetail> LabMainDetails { get; }

        /// <summary>
        /// Gets the lab main detail templates.
        /// </summary>
        /// <value>
        /// The lab main detail templates.
        /// </value>
        IDapperRepository<LabMainDetailTemplate> LabMainDetailTemplates { get; }

        /// <summary>
        /// Gets the lab booking status.
        /// </summary>
        /// <value>
        /// The lab booking statuss.
        /// </value>
        IDapperRepository<LabBookingStatus> LabBookingStatus { get; }

        /// <summary>
        /// Creates new labbookingheaders.
        /// </summary>
        /// <value>
        /// The new lab booking headers.
        /// </value>
        IDapperRepository<NewLabBookingHeader> NewLabBookingHeaders { get; }

        /// <summary>
        /// Creates new labbookingdetails.
        /// </summary>
        /// <value>
        /// The new lab booking details.
        /// </value>
        IDapperRepository<NewLabBookingDetail> NewLabBookingDetails { get; }

        /// <summary>
        /// Gets the lab booking time lines.
        /// </summary>
        /// <value>
        /// The lab booking time lines.
        /// </value>
        IDapperRepository<LabBookingTimeLine> LabBookingTimeLines { get; }

        /// <summary>
        /// Gets the dynamic templates.
        /// </summary>
        /// <value>
        /// The dynamic templates.
        /// </value>
        IDapperRepository<DynamicTemplate> DynamicTemplates { get; }

        /// <summary>
        /// Gets the lab sample collections.
        /// </summary>
        /// <value>
        /// The lab sample collections.
        /// </value>
        IDapperRepository<LabSampleCollection> LabSampleCollections { get; }

        /// <summary>
        /// Gets the pay category.
        /// </summary>
        /// <value>
        /// The the pay category.
        /// </value>
        IDapperRepository<PayCategory> PayCategorys { get; }

        /// <summary>
        /// Gets the NewLabCancelBookingHeaders.
        /// </summary>
        /// <value>
        /// The the NewLabCancelBookingHeaders.
        /// </value>
        IDapperRepository<NewLabCancelBookingHeader> NewLabCancelBookingHeaders { get; }

        /// <summary>
        /// Gets the NewLabCancelBookingHeaders.
        /// </summary>
        /// <value>
        /// The the NewLabCancelBookingHeaders.
        /// </value>
        IDapperRepository<NewLabCancelBookingDetail> NewLabCancelBookingDetails { get; }

        /// <summary>
        /// Gets the salutation.
        /// </summary>
        /// <value>
        /// The salutation.
        /// </value>
        IDapperRepository<Salutation> Salutations { get; }

        /// <summary>
        /// Gets the lab transfer headers.
        /// </summary>
        /// <value>
        /// The lab transfer headers.
        /// </value>
        IDapperRepository<LabTransferHeader> LabTransferHeaders { get; }

        /// <summary>
        /// Gets the lab transfer details.
        /// </summary>
        /// <value>
        /// The lab transfer details.
        /// </value>
        IDapperRepository<LabTransferDetail> LabTransferDetails { get; }

        /// <summary>
        /// Gets the component type.
        /// </summary>
        /// <value>
        /// The component type.
        /// </value>
        IDapperRepository<ComponentType> ComponentTypes { get; }

        /// <summary>
        /// Gets the component .
        /// </summary>
        /// <value>
        /// The component.
        /// </value>
        IDapperRepository<Component> Components { get; }

        /// <summary>
        /// Gets the component .
        /// </summary>
        /// <value>
        /// The component.
        /// </value>
        IDapperRepository<Template> Templates { get; }

        /// <summary>
        /// Gets the lab parameter observed values.
        /// </summary>
        /// <value>
        /// The lab parameter observed values.
        /// </value>
        IDapperRepository<LabParameterObservedValue> LabParameterObservedValues { get; }

        /// <summary>
        /// Gets the lab template observed values.
        /// </summary>
        /// <value>
        /// The lab template observed values.
        /// </value>
        IDapperRepository<LabTemplateObservedValue> LabTemplateObservedValues { get; }

        /// <summary>
        /// Gets the settings .
        /// </summary>
        /// <value>
        /// The settings.
        /// </value>
        IDapperRepository<Settings> Settings { get; }


        /// <summary>
        /// Gets the settings .
        /// </summary>
        /// <value>
        /// The settings.
        /// </value>
        IDapperRepository<ReferralDoctor> ReferralDoctor { get; }

        /// <summary>
        /// Gets the settings .
        /// </summary>
        /// <value>
        /// The settings.
        /// </value>
        IDapperRepository<PatientTransaction> PatientTransaction { get; }

        /// <summary>
        /// Gets the provider schedule charges.
        /// </summary>
        IDapperRepository<ProviderScheduleCharge> ProviderScheduleCharges { get; }

        /// <summary>
        /// Gets the provider schedule charges.
        /// </summary>
        IDapperRepository<ConsultationType> ConsultationType { get; }

        /// <summary>
        /// Gets the provider locations.
        /// </summary>
        IDapperRepository<ProviderAvailability> ProviderAvailability { get; }

        /// <summary>
        /// Gets the provider locations.
        /// </summary>
        IDapperRepository<ProviderAvailabilitySlot> ProviderAvailabilitySlot { get; }

        /// <summary>
        /// Gets the provider locations.
        /// </summary>
        IDapperRepository<ProviderAvailabilityVisitType> ProviderAvailabilityVisitType { get; }

        /// <summary>
        /// Gets the provider locations.
        /// </summary>
        IDapperRepository<ProviderAvailabilityChargeType> ProviderAvailabilityChargeType { get; }

        /// <summary>
        /// Gets the lab report verifications.
        /// </summary>
        /// <value>
        /// The lab report verifications.
        /// </value>
        IDapperRepository<LabReportVerification> LabReportVerifications { get; }
        /// <summary>
        /// Gets the ivf encounter.
        /// </summary>
        /// <value>
        /// The ivf encounter.
        /// </value>
        IDapperRepository<IvfEncounter> IvfEncounters { get; }

        /// <summary>
        /// Gets the Cubicle.
        /// </summary>
        IDapperRepository<Cubicle> Cubicle { get; }

        /// <summary>
        /// Gets the information log.
        /// </summary>
        /// <value>
        /// The information log.
        /// </value>
        IDapperRepository<InformationLog> InformationLog { get; }

        /// <summary>
        /// Gets the working hour.
        /// </summary>
        /// <value>
        /// The working hour
        /// </value>
        IDapperRepository<WorkingHour> WorkingHour { get; }

        /// <summary>
        /// Gets the charge types.
        /// </summary>
        IDapperRepository<EncounterType> EncounterType { get; }

        /// <summary>
        /// Gets the session types.
        /// </summary>
        /// <value>
        /// The session types.
        /// </value>
        IDapperRepository<SessionType> SessionTypes { get; }

        /// <summary>
        /// Gets the sessions.
        /// </summary>
        /// <value>
        /// The sessions.
        /// </value>
        IDapperRepository<Session> Sessions { get; }
        /// <summary>
        /// Gets the charge types.
        /// </summary>
        ///
        IDapperRepository<UserExcelHistory> UserExcelHistory { get; }

        /// <summary>
        /// Gets the appointment status.
        /// </summary>
        IDapperRepository<PaymentInitiationLog> PaymentInitiationLog { get; }

        /// <summary>
        /// Gets the appointment status.
        /// </summary>
        IDapperRepository<PaymentResponseLog> PaymentResponseLog { get; }

        /// <summary>
        /// Gets the payment map helper.
        /// </summary>
        /// <value>
        /// The payment map helper.
        /// </value>
        IDapperRepository<PaymentMapHelper> PaymentMapHelper { get; }

        /// <summary>
        /// Gets the Patient Chat status.
        /// </summary>
        IDapperRepository<PatientChatBox> PatientChatBoxes { get; }

        /// <summary>
        /// Gets the room charge.
        /// </summary>
        /// <value>
        /// The room charge.
        /// </value>
        IDapperRepository<RoomCharge> RoomCharges { get; }

        /// <summary>
        /// Gets the charge module templates.
        /// </summary>
        /// <value>
        /// The charge module templates.
        /// </value>
        IDapperRepository<ChargeModuleTemplate> ChargeModuleTemplates { get; }

        /// <summary>
        /// Gets the charge module categorys.
        /// </summary>
        /// <value>
        /// The charge module categorys.
        /// </value>
        IDapperRepository<ChargeModuleCategory> ChargeModuleCategorys { get; }

        /// <summary>
        /// Gets the charge module details.
        /// </summary>
        /// <value>
        /// The charge module details.
        /// </value>
        IDapperRepository<ChargeModuleDetails> ChargeModuleDetails { get; }

        /// <summary>
        /// Gets the doctor specialization charge module categorys.
        /// </summary>
        /// <value>
        /// The doctor specialization charge module categorys.
        /// </value>
        IDapperRepository<DoctorSpecializationChargeModuleCategory> DoctorSpecializationChargeModuleCategorys { get; }

        /// <summary>
        /// Gets the doctor specialization charge module details.
        /// </summary>
        /// <value>
        /// The doctor specialization charge module details.
        /// </value>
        IDapperRepository<DoctorSpecializationChargeModuleDetails> DoctorSpecializationChargeModuleDetails { get; }

        /// <summary>
        /// Gets the doctor specialization maps.
        /// </summary>
        /// <value>
        /// The doctor specialization maps.
        /// </value>
        IDapperRepository<DoctorSpecializationMap> DoctorSpecializationMaps { get; }
        /// <summary>
        /// Gets the appointment status.
        /// </summary>
        IDapperRepository<AppointmentCheckPoints> AppointmentCheckPoints { get; }

        /// <summary>
        /// Gets the locations.
        /// </summary>
        /// <value>
        /// The locations.
        /// </value>
        IDapperRepository<PracticeLocation> PracticeLocations { get; }
        /// <summary>
        /// Gets the scan machine availability.
        /// </summary>
        /// <value>
        /// The  scan machine availability.
        /// </value>
        IDapperRepository<OTRoomAvailability> OTRoomAvailabilitys { get; }
        /// <summary>
        /// Gets the scan machine availability.
        /// </summary>
        /// <value>
        /// The  scan machine availability.
        /// </value>
        IDapperRepository<OTRegister> OTRegisters { get; }

        /// <summary>
        /// Gets the case type.
        /// </summary>
        /// <value>
        /// The  case type.
        /// </value>
        IDapperRepository<CaseType> CaseTypes { get; }


        /// <summary>
        /// Gets the ob encounter.
        /// </summary>
        /// <value>
        /// The ob encounter.
        /// </value>
        IDapperRepository<OTRoomSurgeryMap> OTRoomSurgeryMaps { get; }


        /// <summary>
        /// Gets the provider locations.
        /// </summary>
        IDapperRepository<ProviderBreak> ProviderBreak { get; }

        IDapperRepository<PackageModule> PackageModules { get; }

        IDapperRepository<PackageModuleDetail> PackageModuleDetails { get; }

        IDapperRepository<CounsellingDetail> CounsellingDetails { get; }
        /// <summary>
        /// Gets the charge types.
        /// </summary>
        IDapperRepository<PatientExcelHistory> PatientsExcelHistory { get; }

        /// <summary>
        /// Gets the doctor unit master.
        /// </summary>
        IDapperRepository<DoctorUnitMaster> DoctorUnitMatser { get; }

        /// <summary>
        /// Gets the tag doctor.
        /// </summary>
        IDapperRepository<TagDoctor> TagDoctor { get; }

        /// <summary>
        /// Gets the provider locations.
        /// </summary>
        IDapperRepository<DoctorAvailabilityVisitType> DoctorAvailabilityVisitType { get; }
        /// <summary>
        /// Gets the dynamic remplate config.
        /// </summary>
        IDapperRepository<DynamicTemplateConfig> DynamicTemplateConfig { get; }


        /// <summary>
        /// Gets the health card.
        /// </summary>
        IDapperRepository<HealthCard> HealthCards { get; }

        /// <summary>
        /// Gets the issue health card.
        /// </summary>
        IDapperRepository<IssueHealthCard> IssueHealthCards { get; }

        /// <summary>
        /// Gets the health card members.
        /// </summary>
        IDapperRepository<HealthCardMember> HealthCardMembers { get; }

        /// <summary>
        /// Gets the health card members.
        /// </summary>
        IDapperRepository<DietGuidLines> DietGuidLines { get; }

        /// <summary>
        /// Gets the diet plan.
        /// </summary>
        IDapperRepository<DietPlan> DietPlanes { get; }

        /// <summary>
        /// Gets the menu button.
        /// </summary>
        /// <value>
        /// The menu button.
        /// </value>
        IDapperRepository<MenuButton> MenuButton { get; }

        /// <summary>
        /// Gets the menu button relationship.
        /// </summary>
        /// <value>
        /// The menu button relationship.
        /// </value>
        IDapperRepository<MenuButtonRelationship> MenuButtonRelationship { get; }
        /// <summary>
        /// Gets the birth certificate.
        /// </summary>
        /// <value>
        /// The birth certificate.
        /// </value>
        IDapperRepository<BirthCertificate> BirthCertificates { get; }

        IDapperRepository<NurseNote> NurseNote { get; }

        /// <summary>
        /// The execute async.
        /// </summary>
        /// <param name="functionName">
        /// The function name.
        /// </param>
        /// <param name="parameters">
        /// The parameters.
        /// </param>
        /// <typeparam name="TEntity">
        /// Entity model.
        /// </typeparam>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<TEntity> ExecuteAsync<TEntity>(string functionName, object parameters);

        /// <summary>
        /// The execute all async.
        /// </summary>
        /// <param name="functionName">
        /// The function name.
        /// </param>
        /// <param name="parameters">
        /// The parameters.
        /// </param>
        /// <typeparam name="TEntity">
        /// Entity model.
        /// </typeparam>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<TEntity>> ExecuteAllAsync<TEntity>(string functionName, object parameters);

        /// <summary>
        /// Gets the DynamicReports .
        /// </summary>
        IDapperRepository<DynamicReportImages> DynamicReportImages { get; }


        IDapperRepository<Ambulance> Ambulance { get; }


        IDapperRepository<DriverDetail> DriverDetail { get; }

        IDapperRepository<AmbulanceReciept> AmbulanceReciept { get; }
        IDapperRepository<PediatricEncounter> PediatricEncounters { get; }


        IDapperRepository<NeonatalIPEncounter> NeonatalIPEncounters { get; }

        /// <summary>
        /// Gets the reasons.
        /// </summary>
        IDapperRepository<Reasons> Reasons { get; }

        /// <summary>
        /// Gets the authority.
        /// </summary>
        IDapperRepository<AuthorityMaster> AuthorityMaster { get; }

        /// <summary>
        /// Gets the tendor status.
        /// </summary>
        /// <value>
        /// The tendor status.
        /// </value>
        IDapperRepository<TendorStatus> TendorStatus { get; }

        /// <summary>
        /// Gets the pharmacy product requests.
        /// </summary>
        /// <value>
        /// The pharmacy product requests.
        /// </value>
        IDapperRepository<PharmacyProductRequest> PharmacyProductRequests { get; }

        /// <summary>
        /// Gets the anc card generation.
        /// </summary>
        /// <value>
        /// The anc card generation.
        /// </value>
        IDapperRepository<ANCCardGeneration> ANCCardGeneration { get; }

        /// <summary>
        /// Gets the template headers.
        /// </summary>
        /// <value>
        /// The template headers.
        /// </value>
        IDapperRepository<TemplateHeader> TemplateHeaders { get; }

        /// <summary>
        /// Gets the template details.
        /// </summary>
        /// <value>
        /// The template details.
        /// </value>
        IDapperRepository<TemplateDetail> TemplateDetails { get; }

        /// <summary>
        /// Gets the med frequency masters.
        /// </summary>
        /// <value>
        /// The med frequency masters.
        /// </value>
        IDapperRepository<MedFrequencyMaster> MedFrequencyMasters { get; }

        /// <summary>
        /// Gets the vaccine groups.
        /// </summary>
        /// <value>
        /// The vaccine groups.
        /// </value>
        IDapperRepository<VaccineGroup> VaccineGroups { get; }

        /// <summary>
        /// Gets the vaccine masters.
        /// </summary>
        /// <value>
        /// The vaccine masters.
        /// </value>
        IDapperRepository<VaccineMaster> VaccineMasters { get; }

        /// <summary>
        /// Gets the vaccine types.
        /// </summary>
        /// <value>
        /// The vaccine types.
        /// </value>
        IDapperRepository<VaccineType> VaccineTypes { get; }

        /// <summary>
        /// Gets the vaccine dependencys.
        /// </summary>
        /// <value>
        /// The vaccine dependencys.
        /// </value>
        IDapperRepository<VaccineDependency> VaccineDependencys { get; }

        /// <summary>
        /// Gets the gatePass.
        /// </summary>
        /// <value>
        /// The gatePass.
        /// </value>
        IDapperRepository<GatePass> GatePass { get; }
        /// <summary>
        /// Gets the masterBill.
        /// </summary>
        /// <value>
        /// The masterBill.
        /// </value>
        IDapperRepository<MasterBill> MasterBill { get; }
        /// <summary>
        /// Gets the masterBill.
        /// </summary>
        /// <value>
        /// The masterBill.
        /// </value>
        IDapperRepository<Relations> Relations { get; }

        /// <summary>
        /// Gets the icd values.
        /// </summary>
        /// <value>
        /// The icd values.
        /// </value>
        IDapperRepository<ICDValues> ICDValues { get; }
        /// <summary>
        /// Gets the anc card generation.
        /// </summary>
        /// <value>
        /// The anc card generation.
        /// </value
        /// >
        ///  IDapperRepository<ANCCardGeneration> ANCCardGeneration { get; }
        IDapperRepository<GYNCardGeneration> GYNCardGeneration { get; }

        /// <summary>
        ///
        /// </summary>
        IDapperRepository<DietEncounter> DietEncounter { get; }

        /// <summary>
        /// Gets the pediatric chart authoritys.
        /// </summary>
        /// <value>
        /// The pediatric chart authoritys.
        /// </value>
        IDapperRepository<PediatricChartAuthority> PediatricChartAuthoritys { get; }

        /// <summary>
        /// Gets the pediatric chart types.
        /// </summary>
        /// <value>
        /// The pediatric chart types.
        /// </value>
        IDapperRepository<PediatricChartType> PediatricChartTypes { get; }

        /// <summary>
        /// Gets the pediatric age wise datas.
        /// </summary>
        /// <value>
        /// The pediatric age wise datas.
        /// </value>
        IDapperRepository<PediatricAgeWiseData> PediatricAgeWiseDatas { get; }

        /// <summary>
        /// Gets the pharmacy department indent headers.
        /// </summary>
        /// <value>
        /// The pharmacy department indent headers.
        /// </value>
        IDapperRepository<PharmacyDepartmentIndentHeader> PharmacyDepartmentIndentHeaders { get; }

        /// <summary>
        /// Gets the pharmacy department indent details.
        /// </summary>
        /// <value>
        /// The pharmacy department indent details.
        /// </value>
        IDapperRepository<PharmacyDepartmentIndentDetail> PharmacyDepartmentIndentDetails { get; }

        /// <summary>
        /// Gets the general notifications.
        /// </summary>
        /// <value>
        /// The general notifications.
        /// </value>
        IDapperRepository<GeneralNotification> GeneralNotifications { get; }

        /// <summary>
        /// Gets the pharmacy department issue headers.
        /// </summary>
        /// <value>
        /// The pharmacy department issue headers.
        /// </value>
        IDapperRepository<PharmacyDepartmentIssueHeader> PharmacyDepartmentIssueHeaders { get; }

        /// <summary>
        /// Gets the pharmacy department issue details.
        /// </summary>
        /// <value>
        /// The pharmacy department issue details.
        /// </value>
        IDapperRepository<PharmacyDepartmentIssueDetail> PharmacyDepartmentIssueDetails { get; }

        /// <summary>
        /// Gets the charge types.
        /// </summary>
        IDapperRepository<DoctorAppointmentNotice> DoctorAppointmentNotices { get; }

        /// <summary>
        /// Gets the pharmacy product approvals.
        /// </summary>
        /// <value>
        /// The pharmacy product approvals.
        /// </value>
        IDapperRepository<PharmacyProductApproval> PharmacyProductApprovals { get; }

        /// <summary>
        /// Gets the scan appointment notices.
        /// </summary>
        /// <value>
        /// The scan appointment notices.
        /// </value>
        IDapperRepository<ScanAppointmentNotice> ScanAppointmentNotices { get; }

        /// <summary>
        /// Gets the Lab Vacutainer details.
        /// </summary>
        /// <value>
        /// The Lab Vacutainer details.
        /// </value>
        IDapperRepository<LabVacutainer> LabVacutainerDetails { get; }

        /// <summary>
        /// Gets the external lab agencys.
        /// </summary>
        /// <value>
        /// The external lab agencys.
        /// </value>
        IDapperRepository<ExternalLabAgency> ExternalLabAgency { get; }

        /// <summary>
        /// Gets the external lab agency details.
        /// </summary>
        /// <value>
        /// The external lab agency details.
        /// </value>
        IDapperRepository<ExternalLabAgencyDetail> ExternalLabAgencyDetails { get; }

        /// <summary>
        /// Gets the external lab transfer.
        /// </summary>
        /// <value>
        /// The external lab transfer.
        /// </value>
        IDapperRepository<ExternalLabTransfer> ExternalLabTransfer { get; }

        /// <summary>
        /// Gets the ticket types.
        /// </summary>
        /// <value>
        /// The ticket types.
        /// </value>
        IDapperRepository<TicketType> TicketTypes { get; }

        /// <summary>
        /// Gets the CPX rela ted to departments.
        /// </summary>
        /// <value>
        /// The CPX rela ted to departments.
        /// </value>
        IDapperRepository<CpxRelatedToDepartment> CpxRelatedToDepartments { get; }

        /// <summary>
        /// Gets the request departments.
        /// </summary>
        /// <value>
        /// The request departments.
        /// </value>
        IDapperRepository<RequestDepartment> RequestDepartments { get; }

        /// <summary>
        /// Gets the admission bed change requests.
        /// </summary>
        /// <value>
        /// The admission bed change requests.
        /// </value>
        IDapperRepository<AdmissionBedChangeRequest> AdmissionBedChangeRequests { get; }

        /// <summary>
        /// Gets the master operating rooms.
        /// </summary>
        /// <value>
        /// The master operating rooms.
        /// </value>
        IDapperRepository<MasterOperatingRoom> MasterOperatingRooms { get; }


        /// <summary>
        /// Gets the emergency encounter.
        /// </summary>
        /// <value>
        /// The emergency encounter.
        /// </value>
        IDapperRepository<EmergencyEncounter> EmergencyEncounter { get; }

        /// <summary>
        /// Gets the emergency encounter.
        /// </summary>
        /// <value>
        /// The emergency encounter.
        /// </value>
        IDapperRepository<DietSlots> DietSlots { get; }

        /// <summary>
        /// Gets the lab sample collection details.
        /// </summary>
        /// <value>
        /// The lab sample collection details.
        /// </value>
        IDapperRepository<LabSampleCollectionDetail> LabSampleCollectionDetails { get; }


        /// <summary>
        /// Gets the diet items.
        /// </summary>
        /// <value>
        /// The diet items.
        /// </value>
        IDapperRepository<DietItems> DietItems { get; }
        /// <summary>
        /// Gets the diet items.
        /// </summary>
        /// <value>
        /// The diet items.
        /// </value>
        IDapperRepository<Denverchart> Denvercharts { get; }

        IDapperRepository<DietConditionHeader> DietConditionHeader { get; }
        IDapperRepository<DietConditionDetail> DietConditionDetail { get; }
        /// <summary>
        /// Gets the pharmacy product types.
        /// </summary>
        /// <value>
        /// The pharmacy product types.
        /// </value>
        IDapperRepository<PharmacyProductType> PharmacyProductTypes { get; }

        /// <summary>
        /// Gets the pharmacy product sub types.
        /// </summary>
        /// <value>
        /// The pharmacy product sub types.
        /// </value>
        IDapperRepository<PharmacyProductSubType> PharmacyProductSubTypes { get; }
        /// <summary>
        /// Gets the referral form.
        /// </summary>
        /// <value>
        /// The Referral for,.
        /// </value>
        IDapperRepository<ReferralForm> ReferralForms { get; }
        /// <summary>
        /// Gets the common encounter
        /// </summary>
        /// <value>
        /// The Referral for,.
        /// </value>
        IDapperRepository<CommonEncounter> CommonEncounters { get; }

        /// <summary>
        /// Gets the patient scan documents.
        /// </summary>
        IDapperRepository<ScanDocument> ScanDocuments { get; }


        /// <summary>
        /// Gets the purchase order headers.
        /// </summary>
        /// <value>
        /// The purchase order headers.
        /// </value>
        IDapperRepository<PurchaseOrderHeader> PurchaseOrderHeaders { get; }

        /// <summary>
        /// Gets the purchase order details.
        /// </summary>
        /// <value>
        /// The purchase order details.
        /// </value>
        IDapperRepository<PurchaseOrderDetail> PurchaseOrderDetails { get; }
        /// <summary>
        /// Gets the purchase order details.
        /// </summary>
        /// <value>
        /// The purchase order details.
        /// </value>
        IDapperRepository<OrderPrescriptionMaster> OrderPrescriptionMasters { get; }

        /// <summary>
        /// Gets the product for quotation headers.
        /// </summary>
        /// <value>
        /// The product for quotation headers.
        /// </value>
        IDapperRepository<ProductForQuotationHeader> ProductForQuotationHeaders { get; }

        /// <summary>
        /// Gets the product for quotation details.
        /// </summary>
        /// <value>
        /// The product for quotation details.
        /// </value>
        IDapperRepository<ProductForQuotationDetail> ProductForQuotationDetails { get; }

        /// <summary>
        /// Gets the vaccine pharmacy link headers.
        /// </summary>
        /// <value>
        /// The vaccine pharmacy link headers.
        /// </value>
        IDapperRepository<VaccinePharmacyLinkHeader> VaccinePharmacyLinkHeaders { get; }

        /// <summary>
        /// Gets the vaccine pharmacy link details.
        /// </summary>
        /// <value>
        /// The vaccine pharmacy link details.
        /// </value>
        IDapperRepository<VaccinePharmacyLinkDetail> VaccinePharmacyLinkDetails { get; }

        /// <summary>
        /// Gets the immunization history.
        /// </summary>
        /// <value>
        /// The immunization history.
        /// </value>
        IDapperRepository<ImmunizationHistory> ImmunizationHistory { get; }

        /// <summary>
        /// Gets the supplier product headers.
        /// </summary>
        /// <value>
        /// The supplier product headers.
        /// </value>
        IDapperRepository<SupplierProductHeader>  SupplierProductHeaders{ get; }

        /// <summary>
        /// Gets the supplier product details.
        /// </summary>
        /// <value>
        /// The supplier product details.
        /// </value>
        IDapperRepository<SupplierProductDetail>  SupplierProductDetails{ get; }

        /// <summary>
        /// Gets the supplier product formulations.
        /// </summary>
        /// <value>
        /// The supplier product formulations.
        /// </value>
        IDapperRepository<SupplierProductFormulation>  SupplierProductFormulations{ get; }
        /// <summary>
        /// Gets the supplier product formulations.
        /// </summary>
        /// <value>
        /// The supplier product formulations.
        /// </value>
        IDapperRepository<AdmissionTransferRequest> AdmissionTransferRequests { get; }

        /// <summary>
        /// Gets the incoming quotation headers.
        /// </summary>
        /// <value>
        /// The incoming quotation headers.
        /// </value>
        IDapperRepository<IncomingQuotationHeader>  IncomingQuotationHeaders{ get; }

        /// <summary>
        /// Gets the incoming quotation details.
        /// </summary>
        /// <value>
        /// The incoming quotation details.
        /// </value>
        IDapperRepository<IncomingQuotationDetail>  IncomingQuotationDetails{ get; }

        /// Gets the service order.
        /// </summary>
        /// <value>
        /// The service order.
        /// </value>
        IDapperRepository<SurgeryService> SurgeryService { get; }

        /// Gets the service order.
        /// </summary>
        /// <value>
        /// The service order.
        /// </value>
        IDapperRepository<ScanService> ScanService { get; }

        /// <summary>
        /// Gets or sets the pharmacy in patient returns.
        /// </summary>
        /// <value>
        /// The pharmacy in patient returns.
        /// </value>
        IDapperRepository<PharmacyInPatientReturn> PharmacyInPatientReturns { get; }
        /// <summary>
        /// Gets or sets the package document.
        /// </summary>
        /// <value>
        /// The package document.
        /// </value>
        IDapperRepository<PackageDocument> PackageDocuments { get; }

        /// <summary>
        /// Gets the inventory product requests.
        /// </summary>
        /// <value>
        /// The inventory product requests.
        /// </value>
        IDapperRepository<InventoryProductRequest> InventoryProductRequests { get; }

        /// <summary>
        /// Gets the WhatsappTickets
        /// </summary>
        /// <value>
        /// The WhatsappTickets
        /// </value>
        IDapperRepository<WhatsAppTickets> WhatsAppTickets { get; }
        /// <summary>
        /// Gets the register
        /// </summary>
        /// <value>
        /// The register
        /// </value>
        IDapperRepository<Register> Registers { get; }
        /// <summary>
        /// Gets the genetic speciality encounter
        /// </summary>
        /// <value>
        /// The genetic speciality encounter
        /// </value>
        IDapperRepository<GeneticSpecialityEncounter> GeneticSpecialityEncounter { get; }


        /// <summary>
        /// Gets the physiotherapy encounter
        /// </summary>
        /// <value>
        /// The physiotherapy encounter
        /// </value>
        IDapperRepository<PhysiotherapyEncounter> PhysiotherapyEncounters { get; }

        /// <summary>
        /// Gets the bedManagements.
        /// </summary>
        IDapperRepository<InsuranceTemplate> InsuranceTemplates { get; }
        /// <summary>
        /// Gets the encounter order templates
        /// </summary>
        /// <value>
        /// The encounter order templates
        /// </value>
        IDapperRepository<EncounterOrderTemplates> EncounterOrderTemplates { get; }

        /// <summary>
        /// Gets the encounters log
        /// </summary>
        /// <value>
        /// The encounters log
        /// </value>
        IDapperRepository<EncountersLog> EncountersLogs { get; }
        /// <summary>
        /// The open connection.
        /// </summary>
        void OpenConnection();

        /// <summary>
        /// The begin transaction.
        /// </summary>
        /// <returns>
        /// The <see cref="IDbTransaction"/>.
        /// </returns>
        IDbTransaction BeginTransaction();
    }
}