﻿namespace Hims.Domain.Services
{
    using System.Collections.Generic;
    using System.Threading.Tasks;
    using Shared.EntityModels;

    /// <summary>
    /// The MessageService interface.
    /// </summary>
    public interface IMessageService
    {
        /// <summary>
        /// The create message async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> CreateMessageAsync(MessageModel model);

        /// <summary>
        /// The fetch messages async.
        /// </summary>
        /// <param name="appointmentId">
        /// The appointment id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<MessageModel> FetchMessagesAsync(int appointmentId);

        /// <summary>
        /// The update message async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> UpdateMessageAsync(MessageModel model);

        /// <summary>
        /// The change read status.
        /// </summary>
        /// <param name="messageId">
        /// The message id.
        /// </param>
        /// <param name="from">
        /// The from.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> ChangeReadStatus(long messageId, string from);
    }
}
