﻿


namespace Hims.Domain.Services
{
    using System.Collections.Generic;
    using System.Threading.Tasks;
    using Hims.Domain.Entities;
    using Hims.Shared.EntityModels;
    using Hims.Shared.Library.Enums;
    using Hims.Shared.Library.Helpers;
    using Hims.Shared.UserModels.NeonatalIPEncounter;
    //using Ob = Hims.Shared.UserModels.OBEncounter;
    using neonatal = Shared.UserModels.NeonatalIPEncounter;
    using neonatalIPEncounter = Shared.UserModels.NeonatalIPEncounter;
    /// The InternalMedicineService interface.
    /// </summary>
    public interface INeonatalIPEncounterService
    {
        /// <summary>
        /// Finds the asynchronous.
        /// </summary>
        /// <param name="appointmentId">The appointment identifier.</param>
        /// <param name="isAdmission">if set to <c>true</c> [is admission].</param>
        /// <returns></returns>
        Task<NeonatalIPEncounterModel> FindAsync(int appointmentId, bool isAdmission);


        /// <summary>
        /// The add ob encounter async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<CommonResponse> AddAsync(neonatal.InsertModel model);

        /// <summary>
        /// The update alt async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<CommonResponse> UpdateAsync(neonatal.InsertModel model);

        /// <summary>
        /// Finds the dashboard asynchronous.
        /// </summary>
        /// <param name="appointmentId">The appointment identifier.</param>
        /// <param name="type">The type.</param>
        /// <param name="isAdmission">if set to <c>true</c> [is admission].</param>
        /// <returns></returns>
        Task<neonatal.NeonatalIPEncounterResource> FindDashboardAsync(int appointmentId,NeonatalEncounterType type, bool isAdmission);


        /// <summary>
        /// The find full transcript async.
        /// </summary>
        /// <param name="appointmentId">
        /// The appointment id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        // Task<PediatricEncounterFullTranscriptModel> FindFullTranscriptAsync(int appointmentId);
        /// <summary>
        /// The find full transcript async.
        /// </summary>
        /// <param name="appointmentId">
        /// The appointment id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
       // Task<PediatricEncounterFullTranscriptModel> FindFullTranscriptAsync(int appointmentId);
    }
}





