﻿namespace Hims.Domain.Services
{
    using System.Collections.Generic;
    using System.Threading.Tasks;

    using Hims.Domain.Entities;
    using Hims.Shared.EntityModels;
    using Hims.Shared.UserModels;
    using Hims.Shared.UserModels.Pharmacy;

    /// <summary>
    /// The pharmacy ware house service interface.
    /// </summary>
    public interface IPharmacyWareHouseService
    {
        /// <summary>
        /// Inserts the pharmacy ware house.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> InsertPharmacyWareHouse(PharmacyWareHouseModel model);

        /// <summary>
        /// Updates the pharmacy ware house.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> UpdatePharmacyWareHouse(PharmacyWareHouseModel model);

        /// <summary>
        /// Fetches all warehouses asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<IEnumerable<PharmacyWareHouseModel>> FetchAllWarehousesAsync(PharmacyWareHouseModel model);

        /// <summary>
        /// Fetches all warehouses with retail counts asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<IEnumerable<PharmacyWareHouseModel>> FetchAllWarehousesWithRetailCountsAsync(PharmacyWareHouseModel model);

        /// <summary>
        /// Activates the or deactivate ware house.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> ActivateOrDeactivateWareHouse(PharmacyWareHouseModel model);

        /// <summary>
        /// Gets the location identifier based on name asynchronous.
        /// </summary>
        /// <param name="name">The name.</param>
        /// <returns></returns>
        Task<IEnumerable<LocationModel>> GetLocationIdBasedOnNameAsync(string name);

        /// <summary>
        /// Checks the ware house by name and location asynchronous.
        /// </summary>
        /// <param name="query">The query.</param>
        /// <returns></returns>
        Task<int> CheckWareHouseByNameAndLocationAsync(string query);

        /// <summary>
        /// Gets the only ware houses with location asynchronous.
        /// </summary>
        /// <param name="condition">The condition.</param>
        /// <returns></returns>
        Task<IEnumerable<PharmacyWareHouseModel>> GetOnlyWareHousesWithLocationAsync(string condition);

        /// <summary>
        /// Gets all ware houses with location asynchronous.
        /// </summary>
        /// <returns></returns>
        Task<IEnumerable<PharmacyWareHouseModel>> GetAllWareHousesWithLocationAsync();

        /// <summary>
        /// Modifies the pharmacy product type asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> ModifyPharmacyProductTypeAsync(PharmacyProductTypeModel model);

        /// <summary>
        /// Fetches the pharmacy product type asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<IEnumerable<PharmacyProductTypeModel>> FetchPharmacyProductTypeAsync(PharmacyProductTypeModel model);

        /// <summary>
        /// Modifies the pharmacy product sub type asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> ModifyPharmacyProductSubTypeAsync(PharmacyProductSubTypeModel model);

        /// <summary>
        /// Fetches the pharmacy product sub type asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<IEnumerable<PharmacyProductSubTypeModel>> FetchPharmacyProductSubTypeAsync(PharmacyProductSubTypeModel model);
    }
}