﻿namespace Hims.Infrastructure.Services
{
    using Dapper;
    using Hims.Domain.Entities;
    using Hims.Domain.Repositories.UnitOfWork;
    using Hims.Domain.Services;
    using Hims.Shared.UserModels;
    using System;
    using System.Collections.Generic;
    using System.Text;
    using System.Threading.Tasks;

    public class AppointmentTypesService : IAppointmentTypesService
    {
        /// <summary>
        /// The unit of work.
        /// </summary>
        private readonly IUnitOfWork unitOfWork;

        public AppointmentTypesService(IUnitOfWork unitOfWork) => this.unitOfWork = unitOfWork;

        public async Task<int> InsertAsync(AppointmentTypesModel model)
        {
            
                var param = await this.unitOfWork.Current.QuerySingleOrDefaultAsync<int>($@"Select count(*) from ""AppointmentType"" where  lower(""Name"") = '{model.Name.ToLower()}'");
                if (param > 0)
                {
                     return -1;
                }
                var appoinmentType = new AppointmentType
                {
                    CreatedBy = model.CreatedBy,
                    CreatedDate = DateTime.Now,
                    Name = model.Name,
                    RowColor = model.RowColor
                };
                return await this.unitOfWork.AppointmentTypes.InsertAsync(appoinmentType);
        }

        /// <inheritdoc/>
        public async Task<IEnumerable<AppointmentTypesModel>> FetchAllAsync(AppointmentTypesModel model)
        {

            var query = $@"select count(AP.""AppointmentTypeId"") over() as ""TotalItems"", AP.""AppointmentTypeId"", AP.""Name"",    AP.""CreatedBy"", AP.""CreatedDate"",
		                        AP.""ModifiedBy"", AP.""ModifiedDate"",AP.""RowColor"",
		                        C.""FullName"" as ""CreatedByName"", M.""FullName"" as ""ModifiedByName""
                             FROM ""AppointmentType"" AP 
                             left join ""Account"" C on C.""AccountId"" = AP.""CreatedBy""
                             left join ""Account"" M on M.""AccountId"" = AP.""ModifiedBy""";
                             

            return await this.unitOfWork.Current.QueryAsync<AppointmentTypesModel>(query);
        }


        /// <inheritdoc/>
        public async Task<int> UpdateAsync(AppointmentTypesModel model)
        {
            var checkIf = await this.unitOfWork.Current.QuerySingleOrDefaultAsync<int>($@"Select count(*) from ""AppointmentType"" where  lower(""Name"") = '{model.Name.ToLower()}' and ""AppointmentTypeId"" <>{model.AppointmentTypeId}");
            if (checkIf > 0)
            {
                return -1;
            }

            var record = await this.unitOfWork.AppointmentTypes.FindAsync(p => p.AppointmentTypeId == model.AppointmentTypeId);
            if (record == null)
            {
                return 0;
            }
            record.Name = model.Name;
            record.ModifiedBy = model.CreatedBy;
            record.ModifiedDate = DateTime.Now;
            record.RowColor = model.RowColor;

            return await this.unitOfWork.AppointmentTypes.UpdateAsync(record);
        }

        /// <inheritdoc/>
        public async Task<int> DeleteAsync(AppointmentTypesModel model)
        {
            var query = $@"DELETE FROM ""AppointmentType"" WHERE ""AppointmentTypeId""= {model.AppointmentTypeId}";
            return await this.unitOfWork.Current.ExecuteAsync(query);
        }
    }
}
