﻿using Dapper;
using Hims.Domain.Entities;
using Hims.Domain.Entities.Labs;
using Hims.Domain.Repositories.UnitOfWork;
using Hims.Domain.Services;
using Hims.Shared.UserModels.Laboratory;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading.Tasks;

namespace Hims.Infrastructure.Services
{
    public class LabVacutainerService : ILabVacutainerService
    {
        private readonly IUnitOfWork unitOfWork;

        public LabVacutainerService(IUnitOfWork unitOfWork)
        {
            this.unitOfWork = unitOfWork;
        }

        /// <inheritdoc/>
        public async Task<IEnumerable<LabVacutainerModel>> FetchAllVacutainerAsync(LabVacutainerModel model)
        {
            var where = "where 1=1";
            if(model.LabVacutainerName != null && !model.LabVacutainerName.Equals(""))
            {
                where += $@" AND LD.""LabVacutainerName"" ILike '%{model.LabVacutainerName}%' ";
            }
            if(model.Active != null)
            {
                where += $@"AND LD.""Active"" = {model.Active}";
            }

            var query = $@"SELECT count(LD.""LabVacutainerId"") over() ""TotalItems"", LD.""LabVacutainerId"", LD.""LabVacutainerName"", LD.""Active"", LD.""CreatedBy"", 
		                    LD.""CreatedDate"", LD.""ModifiedBy"", LD.""ModifiedDate"",
		                    CR.""FullName"" as ""CreatedByName"",
		                    MR.""FullName"" as ""ModifiedByName""
	                    FROM ""LabVacutainer"" LD
	                    join ""Account"" CR on CR.""AccountId"" = LD.""CreatedBy""
	                    left join ""Account"" MR on MR.""AccountId"" = LD.""ModifiedBy""
                        {where}
	                    order by LD.""LabVacutainerId"" desc";

            if (model.PageIndex != null && model.PageSize != null)
            {
                model.PageIndex = model.PageIndex > 0 ? model.PageIndex - 1 : model.PageIndex;
                query += $@" limit {model.PageSize} offset {model.PageSize * model.PageIndex}";
            }

            return await this.unitOfWork.Current.QueryAsync<LabVacutainerModel>(query);
        }

        /// <inheritdoc/>
        public async Task<int> ModifyLabVacutainer(LabVacutainerModel model)
        {

            var checkIfQuery = $@"SELECT count(""LabVacutainerId"")	FROM ""LabVacutainer"" where lower(""LabVacutainerName"") = '{model.LabVacutainerName.ToLower()}'";

            if (model.LabVacutainerId == 0)
            {
                var checkIf = await this.unitOfWork.Current.QuerySingleOrDefaultAsync<int>(checkIfQuery);
                if (checkIf > 0)
                {
                    return -1;
                }

                var Vacutainer = new LabVacutainer
                {
                    LabVacutainerId = model.LabVacutainerId,
                    Active = true,
                    CreatedBy = model.CreatedBy,
                    CreatedDate = DateTime.Now,
                    LabVacutainerName = model.LabVacutainerName
                };
                return await this.unitOfWork.LabVacutainerDetails.InsertAsync(Vacutainer);
            }
            else
            {
                checkIfQuery += $@" and ""LabVacutainerId"" <> {model.LabVacutainerId} ";
                var checkIf = await this.unitOfWork.Current.QuerySingleOrDefaultAsync<int>(checkIfQuery);
                if (checkIf > 0)
                {
                    return -2;
                }

                var oldRecord = await this.unitOfWork.LabVacutainerDetails.FindAsync(d => d.LabVacutainerId == model.LabVacutainerId);
                if (oldRecord == null)
                {
                    return -3;
                }

                oldRecord.LabVacutainerName = model.LabVacutainerName;
                oldRecord.ModifiedBy = model.CreatedBy;
                oldRecord.ModifiedDate = DateTime.Now;

                return await this.unitOfWork.LabVacutainerDetails.UpdateAsync(oldRecord);
            }

        }

        public async Task<int> ModifyLabVacutainerStatus(LabVacutainerModel model)
        {
                var query = $@"UPDATE ""LabVacutainer""
	                                SET ""Active""={model.Active}
	                                WHERE ""LabVacutainerId"" = {model.LabVacutainerId}";
                return await this.unitOfWork.Current.ExecuteAsync(query);
            
        }
    }
}
