﻿namespace Hims.Shared.Dapper.SqlGenerator
{
    using System.Text;

    /// <summary>
    /// A object with the generated sql and dynamic params.
    /// </summary>
    public class SqlQuery
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="SqlQuery"/> class.
        /// Initializes a new instance of the class.
        /// </summary>
        public SqlQuery() => this.SqlBuilder = new StringBuilder();

        /// <summary>
        /// Initializes a new instance of the <see cref="SqlQuery"/> class.
        /// </summary>
        /// <param name="param">
        /// The param.
        /// </param>
        public SqlQuery(object param)
        {
            this.Param = param;
            this.SqlBuilder = new StringBuilder();
        }

        /// <summary>
        /// Gets the sql builder.
        /// </summary>
        public StringBuilder SqlBuilder { get; }

        /// <summary>
        /// Gets the param.
        /// </summary>
        public object Param { get; private set; }

        /// <summary>
        /// The get sql.
        /// </summary>
        /// <returns>
        /// The <see cref="string"/>.
        /// </returns>
        public string GetSql() => this.SqlBuilder.ToString().Trim();

        /// <summary>
        /// The set param.
        /// </summary>
        /// <param name="param">
        /// The param.
        /// </param>
        public void SetParam(object param)
        {
            this.Param = param;
        }
    }
}