﻿namespace Hims.Shared.EntityModels
{
    using System;
    using System.Collections.Generic;

    /// <summary>
    /// The appointment.
    /// </summary>
    public class ShiftsModel
    {
        /// <summary>
        /// Gets or sets the shift slot map id.
        /// </summary>
        public int ShiftSlotMapId { get; set; }

        /// <summary>
        /// Gets or sets the shift id.
        /// </summary>
        public int ShiftId { get; set; }

        /// <summary>
        /// Gets or sets the shift name.
        /// </summary>
        public string Name { get; set; }

        /// <summary>
        /// Gets or sets the slot id.
        /// </summary>
        public int ShiftSlotId { get; set; }

        /// <summary>
        /// Gets or sets the start time.
        /// </summary>
        public TimeSpan? StartTime { get; set; }

        /// <summary>
        /// Gets or sets the end time.
        /// </summary>
        public TimeSpan? EndTime { get; set; }

        /// <summary>
        /// Gets or sets the Total items.
        /// </summary>
        public int? TotalItems { get; set; }

        /// <summary>
        /// Gets or sets the active.
        /// </summary>
        public bool Active { get; set; }

    }

    /// <summary>
    /// The appointment.
    /// </summary>
    public class ShiftsParentModel
    {
        /// <summary>
        /// Gets or sets the shift id.
        /// </summary>
        public int ShiftId { get; set; }

        /// <summary>
        /// Gets or sets the shift name.
        /// </summary>
        public string Name { get; set; }


        /// <summary>
        /// Gets or sets the active.
        /// </summary>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the slots.
        /// </summary>
        public List<ShiftsChildModel> Slots { get; set; }

        /// <summary>
        /// Gets or sets the Total items.
        /// </summary>
        public int? TotalItems { get; set; }
    }

    /// <summary>
    /// The appointment.
    /// </summary>
    public class ShiftsChildModel
    {
        /// <summary>
        /// Gets or sets the slot id.
        /// </summary>
        public int ShiftSlotId { get; set; }

        /// <summary>
        /// Gets or sets the start time.
        /// </summary>
        public TimeSpan StartTime { get; set; }

        /// <summary>
        /// Gets or sets the end time.
        /// </summary>
        public TimeSpan EndTime { get; set; }
    }
}
