﻿namespace Hims.Shared.UserModels.Discharge
{
    using System;
    
    /// <summary>
    /// The view model
    /// </summary>
    public class ViewModel
    {
        /// <summary>
        /// Gets or sets the discharge identifier.
        /// </summary>
        /// <value>
        /// The discharge identifier.
        /// </value>
        public int DischargeId { get; set; }

        /// <summary>
        /// Gets or sets the discharge date.
        /// </summary>
        /// <value>
        /// The discharge date.
        /// </value>
        public DateTime DischargeDate { get; set; }

        /// <summary>
        /// Gets or sets the discharge time.
        /// </summary>
        /// <value>
        /// The discharge time.
        /// </value>
        public TimeSpan DischargeTime { get; set; }

        /// <summary>
        /// Gets or sets the condition on discharge.
        /// </summary>
        /// <value>
        /// The condition on discharge.
        /// </value>
        public string ConditionOnDischarge { get; set; }

        /// <summary>
        /// Gets or sets the final diagnosis.
        /// </summary>
        /// <value>
        /// The final diagnosis.
        /// </value>
        public string FinalDiagnosis { get; set; }

        /// <summary>
        /// Gets or sets the history of illness.
        /// </summary>
        /// <value>
        /// The history of illness.
        /// </value>
        public string HistoryOfIllness { get; set; }

        /// <summary>
        /// Gets or sets the diet.
        /// </summary>
        /// <value>
        /// The diet.
        /// </value>
        public string Diet { get; set; }

        /// <summary>
        /// Gets or sets the discharge summary.
        /// </summary>
        /// <value>
        /// The discharge summary.
        /// </value>
        public string DischargeSummary { get; set; }

        /// <summary>
        /// Gets or sets the discharge follow up date.
        /// </summary>
        /// <value>
        /// The discharge follow up date.
        /// </value>
        public DateTime? DischargeFollowUpDate { get; set; }

        /// <summary>
        /// Gets or sets the discharge follow up days.
        /// </summary>
        /// <value>
        /// The discharge follow up days.
        /// </value>
        public int? DischargeFollowUpDays { get; set; }

        /// <summary>
        /// Gets or sets the follow up summary.
        /// </summary>
        /// <value>
        /// The follow up summary.
        /// </value>
        public string FollowUpSummary { get; set; }

        /// <summary>
        /// Gets or sets the discharge status identifier.
        /// </summary>
        /// <value>
        /// The discharge status identifier.
        /// </value>
        public int DischargeStatusId { get; set; }

        /// <summary>
        /// Gets or sets the name of the discharge status.
        /// </summary>
        /// <value>
        /// The name of the discharge status.
        /// </value>
        public string DischargeStatus { get; set; }

        /// <summary>
        /// Gets or sets the is death.
        /// </summary>
        /// <value>
        /// The is death.
        /// </value>
        public bool? IsDeath { get; set; }

        /// <summary>
        /// Gets or sets the death date.
        /// </summary>
        /// <value>
        /// The death date.
        /// </value>
        public DateTime? DeathDate { get; set; }

        /// <summary>
        /// Gets or sets the death time.
        /// </summary>
        /// <value>
        /// The death time.
        /// </value>
        public TimeSpan? DeathTime { get; set; }

        /// <summary>
        /// Gets or sets the cause of death.
        /// </summary>
        /// <value>
        /// The cause of death.
        /// </value>
        public string CauseOfDeath { get; set; }

        /// <summary>
        /// Gets or sets the discharge instruction identifier.
        /// </summary>
        /// <value>
        /// The discharge instruction identifier.
        /// </value>
        public string DischargeInstructionId { get; set; }

        /// <summary>
        /// Gets or sets the name of the discharge instruction.
        /// </summary>
        /// <value>
        /// The name of the discharge instruction.
        /// </value>
        public string DischargeInstructionName { get; set; }
        
        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        /// <value>
        /// The created by.
        /// </value>
        public string CreatedByName { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        /// <value>
        /// The created date.
        /// </value>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        /// <value>
        /// The modified by.
        /// </value>
        public string ModifiedByName { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        /// <value>
        /// The modified date.
        /// </value>
        public DateTime? ModifiedDate { get; set; }

        //----------------------------
        //for new discharge-Page
        //--------------------------

        /// <summary>
        /// Gets or sets the history of past illness.
        /// </summary>
        /// <value>
        /// The Past history.
        /// </value>
        public string? PastHistory { get; set; }

        /// <summary>
        /// Gets or sets the history of past illness.
        /// </summary>
        /// <value>
        /// The Past history.
        /// </value>
        public string? DischargeAdvise { get; set; }

        /// <summary>
        /// gets or sets the Surgery details.
        /// </summary>
        public string? Surgery { get; set; }

       
        /// <summary>
        /// gets or sets the GeneralExamination.
        /// </summary>
        public string? GeneralExamination { get; set; }

        /// <summary>
        /// gets or sets the LocalExamination.
        /// </summary>
        public string? LocalExamination { get; set; }

        /// <summary>
        /// gets or sets the HospitalCourse.
        /// </summary>
        public string? HospitalCourse { get; set; }

        /// <summary>
        /// gets or sets the OperativeProcedure.
        /// </summary>
        public string? OperativeProcedure { get; set; }

        /// <summary>
        /// gets or sets the OperativeNotes.
        /// </summary>
        public string? OperativeNotes { get; set; }

        /// <summary>
        /// gets or sets the ConsultantSignature.
        /// </summary>
        /// /// <value>
        /// The provider id (single).
        /// </value>
        public int? ConsultantSignature { get; set; }

        /// <summary>
        /// Gets or sets the providername as signature as consultant  by.
        /// </summary>
        /// <value>
        /// The modified by.
        /// </value>
        public string ConsultantSignatureName { get; set; }

        /// <summary>
        /// Gets or sets the Surgeons identifier.(providerId)
        /// </summary>
        /// <value>
        /// The Surgeons identifier.
        /// </value>
        public string SurgeonNamesId { get; set; }

        /// <summary>
        /// Gets or sets list of Surgoen Name .
        /// </summary>
        /// <value>
        /// The provider id (multiple).
        /// </value>
        public string? SurgeonNames { get; set; }



    }
}
