﻿#nullable enable
using System;

namespace Hims.Shared.UserModels.Filters
{
    /// <summary>
    /// The coupon filter model.
    /// </summary>
    public class RoomFilterModel
    {
        /// <summary>
        /// Gets or sets the bed id.
        /// </summary>
        public int? RoomId { get; set; }

        /// <summary>
        /// Gets or sets the bed id.
        /// </summary>
        public int? BedId { get; set; }

        /// <summary>
        /// Gets or sets the coupon code.
        /// </summary>
        public string RoomName { get; set; }

        /// <summary>
        /// Gets or sets the coupon code.
        /// </summary>
        public int RoomRent { get; set; }

        /// <summary>
        /// Gets or sets the bed id.
        /// </summary>
        public int? WardId { get; set; }

        /// <summary>
        /// Gets or sets the Floor id.
        /// </summary>
        public int? FloorId { get; set; }

        /// <summary>
        /// Gets or sets the coupon code.
        /// </summary>
        public string WardName { get; set; }

        /// <summary>
        /// Gets or sets the coupon code.
        /// </summary>
        public string BedNumber { get; set; }


        /// <summary>
        /// Gets or sets a value indicating whether active.
        /// </summary>
        public bool? Active { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public DateTime? CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the total items.
        /// </summary>
        public int? TotalItems { get; set; }

        /// <summary>
        /// Gets or sets the page index.
        /// </summary>
        public int PageIndex { get; set; }

        /// <summary>
        /// Gets or sets the page size.
        /// </summary>
        public int PageSize { get; set; }

        /// <summary>
        /// Gets or sets the floor name .
        /// </summary>
        public string FloorName { get; set; }

        /// <summary>
        /// Gets or sets the LocationId  .
        /// </summary>
        public int? LocationId { get; set; }
        /// <summary>
        /// Gets or sets the bed id.
        /// </summary>
        public int? OTRoomId { get; set; }
        // <summary>
        /// Gets or sets the bed id.
        /// </summary>
        public int SurgeryId { get; set; }
        /// <summary>
        /// Gets or sets the floor name .
        /// </summary>
        public string SurgeryName { get; set; }
        
      

        /// <summary>
        /// Gets or sets the bed id.
        /// </summary>
        public string Term { get; set; }
        /// <summary>
        /// Gets or sets the bed id.
        /// </summary>
        public int? ChargeCategoryId { get; set; }
    }
}
