﻿namespace Hims.Shared.UserModels.Insurance
{
    using System;

    /// <summary>
    /// The admission insurance model.
    /// </summary>
    public class AdmissionInsuranceModel
    {
        /// <summary>
        /// Gets or sets the insurance for admission id.
        /// </summary>
        public int? InsuranceForAdmissionId { get; set; }

        /// <summary>
        /// Gets or sets the insurance for admission id.
        /// </summary>
        public int? AppointmentId { get; set; }

        /// <summary>
        /// Gets or sets the insurance for admission id.
        /// </summary>
        public int? InsuranceApprovalId { get; set; }

        /// <summary>
        /// Gets or sets the insurance company id.
        /// </summary>
        public int? InsuranceCompanyId { get; set; }

        /// <summary>
        /// Gets or sets the patient insurance id.
        /// </summary>
        public int? PatientInsuranceId { get; set; }

        /// <summary>
        /// Gets or sets the admission id.
        /// </summary>
        public int? AdmissionId { get; set; }

        /// <summary>
        /// Gets or sets the expected amount.
        /// </summary>
        public double? ExpectedAmount { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public DateTime? CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the expected settlement date.
        /// </summary>
        public DateTime? ExpectedSettlementDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }

        // Additional properties

        /// <summary>
        /// Gets or sets the insurance company name.
        /// </summary>
        public string InsuranceCompanyName { get; set; }

        /// <summary>
        /// Gets or sets the admission no.
        /// </summary>
        public string AdmissionNo { get; set; }

        /// <summary>
        /// Gets or sets the admission no.
        /// </summary>
        public string InsuranceTypeName { get; set; }

        /// <summary>
        /// Gets or sets the status.
        /// </summary>
        public string Status { get; set; }

        /// <summary>
        /// Gets or sets the patient name.
        /// </summary>
        public string PatientName { get; set; }


        /// <summary>
        /// Gets or sets the gender.
        /// </summary>
        public string Gender { get; set; }

        /// <summary>
        /// Gets or sets the umr no.
        /// </summary>
        public string UMRNo { get; set; }

        /// <summary>
        /// Gets or sets the thumbnail url.
        /// </summary>
        public string ThumbnailUrl { get; set; }

        /// <summary>
        /// Gets or sets the created by name.
        /// </summary>
        public string CreatedByName { get; set; }

        /// <summary>
        /// Gets or sets the created by role.
        /// </summary>
        public string CreatedByRole { get; set; }

        /// <summary>
        /// Gets or sets the modified by name.
        /// </summary>
        public string ModifiedByName { get; set; }

        /// <summary>
        /// Gets or sets the modified by role.
        /// </summary>
        public string ModifiedByRole { get; set; }

        /// <summary>
        /// Gets or sets the age.
        /// </summary>
        public int? Age { get; set; }

        /// <summary>
        /// Gets or sets the admission date.
        /// </summary>
        public DateTime? AdmissionDate { get; set; }

        /// <summary>
        /// Gets or sets the total items.
        /// </summary>

        public int? TotalItems { get; set; }
        
         /// <summary>
        /// Gets or sets the page size.
        /// </summary>
        public int? PageSize { get; set; }

        /// <summary>
        /// Gets or sets the page index.
        /// </summary>
        public int? PageIndex { get; set; }

        /// <summary>
        /// Gets or sets the comment.
        /// </summary>
        public string Comment{get;set;}
        
        /// <summary>
        /// Gets or sets the attachments.
        /// </summary>
        public string Attachments{get;set;}
    }
}
