﻿using Hims.Shared.Dapper.Attributes;
using System.ComponentModel.DataAnnotations;

namespace Hims.Domain.Entities
{
    /// <summary>
    /// The account.
    /// </summary>
    public class LocationDepartmentMap
    {
        /// <summary>
        /// Gets or sets the location account map identifier.
        /// </summary>
        /// <value>
        /// The location account map identifier.
        /// </value>
        [Key, Identity]
        public int LocationDepartmentMapId { get; set; }

        /// <summary>
        /// Gets or sets the location identifier.
        /// </summary>
        /// <value>
        /// The location identifier.
        /// </value>
        public int LocationId { get; set; }

        /// <summary>
        /// Gets or sets the account identifier.
        /// </summary>
        /// <value>
        /// The account identifier.
        /// </value>
        public int DepartmentId { get; set; }
    }
}