﻿namespace Hims.Domain.Entities
{
    using System;
    using System.Collections.Generic;
    using System.ComponentModel.DataAnnotations;
    using System.Text;

    using Hims.Shared.Dapper.Attributes;

    /// <summary>
    /// The surgery kit header.
    /// </summary>
    public class SurgeryKitHeader
    {
        /// <summary>
        /// Gets or sets the surgery kit header id.
        /// </summary>
        [Key, Identity]
        public int SurgeryKitHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the kit name.
        /// </summary>
        public string KitName { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }
    }
}
