﻿namespace Hims.Domain.Entities
{
    using Hims.Shared.Dapper.Attributes;
    using System;
    using System.ComponentModel.DataAnnotations;

    /// <summary>
    /// The web notification.
    /// </summary>
    public class WebNotification
    {
        /// <summary>
        /// Gets or sets the web notification identifier.
        /// </summary>
        /// <value>
        /// The web notification identifier.
        /// </value>
        [Key, Identity]
        public int WebNotificationId { get; set; }

        /// <summary>
        /// Gets or sets the message.
        /// </summary>
        /// <value>
        /// The message.
        /// </value>
        public string Message { get; set; }

        /// <summary>
        /// Gets or sets the web notification priority identifier.
        /// </summary>
        /// <value>
        /// The web notification priority identifier.
        /// </value>
        public int WebNotificationPriorityId { get; set; }

        /// <summary>
        /// Gets or sets the web notification log type identifier.
        /// </summary>
        /// <value>
        /// The web notification log type identifier.
        /// </value>
        public int WebNotificationLogTypeId { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        /// <value>
        /// The created date.
        /// </value>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the redirection link.
        /// </summary>
        /// <value>
        /// The redirection link.
        /// </value>
        public string RedirectionLink { get; set; }

        /// <summary>
        /// Gets or sets the allowed roles.
        /// </summary>
        /// <value>
        /// The allowed roles.
        /// </value>
        public string AllowedRoles { get; set; }

        /// <summary>
        /// Gets or sets the allowed accounts.
        /// </summary>
        /// <value>
        /// The allowed accounts.
        /// </value>
        public string AllowedAccounts { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is read.
        /// </summary>
        /// <value>
        ///   <c>true</c> if this instance is read; otherwise, <c>false</c>.
        /// </value>
        public bool IsRead { get; set; }

        /// <summary>
        /// Gets or sets the patient identifier.
        /// </summary>
        /// <value>
        /// The patient identifier.
        /// </value>
        public int? PatientId { get; set; }

        /// <summary>
        /// Gets or sets the reference identifier.
        /// </summary>
        /// <value>
        /// The reference identifier.
        /// </value>
        public int? ReferenceId { get; set; }

        /// <summary>
        /// Gets or sets the modules master identifier.
        /// </summary>
        /// <value>
        /// The modules master identifier.
        /// </value>
        public int ModulesMasterId { get; set; }
    }
}
