﻿namespace Hims.Infrastructure.Repositories.UnitOfWork
{
    using System;
    using System.Collections.Generic;
    using System.Data;
    using System.Threading.Tasks;

    using Domain.Entities;
    using Domain.Entities.ChargeModules;
    using Domain.Entities.Pharmacy;
    using Domain.Entities.Inventory;
    using Domain.Entities.ProviderMedication;
    using Domain.Entities.Labs;
    using Domain.Entities.EncounterTemplates;
    using Domain.Repositories.Dapper;
    using Domain.Repositories.UnitOfWork;

    using global::Dapper;

    using Hims.Shared.EntityModels;

    using Infrastructure.Repositories.Dapper;

    using Microsoft.Extensions.Configuration;

    using Npgsql;

    using Shared.Dapper.SqlGenerator;
    using Hims.Domain.Entities.Vendors;
    using Hims.Domain.Entities.Vaccine;
    using Hims.Domain.Entities.PediatricGraph;

    /// <inheritdoc />
    public class UnitOfWork : IUnitOfWork
    {
        /// <summary>
        /// DB Connection for internal use
        /// </summary>
        private readonly IDbConnection connection;

        /// <summary>
        /// The config.
        /// </summary>
        private readonly SqlGeneratorConfig config = new SqlGeneratorConfig
        {
            SqlProvider = SqlProvider.PostgreSQL,
            UseQuotationMarks = true
        };

        private IDapperRepository<Counselling> counsellingRepository;

        /// <summary>
        /// The role Repository.
        /// </summary>
        private IDapperRepository<Role> roleRepository;

        /// <summary>
        /// The role Repository.
        /// </summary>
        private IDapperRepository<DischargeInstruction> dischargeInstructionRepository;

        /// <summary>
        /// The ward Repository.
        /// </summary>
        private IDapperRepository<Ward> wardRepository;

        /// <summary>
        /// The ward Repository.
        /// </summary>
        private IDapperRepository<Department> departmentsRepository;

        /// <summary>
        /// The ward Repository.
        /// </summary>
        private IDapperRepository<ChargeGroup> chargeGroupsRepository;

        /// <summary>
        /// The ward Repository.
        /// </summary>
        private IDapperRepository<Charge> chargeRepository;

        /// <summary>
        /// The ward Repository.
        /// </summary>
        private IDapperRepository<Bed> bedRepository;
        /// <summary>
        /// The ward Repository.
        /// </summary>
        private IDapperRepository<CallHistory> CallHistoryRepository;
        
        /// <summary>
        /// The ward Repository.
        /// </summary>
        private IDapperRepository<FeedbackDetails> feedbackDetailsRepository;
        /// <summary>
        /// The ward Repository.
        /// </summary>
        private IDapperRepository<ContactDetails> contactDetailsRepository;

        /// <summary>
        /// The ward Repository.
        /// </summary>
        private IDapperRepository<Room> roomRepository;

        /// <summary>
        /// The account Repository.
        /// </summary>
        private IDapperRepository<Account> accountRepository;

        /// <summary>
        /// The account credential repository.
        /// </summary>
        private IDapperRepository<AccountCredential> accountCredentialRepository;

        /// <summary>
        /// The account session repository.
        /// </summary>
        private IDapperRepository<AccountSession> accountSessionRepository;

        /// <summary>
        /// The user repository.
        /// </summary>
        private IDapperRepository<User> userRepository;

        /// <summary>
        /// The audit log repository.
        /// </summary>
        private IDapperRepository<AuditLog> auditLogRepository;

        /// <summary>
        /// The specialization repository.
        /// </summary>
        private IDapperRepository<Specialization> specializationRepository;

        /// <summary>
        /// The provide repository.
        /// </summary>
        private IDapperRepository<Provider> providerRepository;

        /// <summary>
        /// The provider encounter repository.
        /// </summary>
        private IDapperRepository<ProviderEncounter> providerEncounterRepository;

        /// <summary>
        /// The lab order value repository.
        /// </summary>
        private IDapperRepository<LabOrderValue> labOrderValueRepository;

        /// <summary>
        /// The lab order repository.
        /// </summary>
        private IDapperRepository<LabOrder> labOrderRepository;

        /// <summary>
        /// The lab order repository.
        /// </summary>
        private IDapperRepository<PatientConfiguration> patientConfigurationRepository;

        /// <summary>
        /// The provide bank account repository.
        /// </summary>
        private IDapperRepository<ProviderBankAccount> providerBankAccountRepository;

        /// <summary>
        /// The patient repository.
        /// </summary>
        private IDapperRepository<Patient> patientRepository;

        /// <summary>
        /// The country repository.
        /// </summary>
        private IDapperRepository<Country> countryRepository;

        /// <summary>
        /// The appointment repository.
        /// </summary>
        private IDapperRepository<Appointment> appointmentRepository;

        /// <summary>
        /// The appointment repository.
        /// </summary>
        private IDapperRepository<AppointmentSymptom> appointmentSymptomRepository;

        /// <summary>
        /// The appointment log repository.
        /// </summary>
        private IDapperRepository<AppointmentLog> appointmentLogRepository;

        /// <summary>
        /// The admission repository.
        /// </summary>
        private IDapperRepository<Admission> admissionRepository;

        /// <summary>
        /// The appointment status repository.
        /// </summary>
        private IDapperRepository<AppointmentTransaction> appointmentTransactionsRepository;

        /// <summary>
        /// The appointment exception log repository.
        /// </summary>
        private IDapperRepository<AppointmentExceptionLog> appointmentExceptionLogsRepository;
        /// <summary>
        /// The appointment exception log repository.
        /// </summary>
        private IDapperRepository<AppointmentHangfireMap> AppointmentHangfireMapsRepository;

        /// <summary>
        /// The coupon repository.
        /// </summary>
        private IDapperRepository<Coupon> couponRepository;

        /// <summary>
        /// The insurance company repository.
        /// </summary>
        private IDapperRepository<InsuranceCompany> insuranceCompanyRepository;

        /// <summary>
        /// The patient document repository.
        /// </summary>
        private IDapperRepository<PatientDocument> patientDocumentRepository;

        /// <summary>
        /// The payment document repository.
        /// </summary>
        private IDapperRepository<PaymentDocument> paymentDocumentRepository;

        /// <summary>
        /// The patient emergency repository.
        /// </summary>
        private IDapperRepository<PatientEmergency> patientEmergencyRepository;

        /// <summary>
        /// The patient insurance repository.
        /// </summary>
        private IDapperRepository<PatientInsurance> patientInsuranceRepository;

        /// <summary>
        /// The patient insurance approval repository.
        /// </summary>
        private IDapperRepository<InsuranceApproval> insuranceApprovalRepository;

        /// <summary>
        /// The practice repository.
        /// </summary>
        private IDapperRepository<Practice> practiceRepository;

        /// <summary>
        /// The provider location repository.
        /// </summary>
        private IDapperRepository<ProviderLocation> providerLocationRepository;

        /// <summary>
        /// The provider document repository.
        /// </summary>
        private IDapperRepository<ProviderDocument> providerDocumentRepository;

        /// <summary>
        /// The service repository.
        /// </summary>
        private IDapperRepository<Service> serviceRepository;

        /// <summary>
        /// The Encounter repository.
        /// </summary>
        private IDapperRepository<Encounter> encounterRepository;

        /// <summary>
        /// The Lookup repository.
        /// </summary>
        private IDapperRepository<Lookup> lookupRepository;

        /// <summary>
        /// The Lookup Value repository.
        /// </summary>
        private IDapperRepository<LookupValue> lookupValueRepository;

        /// <summary>
        /// The radiology Value repository.
        /// </summary>
        private IDapperRepository<RadiologyValue> radiologyValueRespository;

        /// <summary>
        /// The ICD Code repository.
        /// </summary>
        private IDapperRepository<ICDCode> icdCodeRepository;

        /// <summary>
        /// The CPT Code repository.
        /// </summary>
        private IDapperRepository<CPTCode> cptCodeRepository;

        /// <summary>
        /// The Dental Encounter repository.
        /// </summary>
        private IDapperRepository<DentalEncounter> dentalEncounterRepository;

        /// <summary>
        /// The Provider Leave repository.
        /// </summary>
        private IDapperRepository<ProviderLeave> providerLeaveRepository;

        /// <summary>
        ///
        /// </summary>
        private IDapperRepository<VideoCallHistory> videoCallHistoryRepository;

        /// <summary>
        ///
        /// </summary>
        private IDapperRepository<DoctorDeviceDetails> doctorDeviceHistoryRepository;

        /// <summary>
        ///
        /// </summary>
        private IDapperRepository<PatientDeviceDetails> patientDeviceHistoryRepository;

        /// <summary>
        ///
        /// </summary>
        private IDapperRepository<BehavioralHealth> behavioralHealthRepository;

        /// <summary>
        /// The Ticket repository.
        /// </summary>
        private IDapperRepository<Ticket> ticketRepository;

        /// <summary>
        /// The Web Telemedicine repository.
        /// </summary>
        private IDapperRepository<WebTelemedicine> webTelemedicineRepository;

        /// <summary>
        /// The Support Category repository.
        /// </summary>
        private IDapperRepository<SupportCategory> supportCategoryRepository;

        /// <summary>
        /// The Ticket Timeline repository.
        /// </summary>
        private IDapperRepository<TicketTimeline> ticketTimelineRepository;

        /// <summary>
        /// The Chat repository.
        /// </summary>
        private IDapperRepository<Chat> chatRepository;

        /// <summary>
        /// The general advice repository.
        /// </summary>
        private IDapperRepository<GeneralAdvice> generalAdviceRepository;

        /// <summary>
        /// The radiology repository.
        /// </summary>
        private IDapperRepository<Radiology> radiologyRepository;

        /// <summary>
        /// The refund repository.
        /// </summary>
        private IDapperRepository<Refund> refundRepository;

        private IDapperRepository<Homeopathy> homeopathyRepository;

        /// <summary>
        /// The Telemedicine History repository.
        /// </summary>
        private IDapperRepository<TelemedicineHistory> telemedicineHistoryRepository;

        /// <summary>
        /// The Telemedicine Users History repository.
        /// </summary>
        private IDapperRepository<TelemedicineCallHistory> telemedicineCallHistoryRepository;

        /// <summary>
        /// The Telemedicine Users History repository.
        /// </summary>
        private IDapperRepository<TelemedicineUsersHistory> telemedicineUsersHistoryRepository;

        /// <summary>
        ///
        /// </summary>
        private IDapperRepository<TelemedicineDomain> telemedicineDomainRepository;

        /// <summary>
        /// The ticket Assignee Repository.
        /// </summary>
        private IDapperRepository<TicketAssignee> ticketAssigneeRepository;

        /// <summary>
        /// The payment staus repository.
        /// </summary>
        private IDapperRepository<PaymentStatus> paymentStatusRepository;

        private IDapperRepository<WebHook> webHookRepository;

        /// <summary>
        /// The problem list repository.
        /// </summary>

        private IDapperRepository<ProblemList> problemListRepository;

        private IDapperRepository<Login> loginRepository;

        /// <summary>
        /// The appointment support log repository.
        /// </summary>
        private IDapperRepository<AppointmentSupportLog> appointmentSupportLogRepository;

        private IDapperRepository<Timeline> timelineRepository;

        private IDapperRepository<TimelineData> timelineDataRepository;

        private IDapperRepository<PatientFamily> patientFamilyRepository;

        /// <summary>
        /// The language repository.
        /// </summary>
        private IDapperRepository<Language> languageRepository;

        /// <summary>
        /// The Icons Repository.
        /// </summary>
        private IDapperRepository<Icons> iconsRepository;

        private IDapperRepository<NotificationLog> notificationLogRepository;

        /// <summary>
        /// The message repository.
        /// </summary>
        private IDapperRepository<Message> messageRepository;

        /// <summary>
        /// The wallet repository.
        /// </summary>
        private IDapperRepository<Wallet> walletRepository;

        /// <summary>
        /// The supplier repository.
        /// </summary>
        private IDapperRepository<Supplier> supplierRepository;

        /// <summary>
        /// The company repository.
        /// </summary>
        private IDapperRepository<Company> companyRepository;

        /// <summary>
        /// The inventory product repository.
        /// </summary>
        private IDapperRepository<InventoryProduct> inventoryProductRepository;

        /// <summary>
        /// The inventory purchase header repository.
        /// </summary>
        private IDapperRepository<InventoryPurchaseHeader> inventoryPurchaseHeaderRepository;

        /// <summary>
        /// The inventory stock repository.
        /// </summary>
        private IDapperRepository<InventoryStock> inventoryStockRepository;

        /// <summary>
        /// The inventory purchase detail repository.
        /// </summary>
        private IDapperRepository<InventoryPurchaseDetail> inventoryPurchaseDetailRepository;

        /// <summary>
        /// The inventory purchase return header repository.
        /// </summary>
        private IDapperRepository<InventoryPurchaseReturnHeader> inventoryPurchaseReturnHeaderRepository;

        /// <summary>
        /// The inventory purchase return detail repository.
        /// </summary>
        private IDapperRepository<InventoryPurchaseReturnDetail> inventoryPurchaseReturnDetailRepository;

        /// The receipt repository
        /// </summary>
        private IDapperRepository<Receipt> receiptRepository;

        /// <summary>
        /// The service order repository
        /// </summary>
        private IDapperRepository<ServiceOrder> serviceOrderRepository;

        /// <summary>
        /// The lab services repository
        /// </summary>
        private IDapperRepository<LabServices> labServicesRepository;

        /// <summary>
        /// The final bill repository
        /// </summary>
        private IDapperRepository<FinalBill> finalBillRepository;

        /// <summary>
        /// The final bill service order repository
        /// </summary>
        private IDapperRepository<FinalBillServiceOrder> finalBillServiceOrderRepository;

        /// <summary>
        /// The indent header repository.
        /// </summary>
        private IDapperRepository<IndentHeader> indentHeaderRepository;

        /// <summary>
        /// The indent detail repository.
        /// </summary>
        private IDapperRepository<IndentDetail> indentDetailRepository;

        /// <summary>
        /// The isssue header repository.
        /// </summary>
        private IDapperRepository<IssueHeader> isssueHeaderRepository;

        /// <summary>
        /// The isssue detail repository.
        /// </summary>
        private IDapperRepository<IssueDetail> isssueDetailRepository;

        /// <summary>
        /// The discharge repository.
        /// </summary>
        private IDapperRepository<Discharge> dischargeRepository;

        /// The menu repository
        /// </summary>
        private IDapperRepository<Menu> menuRepository;

        /// <summary>
        /// The menu relationship repository
        /// </summary>
        private IDapperRepository<MenuRelationship> menuRelationshipRepository;

        /// <summary>
        /// The menu access repository
        /// </summary>
        private IDapperRepository<MenuAccess> menuAccessRepository;

        /// <summary>
        /// The pharmacy product repository.
        /// </summary>
        private IDapperRepository<PharmacyProduct> pharmacyProductRepository;

        /// <summary>
        /// The pharmacy purchase header repository.
        /// </summary>
        private IDapperRepository<PharmacyPurchaseHeader> pharmacyPurchaseHeaderRepository;

        /// <summary>
        /// The pharmacy stock repository.
        /// </summary>
        private IDapperRepository<PharmacyStock> pharmacyStockRepository;

        /// <summary>
        /// The pharmacy purchase detail repository.
        /// </summary>
        private IDapperRepository<PharmacyPurchaseDetail> pharmacyPurchaseDetailRepository;

        /// <summary>
        /// The pharmacy retail stock repository.
        /// </summary>
        private IDapperRepository<PharmacyRetailStock> pharmacyRetailStockRepository;


        /// <summary>
        /// the feedback repository.
        /// </summary>
        private IDapperRepository<Feedback> feedbacksRepository;

        /// <summary>
        /// the feedback repository.
        /// </summary>
        private IDapperRepository<QuestionFeedback> questionFeedbacksRepository;

        /// <summary>
        /// The pharmacy sale header repository.
        /// </summary>
        private IDapperRepository<PharmacySaleHeader> pharmacySaleHeaderRepository;

        /// <summary>
        /// The pharmacy sale detail repository.
        /// </summary>
        private IDapperRepository<PharmacySaleDetail> pharmacySaleDetailRepository;

        /// <summary>
        /// The surgery kit header repository.
        /// </summary>
        private IDapperRepository<SurgeryKitHeader> surgeryKitHeaderRepository;

        /// <summary>
        /// The surgery kit detail repository.
        /// </summary>
        private IDapperRepository<SurgeryKitDetail> surgeryKitDetailRepository;

        /// <summary>
        /// The pharmacy indent header repository.
        /// </summary>
        private IDapperRepository<PharmacyIndentHeader> pharmacyIndentHeaderRepository;

        /// <summary>
        /// The pharmacy indent detail repository.
        /// </summary>
        private IDapperRepository<PharmacyIndentDetail> pharmacyIndentDetailRepository;

        /// <summary>
        /// The pharmacy issue header repository.
        /// </summary>
        private IDapperRepository<PharmacyIssueHeader> pharmacyIssueHeaderRepository;

        /// <summary>
        /// The pharmacy issue detail repository.
        /// </summary>
        private IDapperRepository<PharmacyIssueDetail> pharmacyIssueDetailRepository;

        /// <summary>
        /// The sale return header repository.
        /// </summary>
        private IDapperRepository<SaleReturnHeader> saleReturnHeaderRepository;

        /// <summary>
        /// The sale return detail repository.
        /// </summary>
        private IDapperRepository<SaleReturnDetail> saleReturnDetailRepository;

        /// <summary>
        /// The package repository
        /// </summary>
        private IDapperRepository<Package> packageRepository;

        /// <summary>
        /// The package repository
        /// </summary>
        private IDapperRepository<PackageCharge> packageChargeRepository;

        /// <summary>
        /// The admission package repository
        /// </summary>
        private IDapperRepository<AdmissionPackage> admissionPackageRepository;

        /// <summary>
        /// The lab header repository.
        /// </summary>
        private IDapperRepository<LabHeader> labHeaderRepository;

        /// <summary>
        /// The lab detail repository.
        /// </summary>
        private IDapperRepository<LabDetail> labDetailRepository;

        /// <summary>
        /// The lab booking header repository.
        /// </summary>
        private IDapperRepository<LabBookingHeader> labBookingHeaderRepository;

        /// <summary>
        /// The lab booking detail repository.
        /// </summary>
        private IDapperRepository<LabBookingDetail> labBookingDetailRepository;

        /// <summary>
        /// The lab patient parameter repository.
        /// </summary>
        private IDapperRepository<LabPatientParameter> labPatientParameterRepository;

        /// <summary>
        /// The progress report repository
        /// </summary>
        private IDapperRepository<ProgressReport> progressReportRepository;

        /// <summary>
        /// The progress report medication repository
        /// </summary>
        private IDapperRepository<ProgressReportMedication> progressReportMedicationRepository;

        /// <summary>
        /// The progress report medication daily repository
        /// </summary>
        private IDapperRepository<ProgressReportMedicationDaily> progressReportMedicationDailyRepository;

        /// The pharmacy retail to main repository.
        /// </summary>
        private IDapperRepository<PharmacyRetailToMain> pharmacyRetailToMainRepository;

        /// <summary>
        /// The sms log repository.
        /// </summary>
        private IDapperRepository<SMSLog> smsLogRepository;

        /// <summary>
        /// The pharmacy purchase return header repository.
        /// </summary>
        private IDapperRepository<PharmacyPurchaseReturnHeader> pharmacyPurchaseReturnHeaderRepository;

        /// <summary>
        /// The pharmacy purchase return detail repository.
        /// </summary>
        private IDapperRepository<PharmacyPurchaseReturnDetail> pharmacyPurchaseReturnDetailRepository;

        /// <summary>
        /// The lab package repository
        /// </summary>
        private IDapperRepository<LabPackage> labPackageRepository;

        /// <summary>
        /// The lab package detail repository.
        /// </summary>
        private IDapperRepository<LabPackageDetail> labPackageDetailRepository;

        /// <summary>
        /// The lab booking package detail repository.
        /// </summary>
        private IDapperRepository<LabBookingPackageDetail> labBookingPackageDetailRepository;

        /// <summary>
        /// The pharmacy log repository.
        /// </summary>
        private IDapperRepository<PharmacyLog> pharmacyLogRepository;
        /// <summary>
        /// The inventory log repository.
        /// </summary>
        private IDapperRepository<InventoryLog> inventoryLogRepository;

        /// <summary>
        /// The dynamic report repository.
        /// </summary>
        private IDapperRepository<DynamicReport> dynamicReportRepository;

        /// <summary>
        /// The lab log repository.
        /// </summary>
        private IDapperRepository<LabLog> labLogRepository;

        /// <summary>
        /// The scan log repository.
        /// </summary>
        private IDapperRepository<ScanLog> scanLogRepository;

        /// <summary>
        /// The excel upload history repository.
        /// </summary>
        private IDapperRepository<ExcelUploadHistory> excelUploadHistoryRepository;

        /// <summary>
        /// The widget repository.
        /// </summary>
        private IDapperRepository<DashboardWidget> dashboardWidgetRepository;

        /// <summary>
        /// The config repository.
        /// </summary>
        private IDapperRepository<DashboardConfig> dashboardConfigRepository;

        /// <summary>
        /// The widget role repository.
        /// </summary>
        private IDapperRepository<DashboardWidgetRole> dashboardWidgetRoleRepository;

        /// <summary>
        /// The dashboard configuration master repository
        /// </summary>
        private IDapperRepository<DashboardConfigMaster> dashboardConfigMasterRepository;

        /// <summary>
        /// The visit type Repository.
        /// </summary>
        private IDapperRepository<VisitType> visitTypeRepository;

        /// <summary>
        /// The charge type Repository
        /// </summary>
        private IDapperRepository<ChargeTypes> chargeTypesRepository;

        /// <summary>
        /// The image Repository.
        /// </summary>
        private IDapperRepository<PrintSetting> PrintSettingRepository;

        /// <summary>
        /// The ward Repository.
        /// </summary>
        private IDapperRepository<Floor> floorRepository;

        /// <summary>
        /// The tpa repository
        /// </summary>
        private IDapperRepository<Tpa> tpaRepository;

        /// <summary>
        /// The retail pharmacy repository.
        /// </summary>
        private IDapperRepository<RetailPharmacy> retailPharmacyRepository;

        /// <summary>
        /// The ot call log repository.
        /// </summary>
        private IDapperRepository<CallLog> callLogRepository;

        /// <summary>
        /// The telemedicine template repository
        /// </summary>
        private IDapperRepository<TelemedicineTemplate> telemedicineTemplateRepository;

        /// <summary>
        /// The telemedicine template history repository
        /// </summary>
        private IDapperRepository<TelemedicineTemplateHistory> telemedicineTemplateHistoryRepository;

        ///<summary>
        /// The surgeons repository.
        /// </summary>
        private IDapperRepository<Surgeons> surgeonsRepository;

        /// <summary>
        /// The insurance for admission repository.
        /// </summary>
        /// <returns></returns>
        private IDapperRepository<InsuranceForAdmission> isuranceForAdmissionRepository;

        /// <summary>
        /// The insurance timeline repository.
        /// </summary>
        private IDapperRepository<InsuranceTimeline> insuranceTimelineRepository;

        /// <summary>
        /// The slot Repository.
        /// </summary>
        private IDapperRepository<ShiftSlot> shiftSlotlotRepository;

        /// <summary>
        /// The slot Repository.
        /// </summary>
        private IDapperRepository<Shift> shiftRepository;

        /// <summary>
        /// The slot Repository.
        /// </summary>
        private IDapperRepository<ShiftSlotMap> shiftSlotMapRepository;

        /// <summary>
        /// The progress report medication frequency repository
        /// </summary>
        private IDapperRepository<ProgressReportMedicationFrequency> progressReportMedicationFrequencyRepository;

        /// <summary>
        /// The progress report note repository
        /// </summary>
        private IDapperRepository<ProgressReportNote> progressReportNoteRepository;

        /// <summary>
        /// The ward Repository.
        /// </summary>
        private IDapperRepository<NurseShiftMap> nurseShiftMapRepository;

        /// <summary>
        /// The ward Repository.
        /// </summary>
        private IDapperRepository<NurseShiftBedMap> nurseShiftBedMapRepository;

        /// <summary>
        /// The ot indent detail repository.
        /// </summary>
        private IDapperRepository<FinalBillInsurance> finalBillInsuranceRepository;

        /// <summary>
        /// The font Repository.
        /// </summary>
        private IDapperRepository<FontType> FontTypeRepository;

        /// <summary>
        /// The vital type Repository.
        /// </summary>
        private IDapperRepository<VitalType> vitalTypeRepository;


        /// <summary>
        /// The progress report vitals repository
        /// </summary>
        private IDapperRepository<ProgressReportVitals> progressReportVitalsRepository;


        /// <summary>
        /// The progress report assessments repository
        /// </summary>
        private IDapperRepository<ProgressReportAssessments> progressReportAssessmentsRepository;

        /// <summary>
        /// The unit type Repository.
        /// </summary>
        private IDapperRepository<UnitType> unitTypeRepository;

        /// <summary>
        /// The discount module repository.
        /// </summary>
        private IDapperRepository<DiscountModule> discountModuleRepository;

        /// <summary>
        /// The discounts per module repository.
        /// </summary>
        private IDapperRepository<DiscountsPerModule> discountsPerModuleRepository;

        /// <summary>
        /// The assessment type Repository.
        /// </summary>
        private IDapperRepository<AssessmentType> assessmentTypeRepository;

        /// <summary>
        /// The supplier product repository.
        /// </summary>
        private IDapperRepository<SupplierProduct> supplierProductRepository;

        /// <summary>
        /// The patient timing repository
        /// </summary>
        private IDapperRepository<PatientTiming> patientTimingRepository;

        /// <summary>
        /// The medication move repository.
        /// </summary>
        private IDapperRepository<MedicationMove> medicationMoveRepository;

        /// <summary>
        /// The operation indent header repository.
        /// </summary>
        private IDapperRepository<OperationIndentHeader> operationIndentHeaderRepository;

        /// <summary>
        /// The operation indent detail repository.
        /// </summary>
        private IDapperRepository<OperationIndentDetail> operationIndentDetailRepository;

        /// <summary>
        /// The operation stock repository.
        /// </summary>
        private IDapperRepository<OperationStock> operationStockRepository;

        /// <summary>
        /// The provider location operation repository.
        /// </summary>
        private IDapperRepository<ProviderLocationOperation> providerLocationOperationRepository;

        /// <summary>
        /// The surgery repository.
        /// </summary>
        private IDapperRepository<Surgery> surgeryRepository;

        /// <summary>
        /// The surgery charge repository.
        /// </summary>
        private IDapperRepository<SurgeryCharge> surgeryChargeRepository;

        /// <summary>
        /// The ot room repository.
        /// </summary>
        private IDapperRepository<OTRoom> otRoomRepository;

        /// <summary>
        /// The ot room repository.
        /// </summary>
        private IDapperRepository<DemandBook> demandBookRepository;

        /// <summary>
        /// The ot room repository.
        /// </summary>
        private IDapperRepository<PharmacyRetailUser> pharmacyRetailUserRepository;

        /// <summary>
        /// The module master repository.
        /// </summary>
        private IDapperRepository<ModulesMaster> modulesMasterRepository;

        /// <summary>
        /// The module reference repository.
        /// </summary>
        private IDapperRepository<PatientReferredBy> referenceTypeRepository;

        /// <summary>
        /// The pharmacy store repository.
        /// </summary>
        private IDapperRepository<PharmacyStore> pharmacyStoreRepository;

        /// <summary>
        /// The meal type repository.
        /// </summary>
        private IDapperRepository<MealTypes> mealTypesRepository;

        /// <summary>
        /// The pharmacy ware house repository.
        /// </summary>
        private IDapperRepository<PharmacyWareHouse> pharmacyWareHouseRepository;

        /// <summary>
        /// The pharmacy ware house user repository.
        /// </summary>
        private IDapperRepository<PharmacyWareHouseUser> pharmacyWareHouseUserRepository;

        /// <summary>
        /// The pharmacy ware house user repository.
        /// </summary>
        private IDapperRepository<ProgressReportDiet> progressReportDietRepository;

        /// <summary>
        /// The retail ware house link repository.
        /// </summary>
        private IDapperRepository<RetailWareHouseLink> retailWareHouseLinkRepository;

        /// <summary>
        /// The payment staus repository.
        /// </summary>
        private IDapperRepository<PayType> payTypeRepository;

        /// <summary>
        /// The payment staus gyn encounter.
        /// </summary>
        private IDapperRepository<GynEncounter> gynEncounterRepository;

        /// <summary>
        /// The employee shift repository.
        /// </summary>
        private IDapperRepository<EmployeeShift> employeeShiftRepository;

        /// <summary>
        /// The employee shift repository.
        /// </summary>
        private IDapperRepository<LeaveType> leaveTypeRepository;

        /// <summary>
        /// The location account map repository
        /// </summary>
        private IDapperRepository<LocationAccountMap> locationAccountMapRepository;

        /// <summary>
        /// The location department map repository
        /// </summary>
        private IDapperRepository<LocationDepartmentMap> locationDepartmentMapRepository;

        /// <summary>
        /// The location package map repository
        /// </summary>
        private IDapperRepository<LocationPackageMap> locationPackageMapRepository;

        /// <summary>
        /// The location meal types map repository
        /// </summary>
        private IDapperRepository<LocationMealTypesMap> locationMealTypesMapRepository;

        /// <summary>
        /// The location lab header map repository
        /// </summary>
        private IDapperRepository<LocationLabHeaderMap> locationLabHeaderMapRepository;

        /// <summary>
        /// The location lab package map repository
        /// </summary>
        private IDapperRepository<LocationLabPackageMap> locationLabPackageMapRepository;

        /// <summary>
        /// The location floor map repository
        /// </summary>
        private IDapperRepository<LocationFloorMap> locationFloorMapRepository;

        /// <summary>
        /// The location specialization map repository
        /// </summary>
        private IDapperRepository<LocationSpecializationMap> locationSpecializationMapRepository;

        /// <summary>
        /// The ob encounter repository
        /// </summary>
        private IDapperRepository<ObEncounter> obEncounterRepository;

        /// <summary>
        /// The location repository
        /// </summary>
        private IDapperRepository<Location> locationRepository;

        /// <summary>
        /// The HWC patient repository
        /// </summary>
        private IDapperRepository<HWCPatient> hwcPatientRepository;

        /// <summary>
        /// The patient registration charge repository
        /// </summary>
        private IDapperRepository<PatientRegistrationCharge> patientRegistrationChargeRepository;

        /// <summary>
        /// The patient registration detail repository
        /// </summary>
        private IDapperRepository<PatientRegistrationDetail> patientRegistrationDetailRepository;

        /// <summary>
        /// The scan test master repository
        /// </summary>
        private IDapperRepository<ScanTestMaster> scanTestMasterRepository;

        /// <summary>
        /// The scantest location map repository
        /// </summary>
        private IDapperRepository<LocationScanTestMasterMap> locationScanTestMasterMapRepository;

        /// <summary>
        /// The scan machine master repository
        /// </summary>
        private IDapperRepository<ScanMachineMaster> scanMachineMasterRepository;

        /// <summary>
        /// The scan machine map repository
        /// </summary>
        private IDapperRepository<ScanMachineTestMap> scanMachineTestMapRepository;

        /// <summary>
        /// The charge category repository
        /// </summary>
        private IDapperRepository<ChargeCategory> chargeCategoryRepository;

        ///<summary>
        ///the id proof repository
        ///</summary>

        private IDapperRepository<IdProof> idProofRepository;

        ///<summary>
        ///the Machine Repository
        ///</summary>

        private IDapperRepository<Machine> MachineRepository;
        /// <summary>
        /// The lab department repository.
        /// </summary>
        private IDapperRepository<LabDepartment> labDepartmentRepository;


        /// <summary>
        /// Gets the scan machine availability repository.
        /// </summary>

        private IDapperRepository<ScanMachineAvailability> scanMachineAvailabilityRepository;

        /// <summary>
        /// The patient medication header repository.
        /// </summary>
        private IDapperRepository<PatientMedicationHeader> patientMedicationHeaderRepository;

        /// <summary>
        /// The patient medication detail repository.
        /// </summary>
        private IDapperRepository<PatientMedicationDetail> patientMedicationDetailRepository;

        /// <summary>
        /// The web notification repository.
        /// </summary>
        private IDapperRepository<WebNotification> webNotificationRepository;

        /// <summary>
        /// The book scan appointment repository.
        /// </summary>
        private IDapperRepository<BookScanAppointment> bookScanAppointmentRepository;

        /// <summary>
        /// The patient lab header repository.
        /// </summary>
        private IDapperRepository<PatientLabHeader> patientLabHeaderRepository;

        /// <summary>
        /// The patient lab detail repository.
        /// </summary>
        private IDapperRepository<PatientLabDetail> patientLabDetailRepository;


        /// <summary>
        /// The pharmacy product rack repository.
        /// </summary>
        private IDapperRepository<PharmacyProductRack> pharmacyProductRackRepository;

        /// <summary>
        /// The pharmacy product detail repository
        /// </summary>
        private IDapperRepository<PharmacyProductDetail> pharmacyProductDetailRepository;

        /// <summary>
        /// The pharmacy departmental stock repository
        /// </summary>
        private IDapperRepository<PharmacyDepartmentalStock> pharmacyDepartmentalStockRepository;

        /// <summary>
        /// The pharmacy department repository.
        /// </summary>
        private IDapperRepository<PharmacyDepartment> pharmacyDepartmentRepository;

        /// <summary>
        /// The pharmacy department user repository.
        /// </summary>
        private IDapperRepository<PharmacyDepartmentUser> pharmacyDepartmentUserRepository;

        /// <summary>
        /// The scan classification repository.
        /// </summary>
        private IDapperRepository<ScanClassification> scanClassificationRepository;

        /// <summary>
        /// The scan sub classification repository.
        /// </summary>
        private IDapperRepository<ScanSubClassification> scanSubClassificationRepository;

        /// <summary>
        /// The department consumption repository.
        /// </summary>
        private IDapperRepository<DepartmentConsumption> departmentConsumptionRepository;

        /// <summary>
        /// The pharmacy issued stock header repository.
        /// </summary>
        private IDapperRepository<PharmacyIssuedStockHeader> pharmacyIssuedStockHeaderRepository;

        /// <summary>
        /// The pharmacy issued stock detail repository.
        /// </summary>
        private IDapperRepository<PharmacyIssuedStockDetail> pharmacyIssuedStockDetailRepository;

        /// <summary>
        /// The inventory ware house repository.
        /// </summary>
        private IDapperRepository<InventoryWareHouse> inventoryWareHouseRepository;

        /// <summary>
        /// The inventory ware house user repository.
        /// </summary>
        private IDapperRepository<InventoryWareHouseUser> inventoryWareHouseUserRepository;

        /// <summary>
        /// The inventory department repository.
        /// </summary>
        private IDapperRepository<InventoryDepartment> inventoryDepartmentRepository;

        /// <summary>
        /// The inventory department user repository.
        /// </summary>
        private IDapperRepository<InventoryDepartmentUser> inventoryDepartmentUserRepository;

        /// <summary>
        /// The inventory departmental stock repository.
        /// </summary>
        private IDapperRepository<InventoryDepartmentalStock> inventoryDepartmentalStockRepository;

        /// <summary>
        /// The provider consultation room repository.
        /// </summary>
        private IDapperRepository<ProviderConsultationRoom> providerConsultationRoomRepository;

        /// <summary>
        /// The inventory issued stock header repository.
        /// </summary>
        private IDapperRepository<InventoryIssuedStockHeader> inventoryIssuedStockHeaderRepository;

        /// <summary>
        /// The inventory issued stock detail repository.
        /// </summary>
        private IDapperRepository<InventoryIssuedStockDetail> inventoryIssuedStockDetailRepository;

        /// <summary>
        /// The inventory product detail repository.
        /// </summary>
        private IDapperRepository<InventoryProductDetail> inventoryProductDetailRepository;

        /// <summary>
        /// The inventory product rack repository.
        /// </summary>
        private IDapperRepository<InventoryProductRack> inventoryProductRackRepository;

        /// <summary>
        /// The inventory department consumption repository.
        /// </summary>
        private IDapperRepository<InventoryDepartmentConsumption> inventoryDepartmentConsumptionRepository;

        /// <summary>
        /// The provider medication group repository.
        /// </summary>
        private IDapperRepository<ProviderMedicationGroup> providerMedicationGroupRepository;

        /// <summary>
        /// The provider medication master repository.
        /// </summary>
        private IDapperRepository<ProviderMedicationMaster> providerMedicationMasterRepository;

        /// <summary>
        /// The provider medication map repository.
        /// </summary>
        private IDapperRepository<ProviderMedicationMap> providerMedicationMapRepository;

        /// <summary>
        /// The order prescription value repository.
        /// </summary>
        private IDapperRepository<OrderPrescriptionValue> orderPrescriptionValueRepository;

        /// <summary>
        /// The lab parameter header repository.
        /// </summary>
        private IDapperRepository<LabParameterHeader> labParameterHeaderRepository;

        /// <summary>
        /// The lab parameter detail repository.
        /// </summary>
        private IDapperRepository<LabParameterDetail> labParameterDetailRepository;

        /// <summary>
        /// The lab componenet header repository.
        /// </summary>
        private IDapperRepository<LabComponentHeader> labComponentHeaderRepository;

        /// <summary>
        /// The lab component detail repository.
        /// </summary>
        private IDapperRepository<LabComponentDetail> labComponentDetailRepository;

        /// <summary>
        /// The lab template detail repository.
        /// </summary>
        private IDapperRepository<LabTemplateDetail> labTemplateDetailRepository;


        /// <summary>
        /// The lab template header repository.
        /// </summary>
        private IDapperRepository<LabTemplateHeader> labTemplateHeaderRepository;

        /// <summary>
        /// The appointment repository.
        /// </summary>
        private IDapperRepository<AppointmentType> appointmentTypesRepository;

        /// <summary>
        /// The lab parameter method repository.
        /// </summary>
        private IDapperRepository<LabParameterMethod> labParameterMethodRepository;

        /// <summary>
        /// The lab sample type repository.
        /// </summary>
        private IDapperRepository<LabSampleType> labSampleTypeRepository;

        /// <summary>
        /// The lab main detail repository.
        /// </summary>
        private IDapperRepository<LabMainDetail> labMainDetailRepository;

        /// <summary>
        /// The lab main detail template repository.
        /// </summary>
        private IDapperRepository<LabMainDetailTemplate> labMainDetailTemplateRepository;

        /// <summary>
        /// The lab booking status repository.
        /// </summary>
        private IDapperRepository<LabBookingStatus> labBookingStatusRepository;

        /// <summary>
        /// The new lab booking header repository.
        /// </summary>
        private IDapperRepository<NewLabBookingHeader> newLabBookingHeaderRepository;

        /// <summary>
        /// The new lab booking header repository.
        /// </summary>
        private IDapperRepository<NewLabCancelBookingHeader> newLabCancelBookingHeaderRepository;

        /// <summary>
        /// The new lab booking detail repository.
        /// </summary>
        private IDapperRepository<NewLabBookingDetail> newLabBookingDetailRepository;

        /// <summary>
        /// The new lab booking detail repository.
        /// </summary>
        private IDapperRepository<NewLabCancelBookingDetail> newLabCancelBookingDetailRepository;

        /// <summary>
        /// The lab booking time line repository.
        /// </summary>
        private IDapperRepository<LabBookingTimeLine> labBookingTimeLineRepository;

        /// <summary>
        /// The dynamic template repository.
        /// </summary>
        private IDapperRepository<DynamicTemplate> dynamicTemplateRepository;

        /// <summary>
        /// The lab sample collection repository.
        /// </summary>
        private IDapperRepository<LabSampleCollection> labSampleCollectionRepository;

        /// <summary>
        /// The pay category repository.
        /// </summary>
        private IDapperRepository<PayCategory> payCategoryRepository;

        /// <summary>
        /// the salutation repository
        /// </summary>
        private IDapperRepository<Salutation> salutationRepository;

        /// <summary>
        /// The lab transfer header repository.
        /// </summary>
        private IDapperRepository<LabTransferHeader> labTransferHeaderRepository;

        /// <summary>
        /// The lab transfer detail repository.
        /// </summary>
        private IDapperRepository<LabTransferDetail> labTransferDetailRepository;

        /// <summary>
        /// The component type repository.
        /// </summary>
        private IDapperRepository<ComponentType> componentTypeRepository;

        /// <summary>
        /// The component repository.
        /// </summary>
        private IDapperRepository<Component> componentRepository;

        /// <summary>
        /// The template repository.
        /// </summary>
        private IDapperRepository<Template> templateRepository;

        /// <summary>
        /// The lab parameter observed value repository.
        /// </summary>
        private IDapperRepository<LabParameterObservedValue> labParameterObservedValueRepository;

        /// <summary>
        /// The lab template observed value repository.
        /// </summary>
        private IDapperRepository<LabTemplateObservedValue> labTemplateObservedValueRepository;

        /// <summary>
        /// The template repository.
        /// </summary>
        private IDapperRepository<Settings> settingsRepository;

        /// <summary>
        /// The template repository.
        /// </summary>
        private IDapperRepository<ReferralDoctor> refferalDoctorpository;
        /// <summary>
        /// The template repository.
        /// </summary>
        private IDapperRepository<PatientTransaction> patientTransactionRepository;

        /// <summary>
        /// The provider schedule charge type Repository.
        /// </summary>
        private IDapperRepository<ProviderAvailabilityChargeType> providerAvailabilityChargeTypeRepository;

        /// <summary>
        /// The provider schedule charge type Repository.
        /// </summary>
        private IDapperRepository<ProviderScheduleCharge> providerScheduleChargesRepository;

        /// <summary>
        /// The provider schedule charge type Repository.
        /// </summary>
        private IDapperRepository<ConsultationType> consultationTypeRepository;

        /// <summary>
        /// The provider schedule charge type Repository.
        /// </summary>
        private IDapperRepository<ProviderAvailability> providerAvailabilityRepository;

        /// <summary>
        /// The provider schedule charge type Repository.
        /// </summary>
        private IDapperRepository<ProviderAvailabilitySlot> providerAvailabilitySlotRepository;

        /// <summary>
        /// The provider schedule charge type Repository.
        /// </summary>
        private IDapperRepository<ProviderAvailabilityVisitType> providerAvailabilityVisitTypeRepository;

        /// <summary>
        /// The lab report verification repository
        /// </summary>
        private IDapperRepository<LabReportVerification> LabReportVerificationRepository;

        /// <summary>
        /// The ivf encounter
        /// </summary>
        private IDapperRepository<IvfEncounter> ivfEncounterRepository;

        /// <summary>
        /// The cubicle repository.
        /// </summary>
        private IDapperRepository<Cubicle> cubicleRepository;
        /// <summary>
        /// The working hour repository
        /// </summary>
        private IDapperRepository<WorkingHour> workingHour;

        /// <summary>
        /// The charge type Repository
        /// </summary>
        private IDapperRepository<EncounterType> encounterTypeRepository;

        /// <summary>
        /// The session type repository
        /// </summary>
        private IDapperRepository<SessionType> sessionTypeRepository;

        /// <summary>
        /// The session repository
        /// </summary>
        private IDapperRepository<Session> sessionRepository;

        /// <summary>
        /// The cubicle repository.
        /// </summary>
        private IDapperRepository<InformationLog> informationLogRepository;


        /// <summary>
        /// The location repository
        /// </summary>
        private IDapperRepository<PracticeLocation> practiceLocationRepository;
        /// <summary>
        /// The user excel history repository.
        /// </summary>
        private IDapperRepository<UserExcelHistory> userExcelHistoryRepository;

        /// <summary>
        /// Gets the appointment status.
        /// </summary>
        private IDapperRepository<PaymentInitiationLog> paymentInitiationLog;

        /// <summary>
        /// Gets the appointment status.
        /// </summary>
        private IDapperRepository<PaymentResponseLog> paymentResponseLog;

        /// <summary>
        /// The payment map helper
        /// </summary>
        private IDapperRepository<PaymentMapHelper> paymentMapHelper;

        /// <summary>
        /// Gets the patientChatBox status.
        /// </summary>
        private IDapperRepository<PatientChatBox> patientChatBox;
        /// <summary>
        /// The room charge repository
        /// </summary>
        private IDapperRepository<RoomCharge> roomChargeRepository;

        /// <summary>
        /// The charge module template repository.
        /// </summary>
        private IDapperRepository<ChargeModuleTemplate> chargeModuleTemplateRepository;

        /// <summary>
        /// The charge module category repository.
        /// </summary>
        private IDapperRepository<ChargeModuleCategory> chargeModuleCategoryRepository;

        /// <summary>
        /// The charge module details repository.
        /// </summary>
        private IDapperRepository<ChargeModuleDetails> chargeModuleDetailsRepository;

        /// <summary>
        /// The doctor specialization charge module category repository
        /// </summary>
        private IDapperRepository<DoctorSpecializationChargeModuleCategory> doctorSpecializationChargeModuleCategoryRepository;

        /// <summary>
        /// The doctor specialization charge module details repository
        /// </summary>
        private IDapperRepository<DoctorSpecializationChargeModuleDetails> doctorSpecializationChargeModuleDetailsRepository;


        private IDapperRepository<DoctorSpecializationMap> doctorSpecializationMapRepository;

        /// <summary>
        /// Gets the appointment status.
        /// </summary>
        private IDapperRepository<AppointmentCheckPoints> appointmentCheckPoints;
        // <summary>
        /// Gets the scan machine availability repository.
        /// </summary>

        private IDapperRepository<OTRoomAvailability> oTRoomAvailabilityRepository;
        ///<summary>
        /// Gets the scan machine availability repository.
        /// </summary>

        private IDapperRepository<OTRegister> oTRegisterepository;
        ///<summary>
        /// Gets the scan machine availability repository.
        /// </summary>

        private IDapperRepository<OTRoomSurgeryMap> otRoomSurgeryMapRepository;


        ///<summary>
        /// Gets the case type.
        /// </summary>

        private IDapperRepository<CaseType> caseTypes;

        /// <summary>
        /// The provider schedule charge type Repository.
        /// </summary>
        private IDapperRepository<ProviderBreak> providerBreakRepository;

        private IDapperRepository<PackageModule> packageModuleRepository;
        private IDapperRepository<PackageModuleDetail> packageModuleDetailRepository;
        private IDapperRepository<CounsellingDetail> counsellingDetailRepository;
        /// <summary>
        /// The user excel history repository.
        /// </summary>
        private IDapperRepository<PatientExcelHistory> patientsExcelHistoryRepository;
        /// <summary>
        /// The doctor unit master.
        /// </summary>
        private IDapperRepository<DoctorUnitMaster> doctorUnitMatserRepository;
        /// <summary>
        /// The tag doctor.
        /// </summary>
        private IDapperRepository<TagDoctor> tagDoctorRepository;

        /// <summary>
        /// The provider schedule charge type Repository.
        /// </summary>
        private IDapperRepository<DoctorAvailabilityVisitType> doctorAvailabilityVisitTypeRepository;
        /// <summary>
        /// The dynamic template config Repository.
        /// </summary>
        private IDapperRepository<DynamicTemplateConfig> dynamicTemplateConfigRepository;
        /// <summary>
        /// The dynamic template config Repository.
        /// </summary>
        private IDapperRepository<DynamicReportImages> dynamicReportImagesRepository;


        /// <summary>
        /// The health card Repository.
        /// </summary>
        private IDapperRepository<HealthCard> healthCardRepository;

        /// <summary>
        /// The issue health card Repository.
        /// </summary>
        private IDapperRepository<IssueHealthCard> issueHealthCardRepository;

        /// <summary>
        /// The issue health card member Repository.
        /// </summary>
        private IDapperRepository<HealthCardMember> healthCardMemberRepository;
        /// <summary>
        /// Ambulance repository
        /// </summary>
        private IDapperRepository<Ambulance> ambulanceReository;


        private IDapperRepository<DriverDetail> driverDetailReository;

        private IDapperRepository<AmbulanceReciept> ambulanceRecieptReository;

        private IDapperRepository<PediatricEncounter> pediatricEncounterReository;

        private IDapperRepository<NeonatalIPEncounter> neonatalIPEncounterReository;

        /// <summary>
        ///reason repository
        /// </summary>
        private IDapperRepository<Reasons> reasonsptReository;

        /// <summary>
        /// authority master repository
        /// </summary>
        private IDapperRepository<AuthorityMaster> authorityMasterptReository;

        /// <summary>
        /// The tendor status repository.
        /// </summary>
        private IDapperRepository<TendorStatus> tendorStatusRepository;

        /// <summary>
        /// The pharmacy product request repository.
        /// </summary>
        private IDapperRepository<PharmacyProductRequest> pharmacyProductRequestRepository;

        /// <summary>
        /// The anc card generation.
        /// </summary>
        private IDapperRepository<ANCCardGeneration> ancCardGnerationRepository;

        /// <summary>
        /// The template header repository.
        /// </summary>
        private IDapperRepository<TemplateHeader> templateHeaderRepository;

        /// <summary>
        /// The template detail repository.
        /// </summary>
        private IDapperRepository<TemplateDetail> templateDetailRepository;

        /// <summary>
        /// The med frequency master repository.
        /// </summary>
        private IDapperRepository<MedFrequencyMaster> medFrequencyMasterRepository;

        /// <summary>
        /// The vaccine group repository.
        /// </summary>
        private IDapperRepository<VaccineGroup> vaccineGroupRepository;

        /// <summary>
        /// The vaccine type repository.
        /// </summary>
        private IDapperRepository<VaccineType> vaccineTypeRepository;

        /// <summary>
        /// The vaccine master repository.
        /// </summary>
        private IDapperRepository<VaccineMaster> vaccineMasterRepository;

        /// <summary>
        /// The vaccine dependency repository
        /// </summary>
        private IDapperRepository<VaccineDependency> vaccineDependencyRepository;

        /// <summary>
        /// The gatePass repository.
        /// </summary>
        private IDapperRepository<GatePass> gatePassRepository;

        /// <summary>
        /// The icd values repository
        /// </summary>
        private IDapperRepository<ICDValues> icdValuesRepository;
        /// <summary>
        /// The anc card generation.
        /// </summary>
        private IDapperRepository<GYNCardGeneration> gynCardGnerationRepository;


        /// <summary>
        /// diet encounter
        /// </summary>
        private IDapperRepository<DietEncounter> dietEncounterRepository;

        /// <summary>
        /// The gatePass repository.
        /// </summary>
        private IDapperRepository<MasterBill> masterBillRepository;
        /// <summary>
        /// The diet guidlines repository.
        /// </summary>
        private IDapperRepository<DietGuidLines> dietGuidLinesRepository;


        /// <summary>
        /// The pediatric chart authority repository.
        /// </summary>
        private IDapperRepository<PediatricChartAuthority> pediatricChartAuthorityRepository;

        /// <summary>
        /// The pediatric chart type repository.
        /// </summary>
        private IDapperRepository<PediatricChartType> pediatricChartTypeRepository;

        /// <summary>
        /// The pediatric age wise data repository.
        /// </summary>
        private IDapperRepository<PediatricAgeWiseData> pediatricAgeWiseDataRepository;


        private IDapperRepository<Relations> relationsRepository;

        /// <summary>
        /// The diet plan repository.
        /// </summary>
        private IDapperRepository<DietPlan> dietPlanRepository;


        /// <summary>
        /// The pharmacy department indent header repository.
        /// </summary>
        private IDapperRepository<PharmacyDepartmentIndentHeader> pharmacyDepartmentIndentHeaderRepository;

        /// <summary>
        /// The pharmacy department indent detail repository.
        /// </summary>
        private IDapperRepository<PharmacyDepartmentIndentDetail> pharmacyDepartmentIndentDetailRepository;

        /// <summary>
        /// The general notification repository.
        /// </summary>
        private IDapperRepository<GeneralNotification> generalNotificationRepository;


        /// <summary>
        /// The pharmacy department issue header repository.
        /// </summary>
        private IDapperRepository<PharmacyDepartmentIssueHeader> pharmacyDepartmentIssueHeaderRepository;


        /// <summary>
        /// The pharmacy department issue detail repository.
        /// </summary>
        private IDapperRepository<PharmacyDepartmentIssueDetail> pharmacyDepartmentIssueDetailRepository;

        /// <summary>
        /// The charge type Repository
        /// </summary>
        private IDapperRepository<DoctorAppointmentNotice> doctorAppointmentNoticeRepository;

        /// <summary>
        /// The menu button reository
        /// </summary>
        private IDapperRepository<MenuButton> menuButtonReository;

        /// <summary>
        /// The menu button relationship reository.
        /// </summary>
        private IDapperRepository<MenuButtonRelationship> menuButtonRelationshipReository;


        /// <summary>
        /// The pharmacy product approval repository.
        /// </summary>
        private IDapperRepository<PharmacyProductApproval> pharmacyProductApprovalRepository;

        /// <summary>
        /// The scan appointment notice repository.
        /// </summary>
        private IDapperRepository<ScanAppointmentNotice> scanAppointmentNoticeRepository;

        /// <summary>
        /// The emergency encounter repository.
        /// </summary>
        private IDapperRepository<EmergencyEncounter> emergencyEncounterRepository;
        /// <summary>
        /// The charge type Repository
        /// </summary>
        private IDapperRepository<LabVacutainer> labVacutainerDetailRepository;

        /// <summary>
        /// The external lab agency repository
        /// </summary>
        private IDapperRepository<ExternalLabAgency> externalLabAgencyRepository;

        /// <summary>
        /// The external lab agency detail repository
        /// </summary>
        private IDapperRepository<ExternalLabAgencyDetail> externalLabAgencyDetailRepository;

        /// <summary>
        /// The external lab transfer repository
        /// </summary>
        private IDapperRepository<ExternalLabTransfer> externalLabTransferRepository;

        /// <summary>
        /// The ticket type repository
        /// </summary>
        private IDapperRepository<TicketType> ticketTypeRepository;

        /// <summary>
        /// The CPX rela ted to department repository
        /// </summary>
        private IDapperRepository<CpxRelatedToDepartment> cpxRelatedToDepartmentRepository;

        /// <summary>
        /// The request department repository
        /// </summary>
        private IDapperRepository<RequestDepartment> requestDepartmentRepository;

        /// <summary>
        /// The admission bed change request repository
        /// </summary>
        private IDapperRepository<AdmissionBedChangeRequest> admissionBedChangeRequestRepository;

        /// <summary>
        /// The master operating room repository
        /// </summary>
        private IDapperRepository<MasterOperatingRoom> masterOperatingRoomRepository;

        /// <summary>
        /// The emergency encounter repository.
        /// </summary>
        private IDapperRepository<DietSlots> dietSlotsRepository;

        /// <summary>
        /// The lab sample collection detail repository.
        /// </summary>
        private IDapperRepository<LabSampleCollectionDetail> labSampleCollectionDetailRepository;


        /// <summary>
        /// The diet items repository.
        /// </summary>
        private IDapperRepository<DietItems> dietItemsRepository;
        /// <summary>
        /// The diet items repository.
        /// </summary>
        private IDapperRepository<Denverchart> denverChartRepository;

        private IDapperRepository<DietConditionHeader> dietConditionHeaderRepository;
        private IDapperRepository<DietConditionDetail> dietConditionDetailRepository;

        /// <summary>
        /// The birth Certificate repository.
        /// </summary>
        private IDapperRepository<BirthCertificate> birthCertificateRepository;

        /// <summary>
        /// The nurse note repository.
        /// </summary>
        private IDapperRepository<NurseNote> nurseNoteRepository;

        /// <summary>
        /// The pharmacy product type repository.
        /// </summary>
        private IDapperRepository<PharmacyProductType> pharmacyProductTypeRepository;

        /// <summary>
        /// The pharmacy product sub type repository.
        /// </summary>
        private IDapperRepository<PharmacyProductSubType> pharmacyProductSubTypeRepository;
        /// <summary>
        /// The referral form.
        /// </summary>
        private IDapperRepository<ReferralForm> referralFormRepository;
        /// <summary>
        /// The referral form.
        /// </summary>
        private IDapperRepository<CommonEncounter> commonEncounterRepository;

        /// <summary>
        /// The patient scan document repository.
        /// </summary>
        private IDapperRepository<ScanDocument> scanDocumentRepository;

        /// <summary>
        /// The purchase order header repository.
        /// </summary>
        private IDapperRepository<PurchaseOrderHeader> purchaseOrderHeaderRepository;

        /// <summary>
        /// The purchase order detail repository.
        /// </summary>
        private IDapperRepository<PurchaseOrderDetail> purchaseOrderDetailRepository;
        /// <summary>
        /// The purchase order detail repository.
        /// </summary>
        private IDapperRepository<OrderPrescriptionMaster> orderPrescriptionMasterRepository;

        /// <summary>
        /// The product for quotation header repository.
        /// </summary>
        private IDapperRepository<ProductForQuotationHeader> productForQuotationHeaderRepository;

        /// <summary>
        /// The product for quotation detail repository.
        /// </summary>
        private IDapperRepository<ProductForQuotationDetail> productForQuotationDetailRepository;

        /// <summary>
        /// The vaccine pharma link header repository
        /// </summary>
        private IDapperRepository<VaccinePharmacyLinkHeader> vaccinePharmaLinkHeaderRepository;

        /// <summary>
        /// The vaccine pharma link detail repository
        /// </summary>
        private IDapperRepository<VaccinePharmacyLinkDetail> vaccinePharmaLinkDetailRepository;

        /// <summary>
        /// The immunization history repository.
        /// </summary>
        private IDapperRepository<ImmunizationHistory> immunizationHistoryRepository;

        /// <summary>
        /// The supplier product header repository
        /// </summary>
        private IDapperRepository<SupplierProductHeader> supplierProductHeaderRepository;

        /// <summary>
        /// The supplier product detail repository.
        /// </summary>
        private IDapperRepository<SupplierProductDetail> supplierProductDetailRepository;

        /// <summary>
        /// The supplier product formulation repository.
        /// </summary>
        private IDapperRepository<SupplierProductFormulation> supplierProductFormulationRepository;


        /// <summary>
        /// The supplier product formulation repository.
        /// </summary>
        private IDapperRepository<AdmissionTransferRequest> admissionTransferRequestRepository;

        /// <summary>
        /// The incoming quotation header repository
        /// </summary>
        private IDapperRepository<IncomingQuotationHeader> incomingQuotationHeaderRepository;

        /// <summary>
        /// The incoming quotation detail repository
        /// </summary>
        private IDapperRepository<IncomingQuotationDetail> incomingQuotationDetailRepository;

        /// <summary>
        /// The service order repository
        /// </summary>
        private IDapperRepository<SurgeryService> surgeryServiceRepository;



        /// <summary>
        /// The pharmacy in patient return repository.
        /// </summary>
        private IDapperRepository<PharmacyInPatientReturn> pharmacyInPatientReturnRepository;  

        /// <summary>
        /// The service order repository
        /// </summary>
        private IDapperRepository<ScanService> scanServiceRepository;
        /// <summary>
        /// The service order repository.
        /// </summary>
        private IDapperRepository<PackageDocument> packageDocumentRepository;

        /// <summary>
        /// The inventory product request repository.
        /// </summary>
        private IDapperRepository<InventoryProductRequest> inventoryProductRequestRepository;

        /// <summary>
        /// The inventory product request repository.
        /// </summary>
        private IDapperRepository<WhatsAppTickets> whatsAppTicketsRepository;
        /// <summary>
        /// The register repository.
        /// </summary>
        private IDapperRepository<Register> registerRepository;
        /// <summary>
        /// The  physiotherapy encounter repository.
        /// </summary>
        private IDapperRepository<PhysiotherapyEncounter> physiotherapyEncounterRepository;
        /// <summary>
        /// The ward Repository.
        /// </summary>
        private IDapperRepository<InsuranceTemplate> insuranceTemplateRepository;
        /// <summary>
        /// The genetic speciality encounter repository.
        /// </summary>
        private IDapperRepository<GeneticSpecialityEncounter> geneticSpecialityEncounterRepository;


        /// <summary>
        /// The encounter order template Repository.
        /// </summary>
        private IDapperRepository<EncounterOrderTemplates> encounterOrderTemplatesRepository;

        /// <summary>
        /// The encounter order template Repository.
        /// </summary>
        private IDapperRepository<EncountersLog> encountersLogRepository;
        /// <summary>
        /// Initializes a new instance of the <see cref="UnitOfWork"/> class.
        /// </summary>
        /// <param name="configuration">
        /// The configuration.
        /// </param>
        public UnitOfWork(IConfiguration configuration) => this.connection = new NpgsqlConnection(configuration.GetConnectionString("Connection"));

        /// <summary>
        /// The disposed.
        /// </summary>
        private bool disposed;


        /// <inheritdoc />
        ~UnitOfWork()
        {
            this.Dispose(false);
        }

        /// <inheritdoc />
        public virtual IDbConnection Current
        {
            get
            {
                this.OpenConnection();
                return this.connection;
            }
        }

        /// <inheritdoc />
        public IDapperRepository<Account> Accounts => this.accountRepository ??= new DapperRepository<Account>(this.Current, this.config);

        public IDapperRepository<Counselling> Counsellings => this.counsellingRepository ??= new DapperRepository<Counselling>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<NurseShiftMap> NurseShiftMap => this.nurseShiftMapRepository ??= new DapperRepository<NurseShiftMap>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<NurseShiftBedMap> NurseShiftBedMap => this.nurseShiftBedMapRepository ??= new DapperRepository<NurseShiftBedMap>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<AccountCredential> AccountCredentials => this.accountCredentialRepository ??= new DapperRepository<AccountCredential>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<AccountSession> AccountSessions => this.accountSessionRepository ??= new DapperRepository<AccountSession>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<User> Users => this.userRepository ??= new DapperRepository<User>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<AuditLog> AuditLogs => this.auditLogRepository ??= new DapperRepository<AuditLog>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<Appointment> Appointments => this.appointmentRepository ??= new DapperRepository<Appointment>(this.Current, this.config);
        /// <inheritdoc />
        public IDapperRepository<AppointmentSymptom> AppointmentSymptoms => this.appointmentSymptomRepository ??= new DapperRepository<AppointmentSymptom>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<AppointmentLog> AppointmentLogs => this.appointmentLogRepository ??= new DapperRepository<AppointmentLog>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<Admission> Admission => this.admissionRepository ??= new DapperRepository<Admission>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<AppointmentTransaction> AppointmentTransactions => this.appointmentTransactionsRepository ??= new DapperRepository<AppointmentTransaction>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<AppointmentExceptionLog> AppointmentExceptionLogs => this.appointmentExceptionLogsRepository ??= new DapperRepository<AppointmentExceptionLog>(this.Current, this.config);
        /// <inheritdoc />
        public IDapperRepository<AppointmentHangfireMap> AppointmentHangfireMaps => this.AppointmentHangfireMapsRepository ??= new DapperRepository<AppointmentHangfireMap>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<Country> Countries => this.countryRepository ??= new DapperRepository<Country>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<Coupon> Coupons => this.couponRepository ??= new DapperRepository<Coupon>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<Chat> Chats => this.chatRepository ??= new DapperRepository<Chat>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<InsuranceCompany> InsuranceCompanies => this.insuranceCompanyRepository ??= new DapperRepository<InsuranceCompany>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<Patient> Patients => this.patientRepository ??= new DapperRepository<Patient>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<PatientDocument> PatientDocuments => this.patientDocumentRepository ??= new DapperRepository<PatientDocument>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<PaymentDocument> PaymentDocuments => this.paymentDocumentRepository ??= new DapperRepository<PaymentDocument>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<PatientEmergency> PatientEmergencies => this.patientEmergencyRepository ??= new DapperRepository<PatientEmergency>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<PatientInsurance> PatientInsurances => this.patientInsuranceRepository ??= new DapperRepository<PatientInsurance>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<Practice> Practices => this.practiceRepository ??= new DapperRepository<Practice>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<Provider> Providers => this.providerRepository ??= new DapperRepository<Provider>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<ProviderEncounter> ProviderEncounters => this.providerEncounterRepository ??= new DapperRepository<ProviderEncounter>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<LabOrderValue> LabOrderValues => this.labOrderValueRepository ??= new DapperRepository<LabOrderValue>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<LabOrder> LabOrder => this.labOrderRepository ??= new DapperRepository<LabOrder>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<ProviderBankAccount> ProviderBankAccounts => this.providerBankAccountRepository ??= new DapperRepository<ProviderBankAccount>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<PatientConfiguration> PatientConfigurations => this.patientConfigurationRepository ??= new DapperRepository<PatientConfiguration>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<ProviderDocument> ProviderDocuments => this.providerDocumentRepository ??= new DapperRepository<ProviderDocument>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<ProviderLocation> ProviderLocations => this.providerLocationRepository ??= new DapperRepository<ProviderLocation>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<Role> Roles => this.roleRepository ??= new DapperRepository<Role>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<DischargeInstruction> DischargeInstructions => this.dischargeInstructionRepository ??= new DapperRepository<DischargeInstruction>(this.Current, this.config);


        /// <inheritdoc />
        public IDapperRepository<Ward> Wards => this.wardRepository ??= new DapperRepository<Ward>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<Department> Departments => this.departmentsRepository ??= new DapperRepository<Department>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<ChargeGroup> ChargeGroups => this.chargeGroupsRepository ??= new DapperRepository<ChargeGroup>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<Charge> Charges => this.chargeRepository ??= new DapperRepository<Charge>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<CallHistory> CallHistorys => this.CallHistoryRepository ??= new DapperRepository<CallHistory>(this.Current, this.config);
        
        public IDapperRepository<FeedbackDetails> Feedbackdetails => this.feedbackDetailsRepository ??= new DapperRepository<FeedbackDetails>(this.Current, this.config);
        /// <inheritdoc />
        public IDapperRepository<ContactDetails> contactDetailss => this.contactDetailsRepository ??= new DapperRepository<ContactDetails>(this.Current, this.config);
        /// <inheritdoc />
        public IDapperRepository<Bed> Beds => this.bedRepository ??= new DapperRepository<Bed>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<Room> Rooms => this.roomRepository ??= new DapperRepository<Room>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<SessionType> SessionTypes => this.sessionTypeRepository ??= new DapperRepository<SessionType>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<Session> Sessions => this.sessionRepository ??= new DapperRepository<Session>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<Service> Services => this.serviceRepository ??= new DapperRepository<Service>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<Specialization> Specializations => this.specializationRepository ??= new DapperRepository<Specialization>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<LookupValue> LookupValues => this.lookupValueRepository ??= new DapperRepository<LookupValue>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<RadiologyValue> RadiologyValues => this.radiologyValueRespository ??= new DapperRepository<RadiologyValue>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<Lookup> Lookups => this.lookupRepository ??= new DapperRepository<Lookup>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<Encounter> Encounters => this.encounterRepository ??= new DapperRepository<Encounter>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<VideoCallHistory> VideoCallHistories => this.videoCallHistoryRepository ??= new DapperRepository<VideoCallHistory>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<ICDCode> ICDCodes => this.icdCodeRepository ??= new DapperRepository<ICDCode>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<Radiology> Radiology => this.radiologyRepository ??= new DapperRepository<Radiology>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<CPTCode> CPTCodes => this.cptCodeRepository ??= new DapperRepository<CPTCode>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<ProviderLeave> ProviderLeaves => this.providerLeaveRepository ??= new DapperRepository<ProviderLeave>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<DoctorDeviceDetails> DoctorDeviceDetails => this.doctorDeviceHistoryRepository ??= new DapperRepository<DoctorDeviceDetails>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<PatientDeviceDetails> PatientDeviceDetails => this.patientDeviceHistoryRepository ??= new DapperRepository<PatientDeviceDetails>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<BehavioralHealth> BehavioralHealth => this.behavioralHealthRepository ??= new DapperRepository<BehavioralHealth>(this.Current, this.config);

        public IDapperRepository<Homeopathy> Homeopathy => this.homeopathyRepository ??= new DapperRepository<Homeopathy>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<Ticket> Tickets => this.ticketRepository ??= new DapperRepository<Ticket>(this.Current, this.config);

        public IDapperRepository<GeneralAdvice> GeneralAdvices => this.generalAdviceRepository ??= new DapperRepository<GeneralAdvice>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<WebTelemedicine> WebTelemedicine => this.webTelemedicineRepository ??= new DapperRepository<WebTelemedicine>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<SupportCategory> SupportCategory => this.supportCategoryRepository ??= new DapperRepository<SupportCategory>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<InsuranceApproval> InsuranceApproval => this.insuranceApprovalRepository ??= new DapperRepository<InsuranceApproval>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<TicketTimeline> TicketTimeline => this.ticketTimelineRepository ??= new DapperRepository<TicketTimeline>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<DentalEncounter> DentalEncounter => this.dentalEncounterRepository ??= new DapperRepository<DentalEncounter>(this.Current, this.config);

        public IDapperRepository<Refund> Refunds => this.refundRepository ??= new DapperRepository<Refund>(this.Current, this.config);
        public IDapperRepository<TelemedicineHistory> TelemedicineHistory => this.telemedicineHistoryRepository ??= new DapperRepository<TelemedicineHistory>(this.Current, this.config);
        public IDapperRepository<TelemedicineCallHistory> TelemedicineCallHistory => this.telemedicineCallHistoryRepository ??= new DapperRepository<TelemedicineCallHistory>(this.Current, this.config);
        public IDapperRepository<TelemedicineUsersHistory> TelemedicineUsersHistory => this.telemedicineUsersHistoryRepository ??= new DapperRepository<TelemedicineUsersHistory>(this.Current, this.config);
        public IDapperRepository<TelemedicineDomain> TelemedicineDomain => this.telemedicineDomainRepository ??= new DapperRepository<TelemedicineDomain>(this.Current, this.config);
        public IDapperRepository<TicketAssignee> TicketAssignees => this.ticketAssigneeRepository ??= new DapperRepository<TicketAssignee>(this.Current, this.config);
        /// <inheritdoc />
        public IDapperRepository<PaymentStatus> PaymentStatus => this.paymentStatusRepository ??= new DapperRepository<PaymentStatus>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<WebHook> WebHook => this.webHookRepository ??= new DapperRepository<WebHook>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<ProblemList> ProblemList => this.problemListRepository ??= new DapperRepository<ProblemList>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<Login> Login => this.loginRepository ??= new DapperRepository<Login>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<Timeline> Timeline => this.timelineRepository ??= new DapperRepository<Timeline>(this.Current, this.config);
        public IDapperRepository<TimelineData> TimelineData => this.timelineDataRepository ??= new DapperRepository<TimelineData>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<PatientFamily> PatientFamily => this.patientFamilyRepository ??= new DapperRepository<PatientFamily>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<Language> Languages => this.languageRepository ??= new DapperRepository<Language>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<Icons> Icons => this.iconsRepository ??= new DapperRepository<Icons>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<NotificationLog> NotificationLog => this.notificationLogRepository ??= new DapperRepository<NotificationLog>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<Wallet> Wallet => this.walletRepository ??= new DapperRepository<Wallet>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<Receipt> Receipt => this.receiptRepository ??= new DapperRepository<Receipt>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<ServiceOrder> ServiceOrder => this.serviceOrderRepository ??= new DapperRepository<ServiceOrder>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<LabServices> LabServices => this.labServicesRepository ??= new DapperRepository<LabServices>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<FinalBill> FinalBill => this.finalBillRepository ??= new DapperRepository<FinalBill>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<FinalBillServiceOrder> FinalBillServiceOrder => this.finalBillServiceOrderRepository ??= new DapperRepository<FinalBillServiceOrder>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<AppointmentSupportLog> AppointmentSupportLogRepository =>
            this.appointmentSupportLogRepository ??=
                new DapperRepository<AppointmentSupportLog>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<Message> Message => this.messageRepository ??= new DapperRepository<Message>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<Supplier> Supplier => this.supplierRepository ??= new DapperRepository<Supplier>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<Company> Company => this.companyRepository ??= new DapperRepository<Company>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<InventoryProduct> InventoryProducts => this.inventoryProductRepository ??= new DapperRepository<InventoryProduct>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<InventoryPurchaseHeader> InventoryPurchaseHeaders => this.inventoryPurchaseHeaderRepository ??= new DapperRepository<InventoryPurchaseHeader>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<InventoryStock> InventoryStocks => this.inventoryStockRepository ??= new DapperRepository<InventoryStock>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<InventoryPurchaseDetail> InventoryPurchaseDetails => this.inventoryPurchaseDetailRepository ??= new DapperRepository<InventoryPurchaseDetail>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<InventoryPurchaseReturnHeader> InventoryPurchaseReturnHeaders => this.inventoryPurchaseReturnHeaderRepository ??= new DapperRepository<InventoryPurchaseReturnHeader>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<InventoryPurchaseReturnDetail> InventoryPurchaseReturnDetails => this.inventoryPurchaseReturnDetailRepository ??= new DapperRepository<InventoryPurchaseReturnDetail>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<IndentHeader> IndentHeaders => this.indentHeaderRepository ??= new DapperRepository<IndentHeader>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<IndentDetail> IndentDetails => this.indentDetailRepository ??= new DapperRepository<IndentDetail>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<IssueHeader> IssueHeaders => this.isssueHeaderRepository ??= new DapperRepository<IssueHeader>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<IssueDetail> IssueDetails => this.isssueDetailRepository ??= new DapperRepository<IssueDetail>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<Discharge> Discharge => this.dischargeRepository ??= new DapperRepository<Discharge>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<Menu> Menu => this.menuRepository ??= new DapperRepository<Menu>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<MenuRelationship> MenuRelationship => this.menuRelationshipRepository ??= new DapperRepository<MenuRelationship>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<MenuAccess> MenuAccess => this.menuAccessRepository ??= new DapperRepository<MenuAccess>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<PharmacyProduct> PharmacyProducts => this.pharmacyProductRepository ??= new DapperRepository<PharmacyProduct>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<PharmacyPurchaseHeader> PharmacyPurchaseHeaders => this.pharmacyPurchaseHeaderRepository ??= new DapperRepository<PharmacyPurchaseHeader>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<PharmacyPurchaseDetail> PharmacyPurchaseDetails => this.pharmacyPurchaseDetailRepository ??= new DapperRepository<PharmacyPurchaseDetail>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<PharmacyStock> PharmacyStocks => this.pharmacyStockRepository ??= new DapperRepository<PharmacyStock>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<PharmacyRetailStock> PharmacyRetailStocks => this.pharmacyRetailStockRepository ??= new DapperRepository<PharmacyRetailStock>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<PharmacySaleHeader> PharmacySaleHeaders => this.pharmacySaleHeaderRepository ??= new DapperRepository<PharmacySaleHeader>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<PharmacySaleDetail> PharmacySaleDetails => this.pharmacySaleDetailRepository ??= new DapperRepository<PharmacySaleDetail>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<Feedback> Feedbacks => this.feedbacksRepository ??= new DapperRepository<Feedback>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<QuestionFeedback> QuestionFeedbacks => this.questionFeedbacksRepository ??= new DapperRepository<QuestionFeedback>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<PharmacyIndentHeader> PharmacyIndentHeaders => this.pharmacyIndentHeaderRepository ??= new DapperRepository<PharmacyIndentHeader>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<PharmacyIndentDetail> PharmacyIndentDetails => this.pharmacyIndentDetailRepository ??= new DapperRepository<PharmacyIndentDetail>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<SurgeryKitHeader> SurgeryKitHeaders => this.surgeryKitHeaderRepository ??= new DapperRepository<SurgeryKitHeader>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<SurgeryKitDetail> SurgeryKitDetails => this.surgeryKitDetailRepository ??= new DapperRepository<SurgeryKitDetail>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<PharmacyIssueHeader> PharmacyIssueHeaders => this.pharmacyIssueHeaderRepository ??= new DapperRepository<PharmacyIssueHeader>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<PharmacyIssueDetail> PharmacyIssueDetails => this.pharmacyIssueDetailRepository ??= new DapperRepository<PharmacyIssueDetail>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<SaleReturnHeader> SaleReturnHeaders => this.saleReturnHeaderRepository ??= new DapperRepository<SaleReturnHeader>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<SaleReturnDetail> SaleReturnDetails => this.saleReturnDetailRepository ??= new DapperRepository<SaleReturnDetail>(this.Current, this.config);
        public IDapperRepository<Package> Package => this.packageRepository ??= new DapperRepository<Package>(this.Current, this.config);
        public IDapperRepository<PackageCharge> PackageCharge => this.packageChargeRepository ??= new DapperRepository<PackageCharge>(this.Current, this.config);
        public IDapperRepository<AdmissionPackage> AdmissionPackage => this.admissionPackageRepository ??= new DapperRepository<AdmissionPackage>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<LabHeader> LabHeaders => this.labHeaderRepository ??= new DapperRepository<LabHeader>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<LabDetail> LabDetails => this.labDetailRepository ??= new DapperRepository<LabDetail>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<LabBookingHeader> LabBookingHeaders => this.labBookingHeaderRepository ??= new DapperRepository<LabBookingHeader>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<LabBookingDetail> LabBookingDetails => this.labBookingDetailRepository ??= new DapperRepository<LabBookingDetail>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<LabPatientParameter> LabPatientParameters => this.labPatientParameterRepository ??= new DapperRepository<LabPatientParameter>(this.Current, this.config);
        public IDapperRepository<ProgressReport> ProgressReport => this.progressReportRepository ??= new DapperRepository<ProgressReport>(this.Current, this.config);
        public IDapperRepository<ProgressReportMedication> ProgressReportMedication => this.progressReportMedicationRepository ??= new DapperRepository<ProgressReportMedication>(this.Current, this.config);
        public IDapperRepository<ProgressReportMedicationDaily> ProgressReportMedicationDaily => this.progressReportMedicationDailyRepository ??= new DapperRepository<ProgressReportMedicationDaily>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<PharmacyRetailToMain> PhamrmacyRetailToMains => this.pharmacyRetailToMainRepository ??= new DapperRepository<PharmacyRetailToMain>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<SMSLog> SMSLogs => this.smsLogRepository ??= new DapperRepository<SMSLog>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<PharmacyPurchaseReturnHeader> PharmacyPurchaseReturnHeaders => this.pharmacyPurchaseReturnHeaderRepository ??= new DapperRepository<PharmacyPurchaseReturnHeader>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<PharmacyPurchaseReturnDetail> PharmacyPurchaseReturnDetails => this.pharmacyPurchaseReturnDetailRepository ??= new DapperRepository<PharmacyPurchaseReturnDetail>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<LabPackage> LabPackages => this.labPackageRepository ??= new DapperRepository<LabPackage>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<LabPackageDetail> LabPackageDetails => this.labPackageDetailRepository ??= new DapperRepository<LabPackageDetail>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<LabBookingPackageDetail> LabBookingPackageDetails => this.labBookingPackageDetailRepository ??= new DapperRepository<LabBookingPackageDetail>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<PharmacyLog> PharmacyLogs => this.pharmacyLogRepository ??= new DapperRepository<PharmacyLog>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<InventoryLog> InventoryLogs => this.inventoryLogRepository ??= new DapperRepository<InventoryLog>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<LabLog> LabLogs => this.labLogRepository ??= new DapperRepository<LabLog>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<ScanLog> ScanLogs => this.scanLogRepository ??= new DapperRepository<ScanLog>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<ExcelUploadHistory> ExcelUploadHistory => this.excelUploadHistoryRepository ??= new DapperRepository<ExcelUploadHistory>(this.Current, this.config);


        /// <inheritdoc />
        public IDapperRepository<DashboardWidget> DashboardWidget => this.dashboardWidgetRepository ??= new DapperRepository<DashboardWidget>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<DynamicReport> DynamicReports => this.dynamicReportRepository ??= new DapperRepository<DynamicReport>(this.Current, this.config);
        /// <inheritdoc />

        /// <inheritdoc />
        public IDapperRepository<DashboardConfig> DashboardConfig => this.dashboardConfigRepository ??= new DapperRepository<DashboardConfig>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<DashboardWidgetRole> DashboardWidgetRole => this.dashboardWidgetRoleRepository ??= new DapperRepository<DashboardWidgetRole>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<DashboardConfigMaster> DashboardConfigMaster => this.dashboardConfigMasterRepository ??= new DapperRepository<DashboardConfigMaster>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<VisitType> Visitors => this.visitTypeRepository ??= new DapperRepository<VisitType>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<ChargeTypes> ChargeTypes => this.chargeTypesRepository ??= new DapperRepository<ChargeTypes>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<Floor> Floors => this.floorRepository ??= new DapperRepository<Floor>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<Tpa> Tpa => this.tpaRepository ??= new DapperRepository<Tpa>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<RetailPharmacy> RetailPharmacy => this.retailPharmacyRepository ??= new DapperRepository<RetailPharmacy>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<PrintSetting> PrintSetting => this.PrintSettingRepository ??= new DapperRepository<PrintSetting>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<CallLog> CallLog => this.callLogRepository ??= new DapperRepository<CallLog>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<TelemedicineTemplate> TelemedicineTemplate => this.telemedicineTemplateRepository ??= new DapperRepository<TelemedicineTemplate>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<TelemedicineTemplateHistory> TelemedicineTemplateHistory => this.telemedicineTemplateHistoryRepository ??= new DapperRepository<TelemedicineTemplateHistory>(this.Current, this.config);


        /// <inheritdoc />
        public IDapperRepository<Surgeons> Surgeons => this.surgeonsRepository ??= new DapperRepository<Surgeons>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<InsuranceForAdmission> InsuranceForAdmissions => this.isuranceForAdmissionRepository ??= new DapperRepository<InsuranceForAdmission>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<InsuranceTimeline> InsuranceTimelines => this.insuranceTimelineRepository ??= new DapperRepository<InsuranceTimeline>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<ShiftSlot> ShiftSlots => this.shiftSlotlotRepository ??= new DapperRepository<ShiftSlot>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<Shift> Shifts => this.shiftRepository ??= new DapperRepository<Shift>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<ShiftSlotMap> ShiftSlotMap => this.shiftSlotMapRepository ??= new DapperRepository<ShiftSlotMap>(this.Current, this.config);

        public IDapperRepository<ProgressReportMedicationFrequency> ProgressReportMedicationFrequency => this.progressReportMedicationFrequencyRepository ??= new DapperRepository<ProgressReportMedicationFrequency>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<ProgressReportNote> ProgressReportNote => this.progressReportNoteRepository ??= new DapperRepository<ProgressReportNote>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<FinalBillInsurance> FinalBillInsurance => this.finalBillInsuranceRepository ??= new DapperRepository<FinalBillInsurance>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<FontType> FontType => this.FontTypeRepository ??= new DapperRepository<FontType>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<VitalType> VitalType => this.vitalTypeRepository ??= new DapperRepository<VitalType>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<ProgressReportVitals> ProgressReportVitals => this.progressReportVitalsRepository ??= new DapperRepository<ProgressReportVitals>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<ProgressReportAssessments> ProgressReportAssessments => this.progressReportAssessmentsRepository ??= new DapperRepository<ProgressReportAssessments>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<UnitType> UnitType => this.unitTypeRepository ??= new DapperRepository<UnitType>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<DiscountModule> DiscountModules => this.discountModuleRepository ??= new DapperRepository<DiscountModule>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<DiscountsPerModule> DiscountsPerModules => this.discountsPerModuleRepository ??= new DapperRepository<DiscountsPerModule>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<AssessmentType> AssessmentType => this.assessmentTypeRepository ??= new DapperRepository<AssessmentType>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<SupplierProduct> SupplierProducts => this.supplierProductRepository ??= new DapperRepository<SupplierProduct>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<PatientTiming> PatientTiming => this.patientTimingRepository ??= new DapperRepository<PatientTiming>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<MedicationMove> MedicationMove => this.medicationMoveRepository ??= new DapperRepository<MedicationMove>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<OperationIndentHeader> OperationIndentHeaders => this.operationIndentHeaderRepository ??= new DapperRepository<OperationIndentHeader>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<OperationIndentDetail> OperationIndentDetails => this.operationIndentDetailRepository ??= new DapperRepository<OperationIndentDetail>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<OperationStock> OperationStocks => this.operationStockRepository ??= new DapperRepository<OperationStock>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<ProviderLocationOperation> ProviderLocationOperations => this.providerLocationOperationRepository ??= new DapperRepository<ProviderLocationOperation>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<Surgery> Surgerys => this.surgeryRepository ??= new DapperRepository<Surgery>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<SurgeryCharge> SurgeryCharges => this.surgeryChargeRepository ??= new DapperRepository<SurgeryCharge>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<OTRoom> OTRooms => this.otRoomRepository ??= new DapperRepository<OTRoom>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<DemandBook> DemandBooks => this.demandBookRepository ??= new DapperRepository<DemandBook>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<PharmacyRetailUser> PharmacyRetailUsers => this.pharmacyRetailUserRepository ??= new DapperRepository<PharmacyRetailUser>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<ModulesMaster> ModulesMasters => this.modulesMasterRepository ??= new DapperRepository<ModulesMaster>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<PatientReferredBy> ReferenceTypes => this.referenceTypeRepository ??= new DapperRepository<PatientReferredBy>(this.Current, this.config);


        /// <inheritdoc />
        public IDapperRepository<PharmacyStore> PharmacyStores => this.pharmacyStoreRepository ??= new DapperRepository<PharmacyStore>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<MealTypes> MealTypes => this.mealTypesRepository ??= new DapperRepository<MealTypes>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<PharmacyWareHouse> PharmacyWareHouses => this.pharmacyWareHouseRepository ??= new DapperRepository<PharmacyWareHouse>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<PharmacyWareHouseUser> PharmacyWareHouseUsers => this.pharmacyWareHouseUserRepository ??= new DapperRepository<PharmacyWareHouseUser>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<ProgressReportDiet> ProgressReportDiets => this.progressReportDietRepository ??= new DapperRepository<ProgressReportDiet>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<RetailWareHouseLink> RetailWareHouseLinks => this.retailWareHouseLinkRepository ??= new DapperRepository<RetailWareHouseLink>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<LocationAccountMap> LocationAccountMap => this.locationAccountMapRepository ??= new DapperRepository<LocationAccountMap>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<LocationDepartmentMap> LocationDepartmentMap => this.locationDepartmentMapRepository ??= new DapperRepository<LocationDepartmentMap>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<LocationPackageMap> LocationPackageMap => this.locationPackageMapRepository ??= new DapperRepository<LocationPackageMap>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<LocationMealTypesMap> LocationMealTypesMap => this.locationMealTypesMapRepository ??= new DapperRepository<LocationMealTypesMap>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<LocationLabPackageMap> LocationLabPackageMap => this.locationLabPackageMapRepository ??= new DapperRepository<LocationLabPackageMap>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<LocationLabHeaderMap> LocationLabHeaderMap => this.locationLabHeaderMapRepository ??= new DapperRepository<LocationLabHeaderMap>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<LocationFloorMap> LocationFloorMap => this.locationFloorMapRepository ??= new DapperRepository<LocationFloorMap>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<PayType> PayTypes => this.payTypeRepository ??= new DapperRepository<PayType>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<GynEncounter> GynEncounters => this.gynEncounterRepository ??= new DapperRepository<GynEncounter>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<EmployeeShift> EmployeeShifts => this.employeeShiftRepository ??= new DapperRepository<EmployeeShift>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<LeaveType> LeaveTypes => this.leaveTypeRepository ??= new DapperRepository<LeaveType>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<LocationSpecializationMap> LocationSpecializationMap => this.locationSpecializationMapRepository ??= new DapperRepository<LocationSpecializationMap>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<ObEncounter> ObEncounters => this.obEncounterRepository ??= new DapperRepository<ObEncounter>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<Location> Locations => this.locationRepository ??= new DapperRepository<Location>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<HWCPatient> HwcPatients => this.hwcPatientRepository ??= new DapperRepository<HWCPatient>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<PatientRegistrationCharge> PatientRegistrationCharges => this.patientRegistrationChargeRepository ??= new DapperRepository<PatientRegistrationCharge>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<ScanTestMaster> ScanTestMasters => this.scanTestMasterRepository ??= new DapperRepository<ScanTestMaster>(this.Current, this.config);
        /// <inheritdoc />
        public IDapperRepository<LocationScanTestMasterMap> LocationScanTestMasterMaps => this.locationScanTestMasterMapRepository ??= new DapperRepository<LocationScanTestMasterMap>(this.Current, this.config);
        /// <inheritdoc />
        public IDapperRepository<ScanMachineMaster> ScanMachineMasters => this.scanMachineMasterRepository ??= new DapperRepository<ScanMachineMaster>(this.Current, this.config);
        /// <inheritdoc />
        public IDapperRepository<ScanMachineTestMap> ScanMachineTestMaps => this.scanMachineTestMapRepository ??= new DapperRepository<ScanMachineTestMap>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<ChargeCategory> ChargeCategorys => this.chargeCategoryRepository ??= new DapperRepository<ChargeCategory>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<PatientRegistrationDetail> PatientRegistrationDetails => this.patientRegistrationDetailRepository ??= new DapperRepository<PatientRegistrationDetail>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<IdProof> IdProofs => this.idProofRepository ??= new DapperRepository<IdProof>(this.Current, this.config);


        /// <inheritdoc />
        public IDapperRepository<Machine> Machines => this.MachineRepository ??= new DapperRepository<Machine>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<LabDepartment> LabDepartments => this.labDepartmentRepository ??= new DapperRepository<LabDepartment>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<ScanMachineAvailability> ScanMachineAvailabilitys => this.scanMachineAvailabilityRepository ??= new DapperRepository<ScanMachineAvailability>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<PatientMedicationHeader> PatientMedicationHeaders => this.patientMedicationHeaderRepository ??= new DapperRepository<PatientMedicationHeader>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<PatientMedicationDetail> PatientMedicationDetails => this.patientMedicationDetailRepository ??= new DapperRepository<PatientMedicationDetail>(this.Current, this.config);

        /// <inheritdoc/>
        public IDapperRepository<WebNotification> WebNotifications => this.webNotificationRepository ??= new DapperRepository<WebNotification>(this.Current, this.config);

        /// <inheritdoc/>
        public IDapperRepository<BookScanAppointment> BookScanAppointments => this.bookScanAppointmentRepository ??= new DapperRepository<BookScanAppointment>(this.Current, this.config);

        /// <inheritdoc/>
        public IDapperRepository<PatientLabHeader> PatientLabHeaders => this.patientLabHeaderRepository ??= new DapperRepository<PatientLabHeader>(this.Current, this.config);

        /// <inheritdoc/>
        public IDapperRepository<PatientLabDetail> PatientLabDetails => this.patientLabDetailRepository ??= new DapperRepository<PatientLabDetail>(this.Current, this.config);

        /// <inheritdoc/>
        public IDapperRepository<PharmacyDepartment> PharmacyDepartments => this.pharmacyDepartmentRepository ??= new DapperRepository<PharmacyDepartment>(this.Current, this.config);

        /// <inheritdoc/>
        public IDapperRepository<PharmacyDepartmentUser> PharmacyDepartmentUsers => this.pharmacyDepartmentUserRepository ??= new DapperRepository<PharmacyDepartmentUser>(this.Current, this.config);

        /// <inheritdoc/>
        public IDapperRepository<PharmacyProductRack> PharmacyProductRacks => this.pharmacyProductRackRepository ??= new DapperRepository<PharmacyProductRack>(this.Current, this.config);

        /// <inheritdoc/>
        public IDapperRepository<PharmacyProductDetail> PharmacyProductDetails => this.pharmacyProductDetailRepository ??= new DapperRepository<PharmacyProductDetail>(this.Current, this.config);

        /// <inheritdoc/>
        public IDapperRepository<PharmacyDepartmentalStock> PharmacyDepartmentalStocks => this.pharmacyDepartmentalStockRepository ??= new DapperRepository<PharmacyDepartmentalStock>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<ScanClassification> ScanClassifications => this.scanClassificationRepository ??= new DapperRepository<ScanClassification>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<ScanSubClassification> ScanSubClassifications => this.scanSubClassificationRepository ??= new DapperRepository<ScanSubClassification>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<DepartmentConsumption> DepartmentConsumptions => this.departmentConsumptionRepository ??= new DapperRepository<DepartmentConsumption>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<PharmacyIssuedStockHeader> PharmacyIssuedStockHeaders => this.pharmacyIssuedStockHeaderRepository ??= new DapperRepository<PharmacyIssuedStockHeader>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<PharmacyIssuedStockDetail> PharmacyIssuedStockDetails => this.pharmacyIssuedStockDetailRepository ??= new DapperRepository<PharmacyIssuedStockDetail>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<InventoryWareHouse> InventoryWareHouses => this.inventoryWareHouseRepository ??= new DapperRepository<InventoryWareHouse>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<InventoryWareHouseUser> InventoryWareHouseUsers => this.inventoryWareHouseUserRepository ??= new DapperRepository<InventoryWareHouseUser>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<InventoryDepartment> InventoryDepartments => this.inventoryDepartmentRepository ??= new DapperRepository<InventoryDepartment>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<InventoryDepartmentUser> InventoryDepartmentUsers => this.inventoryDepartmentUserRepository ??= new DapperRepository<InventoryDepartmentUser>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<InventoryDepartmentalStock> InventoryDepartmentalStocks => this.inventoryDepartmentalStockRepository ??= new DapperRepository<InventoryDepartmentalStock>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<ProviderConsultationRoom> ProviderConsultationRooms => this.providerConsultationRoomRepository ??= new DapperRepository<ProviderConsultationRoom>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<InventoryIssuedStockHeader> InventoryIssuedStockHeaders => this.inventoryIssuedStockHeaderRepository ??= new DapperRepository<InventoryIssuedStockHeader>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<InventoryIssuedStockDetail> InventoryIssuedStockDetails => this.inventoryIssuedStockDetailRepository ??= new DapperRepository<InventoryIssuedStockDetail>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<InventoryProductDetail> InventoryProductDetails => this.inventoryProductDetailRepository ??= new DapperRepository<InventoryProductDetail>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<InventoryProductRack> InventoryProductRacks => this.inventoryProductRackRepository ??= new DapperRepository<InventoryProductRack>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<InventoryDepartmentConsumption> InventoryDepartmentConsumptions => this.inventoryDepartmentConsumptionRepository ??= new DapperRepository<InventoryDepartmentConsumption>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<ProviderMedicationGroup> ProviderMedicationGroups => this.providerMedicationGroupRepository ??= new DapperRepository<ProviderMedicationGroup>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<ProviderMedicationMaster> ProviderMedicationMasters => this.providerMedicationMasterRepository ??= new DapperRepository<ProviderMedicationMaster>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<ProviderMedicationMap> ProviderMedicationMaps => this.providerMedicationMapRepository ??= new DapperRepository<ProviderMedicationMap>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<OrderPrescriptionValue> OrderPrescriptionValues => this.orderPrescriptionValueRepository ??= new DapperRepository<OrderPrescriptionValue>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<LabParameterHeader> LabParameterHeaders => this.labParameterHeaderRepository ??= new DapperRepository<LabParameterHeader>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<LabParameterDetail> LabParameterDetails => this.labParameterDetailRepository ??= new DapperRepository<LabParameterDetail>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<LabComponentDetail> LabComponentDetails => this.labComponentDetailRepository ??= new DapperRepository<LabComponentDetail>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<LabComponentHeader> LabComponentHeaders => this.labComponentHeaderRepository ??= new DapperRepository<LabComponentHeader>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<LabTemplateHeader> LabTemplateHeaders => this.labTemplateHeaderRepository ??= new DapperRepository<LabTemplateHeader>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<LabTemplateDetail> LabTemplateDetails => this.labTemplateDetailRepository ??= new DapperRepository<LabTemplateDetail>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<AppointmentType> AppointmentTypes => this.appointmentTypesRepository ??= new DapperRepository<AppointmentType>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<LabParameterMethod> LabParameterMethods => this.labParameterMethodRepository ??= new DapperRepository<LabParameterMethod>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<LabSampleType> LabSampleTypes => this.labSampleTypeRepository ??= new DapperRepository<LabSampleType>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<LabMainDetail> LabMainDetails => this.labMainDetailRepository ??= new DapperRepository<LabMainDetail>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<LabMainDetailTemplate> LabMainDetailTemplates => this.labMainDetailTemplateRepository ??= new DapperRepository<LabMainDetailTemplate>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<LabBookingStatus> LabBookingStatus => this.labBookingStatusRepository ??= new DapperRepository<LabBookingStatus>(this.Current, this.config);
        /// <inheritdoc />
        public IDapperRepository<NewLabBookingHeader> NewLabBookingHeaders => this.newLabBookingHeaderRepository ??= new DapperRepository<NewLabBookingHeader>(this.Current, this.config);
        ///<inheritdoc />
        public IDapperRepository<NewLabCancelBookingHeader> NewLabCancelBookingHeaders => this.newLabCancelBookingHeaderRepository ??= new DapperRepository<NewLabCancelBookingHeader>(this.Current, this.config);


        /// <inheritdoc />
        public IDapperRepository<NewLabBookingDetail> NewLabBookingDetails => this.newLabBookingDetailRepository ??= new DapperRepository<NewLabBookingDetail>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<NewLabCancelBookingDetail> NewLabCancelBookingDetails => this.newLabCancelBookingDetailRepository ??= new DapperRepository<NewLabCancelBookingDetail>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<LabBookingTimeLine> LabBookingTimeLines => this.labBookingTimeLineRepository ??= new DapperRepository<LabBookingTimeLine>(this.Current, this.config);

        ///<inheritdoc/>
        public IDapperRepository<DynamicTemplate> DynamicTemplates => this.dynamicTemplateRepository ??= new DapperRepository<DynamicTemplate>(this.Current, this.config);

        ///<inheritdoc/>
        public IDapperRepository<LabSampleCollection> LabSampleCollections => this.labSampleCollectionRepository ??= new DapperRepository<LabSampleCollection>(this.Current, this.config);

        ///<inheritdoc/>
        public IDapperRepository<PayCategory> PayCategorys => this.payCategoryRepository ??= new DapperRepository<PayCategory>(this.Current, this.config);


        ///<inheritdoc/>
        public IDapperRepository<Salutation> Salutations => this.salutationRepository ??= new DapperRepository<Salutation>(this.Current, this.config);

        ///<inheritdoc/>
        public IDapperRepository<LabTransferHeader> LabTransferHeaders => this.labTransferHeaderRepository ??= new DapperRepository<LabTransferHeader>(this.Current, this.config);

        ///<inheritdoc/>
        public IDapperRepository<LabTransferDetail> LabTransferDetails => this.labTransferDetailRepository ??= new DapperRepository<LabTransferDetail>(this.Current, this.config);

        ///<inheritdoc/>
        public IDapperRepository<ComponentType> ComponentTypes => this.componentTypeRepository ??= new DapperRepository<ComponentType>(this.Current, this.config);

        ///<inheritdoc/>
        public IDapperRepository<Component> Components => this.componentRepository ??= new DapperRepository<Component>(this.Current, this.config);

        ///<inheritdoc/>
        public IDapperRepository<Template> Templates => this.templateRepository ??= new DapperRepository<Template>(this.Current, this.config);

        ///<inheritdoc/>
        public IDapperRepository<LabParameterObservedValue> LabParameterObservedValues => this.labParameterObservedValueRepository ??= new DapperRepository<LabParameterObservedValue>(this.Current, this.config);

        ///<inheritdoc/>
        public IDapperRepository<LabTemplateObservedValue> LabTemplateObservedValues => this.labTemplateObservedValueRepository ??= new DapperRepository<LabTemplateObservedValue>(this.Current, this.config);

        ///<inheritdoc/>
        public IDapperRepository<Settings> Settings => this.settingsRepository ??= new DapperRepository<Settings>(this.Current, this.config);

        ///<inheritdoc/>
        public IDapperRepository<ReferralDoctor> ReferralDoctor => this.refferalDoctorpository ??= new DapperRepository<ReferralDoctor>(this.Current, this.config);

        public IDapperRepository<PatientTransaction> PatientTransaction => this.patientTransactionRepository ??= new DapperRepository<PatientTransaction>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<ProviderScheduleCharge> ProviderScheduleCharges => this.providerScheduleChargesRepository ??= new DapperRepository<ProviderScheduleCharge>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<ConsultationType> ConsultationType => this.consultationTypeRepository ??= new DapperRepository<ConsultationType>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<ProviderAvailability> ProviderAvailability => this.providerAvailabilityRepository ??= new DapperRepository<ProviderAvailability>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<ProviderAvailabilitySlot> ProviderAvailabilitySlot => this.providerAvailabilitySlotRepository ??= new DapperRepository<ProviderAvailabilitySlot>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<ProviderAvailabilityVisitType> ProviderAvailabilityVisitType => this.providerAvailabilityVisitTypeRepository ??= new DapperRepository<ProviderAvailabilityVisitType>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<ProviderAvailabilityChargeType> ProviderAvailabilityChargeType => this.providerAvailabilityChargeTypeRepository ??= new DapperRepository<ProviderAvailabilityChargeType>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<PracticeLocation> PracticeLocations => this.practiceLocationRepository ??= new DapperRepository<PracticeLocation>(this.Current, this.config);

        /// <summary>
        /// Gets the lab report verification.
        /// </summary>
        /// <value>
        /// The lab report verification.
        /// </value>
        public IDapperRepository<LabReportVerification> LabReportVerifications => this.LabReportVerificationRepository ??= new DapperRepository<LabReportVerification>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<IvfEncounter> IvfEncounters => this.ivfEncounterRepository ??= new DapperRepository<IvfEncounter>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<Cubicle> Cubicle => this.cubicleRepository ??= new DapperRepository<Cubicle>(this.Current, this.config);
        public IDapperRepository<InformationLog> InformationLog => this.informationLogRepository ??= new DapperRepository<InformationLog>(this.Current, this.config);

        /// <inheritdoc/>
        public IDapperRepository<WorkingHour> WorkingHour => this.workingHour ??= new DapperRepository<WorkingHour>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<EncounterType> EncounterType => this.encounterTypeRepository ??= new DapperRepository<EncounterType>(this.Current, this.config);

        /// <inheritdoc />

        public IDapperRepository<UserExcelHistory> UserExcelHistory => this.userExcelHistoryRepository ??= new DapperRepository<UserExcelHistory>(this.Current, this.config);

        /// <inheritdoc/>
        public IDapperRepository<PaymentInitiationLog> PaymentInitiationLog => this.paymentInitiationLog ??= new DapperRepository<PaymentInitiationLog>(this.Current, this.config);

        /// <inheritdoc/>
        public IDapperRepository<PaymentResponseLog> PaymentResponseLog => this.paymentResponseLog ??= new DapperRepository<PaymentResponseLog>(this.Current, this.config);

        /// <inheritdoc/>
        public IDapperRepository<PaymentMapHelper> PaymentMapHelper => this.paymentMapHelper ??= new DapperRepository<PaymentMapHelper>(this.Current, this.config);

        /// <inheritdoc/>
        public IDapperRepository<PatientChatBox> PatientChatBoxes => this.patientChatBox ??= new DapperRepository<PatientChatBox>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<RoomCharge> RoomCharges => this.roomChargeRepository ??= new DapperRepository<RoomCharge>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<ChargeModuleTemplate> ChargeModuleTemplates => this.chargeModuleTemplateRepository ??= new DapperRepository<ChargeModuleTemplate>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<ChargeModuleCategory> ChargeModuleCategorys => this.chargeModuleCategoryRepository ??= new DapperRepository<ChargeModuleCategory>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<ChargeModuleDetails> ChargeModuleDetails => this.chargeModuleDetailsRepository ??= new DapperRepository<ChargeModuleDetails>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<DoctorSpecializationChargeModuleCategory> DoctorSpecializationChargeModuleCategorys => this.doctorSpecializationChargeModuleCategoryRepository ??= new DapperRepository<DoctorSpecializationChargeModuleCategory>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<DoctorSpecializationChargeModuleDetails> DoctorSpecializationChargeModuleDetails => this.doctorSpecializationChargeModuleDetailsRepository ??= new DapperRepository<DoctorSpecializationChargeModuleDetails>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<DoctorSpecializationMap> DoctorSpecializationMaps => this.doctorSpecializationMapRepository ??= new DapperRepository<DoctorSpecializationMap>(this.Current, this.config);

        /// <inheritdoc/>
        public IDapperRepository<AppointmentCheckPoints> AppointmentCheckPoints => this.appointmentCheckPoints ??= new DapperRepository<AppointmentCheckPoints>(this.Current, this.config);
        /// <inheritdoc />
        public IDapperRepository<OTRoomAvailability> OTRoomAvailabilitys => this.oTRoomAvailabilityRepository ??= new DapperRepository<OTRoomAvailability>(this.Current, this.config);
        /// <inheritdoc />
        public IDapperRepository<OTRegister> OTRegisters => this.oTRegisterepository ??= new DapperRepository<OTRegister>(this.Current, this.config);

        //  public IDapperRepository<OTRoomSurgeryMap> OTRoomSurgeryMaps { get; } => this.otRoomSurgeryMapRepository ??= new DapperRepository<OTRoomSurgeryMap>(this.Current, this.config);
        public IDapperRepository<OTRoomSurgeryMap> OTRoomSurgeryMaps => this.otRoomSurgeryMapRepository ??= new DapperRepository<OTRoomSurgeryMap>(this.Current, this.config);

        public IDapperRepository<CaseType> CaseTypes => this.caseTypes ??= new DapperRepository<CaseType>(this.Current, this.config);

        public IDapperRepository<ProviderBreak> ProviderBreak => this.providerBreakRepository ??= new DapperRepository<ProviderBreak>(this.Current, this.config);

        public IDapperRepository<PackageModule> PackageModules => this.packageModuleRepository ??= new DapperRepository<PackageModule>(this.Current, this.config);
        public IDapperRepository<PackageModuleDetail> PackageModuleDetails => this.packageModuleDetailRepository ??= new DapperRepository<PackageModuleDetail>(this.Current, this.config);
        public IDapperRepository<CounsellingDetail> CounsellingDetails => this.counsellingDetailRepository ??= new DapperRepository<CounsellingDetail>(this.Current, this.config);

        public IDapperRepository<PatientExcelHistory> PatientsExcelHistory => this.patientsExcelHistoryRepository ??= new DapperRepository<PatientExcelHistory>(this.Current, this.config);
        /// <inheritdoc />
        public IDapperRepository<DoctorUnitMaster> DoctorUnitMatser => this.doctorUnitMatserRepository ??= new DapperRepository<DoctorUnitMaster>(this.Current, this.config);
        /// <inheritdoc />
        public IDapperRepository<TagDoctor> TagDoctor => this.tagDoctorRepository ??= new DapperRepository<TagDoctor>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<DoctorAvailabilityVisitType> DoctorAvailabilityVisitType => this.doctorAvailabilityVisitTypeRepository ??= new DapperRepository<DoctorAvailabilityVisitType>(this.Current, this.config);

        public IDapperRepository<DynamicTemplateConfig> DynamicTemplateConfig => this.dynamicTemplateConfigRepository ??= new DapperRepository<DynamicTemplateConfig>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<HealthCard> HealthCards => this.healthCardRepository ??= new DapperRepository<HealthCard>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<IssueHealthCard> IssueHealthCards => this.issueHealthCardRepository ??= new DapperRepository<IssueHealthCard>(this.Current, this.config);
        /// <inheritdoc />
        public IDapperRepository<HealthCardMember> HealthCardMembers => this.healthCardMemberRepository ??= new DapperRepository<HealthCardMember>(this.Current, this.config);

        public IDapperRepository<DynamicReportImages> DynamicReportImages => this.dynamicReportImagesRepository ??= new DapperRepository<DynamicReportImages>(this.Current, this.config);

        public IDapperRepository<Ambulance> Ambulance => this.ambulanceReository ??= new DapperRepository<Ambulance>(this.Current, this.config);

        public IDapperRepository<DriverDetail> DriverDetail => this.driverDetailReository ??= new DapperRepository<DriverDetail>(this.Current, this.config);

        public IDapperRepository<AmbulanceReciept> AmbulanceReciept => this.ambulanceRecieptReository ??= new DapperRepository<AmbulanceReciept>(this.Current, this.config);

        public IDapperRepository<PediatricEncounter> PediatricEncounters => this.pediatricEncounterReository ??= new DapperRepository<PediatricEncounter>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<Reasons> Reasons => this.reasonsptReository ??= new DapperRepository<Reasons>(this.Current, this.config);
        /// <inheritdoc />
        public IDapperRepository<AuthorityMaster> AuthorityMaster => this.authorityMasterptReository ??= new DapperRepository<AuthorityMaster>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<TendorStatus> TendorStatus => this.tendorStatusRepository ??= new DapperRepository<TendorStatus>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<PharmacyProductRequest> PharmacyProductRequests => this.pharmacyProductRequestRepository ??= new DapperRepository<PharmacyProductRequest>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<ANCCardGeneration> ANCCardGeneration => this.ancCardGnerationRepository ??= new DapperRepository<ANCCardGeneration>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<GYNCardGeneration> GYNCardGeneration => this.gynCardGnerationRepository ??= new DapperRepository<GYNCardGeneration>(this.Current, this.config);


        /// <inheritdoc />
        public IDapperRepository<TemplateHeader> TemplateHeaders => this.templateHeaderRepository ??= new DapperRepository<TemplateHeader>(this.Current, this.config);


        /// <inheritdoc />
        public IDapperRepository<TemplateDetail> TemplateDetails => this.templateDetailRepository ??= new DapperRepository<TemplateDetail>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<MedFrequencyMaster> MedFrequencyMasters => this.medFrequencyMasterRepository ??= new DapperRepository<MedFrequencyMaster>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<VaccineGroup> VaccineGroups => this.vaccineGroupRepository ??= new DapperRepository<VaccineGroup>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<VaccineType> VaccineTypes => this.vaccineTypeRepository ??= new DapperRepository<VaccineType>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<VaccineMaster> VaccineMasters => this.vaccineMasterRepository ??= new DapperRepository<VaccineMaster>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<VaccineDependency> VaccineDependencys => this.vaccineDependencyRepository ??= new DapperRepository<VaccineDependency>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<GatePass> GatePass => this.gatePassRepository ??= new DapperRepository<GatePass>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<ICDValues> ICDValues => this.icdValuesRepository ??= new DapperRepository<ICDValues>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<MasterBill> MasterBill => this.masterBillRepository ??= new DapperRepository<MasterBill>(this.Current, this.config);
        // <inheritdoc />
        public IDapperRepository<Relations> Relations => this.relationsRepository ??= new DapperRepository<Relations>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<DietEncounter> DietEncounter => this.dietEncounterRepository ??= new DapperRepository<DietEncounter>(this.Current, this.config);
        /// <inheritdoc />
        public IDapperRepository<DietGuidLines> DietGuidLines => this.dietGuidLinesRepository ??= new DapperRepository<DietGuidLines>(this.Current, this.config);


        /// <inheritdoc />
        public IDapperRepository<PediatricChartAuthority> PediatricChartAuthoritys => this.pediatricChartAuthorityRepository ??= new DapperRepository<PediatricChartAuthority>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<PediatricChartType> PediatricChartTypes => this.pediatricChartTypeRepository ??= new DapperRepository<PediatricChartType>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<PediatricAgeWiseData> PediatricAgeWiseDatas => this.pediatricAgeWiseDataRepository ??= new DapperRepository<PediatricAgeWiseData>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<DietPlan> DietPlanes => this.dietPlanRepository ??= new DapperRepository<DietPlan>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<PharmacyDepartmentIndentHeader> PharmacyDepartmentIndentHeaders => this.pharmacyDepartmentIndentHeaderRepository ??= new DapperRepository<PharmacyDepartmentIndentHeader>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<PharmacyDepartmentIndentDetail> PharmacyDepartmentIndentDetails => this.pharmacyDepartmentIndentDetailRepository ??= new DapperRepository<PharmacyDepartmentIndentDetail>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<GeneralNotification> GeneralNotifications => this.generalNotificationRepository ??= new DapperRepository<GeneralNotification>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<PharmacyDepartmentIssueHeader> PharmacyDepartmentIssueHeaders => this.pharmacyDepartmentIssueHeaderRepository ??= new DapperRepository<PharmacyDepartmentIssueHeader>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<PharmacyDepartmentIssueDetail> PharmacyDepartmentIssueDetails => this.pharmacyDepartmentIssueDetailRepository ??= new DapperRepository<PharmacyDepartmentIssueDetail>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<DoctorAppointmentNotice> DoctorAppointmentNotices => this.doctorAppointmentNoticeRepository ??= new DapperRepository<DoctorAppointmentNotice>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<PharmacyProductApproval> PharmacyProductApprovals => this.pharmacyProductApprovalRepository ??= new DapperRepository<PharmacyProductApproval>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<ScanAppointmentNotice> ScanAppointmentNotices => this.scanAppointmentNoticeRepository ??= new DapperRepository<ScanAppointmentNotice>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<MenuButton> MenuButton => this.menuButtonReository ??= new DapperRepository<MenuButton>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<MenuButtonRelationship> MenuButtonRelationship => this.menuButtonRelationshipReository ??= new DapperRepository<MenuButtonRelationship>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<LabVacutainer> LabVacutainerDetails => this.labVacutainerDetailRepository ??= new DapperRepository<LabVacutainer>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<ExternalLabAgency> ExternalLabAgency => this.externalLabAgencyRepository ??= new DapperRepository<ExternalLabAgency>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<ExternalLabAgencyDetail> ExternalLabAgencyDetails => this.externalLabAgencyDetailRepository ??= new DapperRepository<ExternalLabAgencyDetail>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<ExternalLabTransfer> ExternalLabTransfer => this.externalLabTransferRepository ??= new DapperRepository<ExternalLabTransfer>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<TicketType> TicketTypes => this.ticketTypeRepository ??= new DapperRepository<TicketType>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<CpxRelatedToDepartment> CpxRelatedToDepartments => this.cpxRelatedToDepartmentRepository ??= new DapperRepository<CpxRelatedToDepartment>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<RequestDepartment> RequestDepartments => this.requestDepartmentRepository ??= new DapperRepository<RequestDepartment>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<AdmissionBedChangeRequest> AdmissionBedChangeRequests => this.admissionBedChangeRequestRepository ??= new DapperRepository<AdmissionBedChangeRequest>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<MasterOperatingRoom> MasterOperatingRooms => this.masterOperatingRoomRepository ??= new DapperRepository<MasterOperatingRoom>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<EmergencyEncounter> EmergencyEncounter => this.emergencyEncounterRepository ??= new DapperRepository<EmergencyEncounter>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<DietSlots> DietSlots => this.dietSlotsRepository ??= new DapperRepository<DietSlots>(this.Current, this.config);

        public IDapperRepository<LabSampleCollectionDetail> LabSampleCollectionDetails => this.labSampleCollectionDetailRepository ??= new DapperRepository<LabSampleCollectionDetail>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<DietItems> DietItems => this.dietItemsRepository ??= new DapperRepository<DietItems>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<Denverchart> Denvercharts => this.denverChartRepository ??= new DapperRepository<Denverchart>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<BirthCertificate> BirthCertificates => this.birthCertificateRepository ??= new DapperRepository<BirthCertificate>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<DietConditionHeader> DietConditionHeader => this.dietConditionHeaderRepository ??= new DapperRepository<DietConditionHeader>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<NurseNote> NurseNote => this.nurseNoteRepository ??= new DapperRepository<NurseNote>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<PharmacyProductType> PharmacyProductTypes => this.pharmacyProductTypeRepository ??= new DapperRepository<PharmacyProductType>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<PharmacyProductSubType> PharmacyProductSubTypes => this.pharmacyProductSubTypeRepository ??= new DapperRepository<PharmacyProductSubType>(this.Current, this.config);
        /// <inheritdoc />
        public IDapperRepository<ReferralForm> ReferralForms => this.referralFormRepository ??= new DapperRepository<ReferralForm>(this.Current, this.config);

        public IDapperRepository<CommonEncounter> CommonEncounters => this.commonEncounterRepository ??= new DapperRepository<CommonEncounter>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<PurchaseOrderHeader> PurchaseOrderHeaders => this.purchaseOrderHeaderRepository ??= new DapperRepository<PurchaseOrderHeader>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<PurchaseOrderDetail> PurchaseOrderDetails => this.purchaseOrderDetailRepository ??= new DapperRepository<PurchaseOrderDetail>(this.Current, this.config);

        public IDapperRepository<DietConditionDetail> DietConditionDetail => this.dietConditionDetailRepository ??= new DapperRepository<DietConditionDetail>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<ScanDocument> ScanDocuments => this.scanDocumentRepository ??= new DapperRepository<ScanDocument>(this.Current, this.config);
        /// <inheritdoc />
        public IDapperRepository<OrderPrescriptionMaster> OrderPrescriptionMasters => this.orderPrescriptionMasterRepository ??= new DapperRepository<OrderPrescriptionMaster>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<ProductForQuotationHeader> ProductForQuotationHeaders => this.productForQuotationHeaderRepository ??= new DapperRepository<ProductForQuotationHeader>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<ProductForQuotationDetail> ProductForQuotationDetails => this.productForQuotationDetailRepository ??= new DapperRepository<ProductForQuotationDetail>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<VaccinePharmacyLinkHeader> VaccinePharmacyLinkHeaders => this.vaccinePharmaLinkHeaderRepository ??= new DapperRepository<VaccinePharmacyLinkHeader>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<VaccinePharmacyLinkDetail> VaccinePharmacyLinkDetails => this.vaccinePharmaLinkDetailRepository ??= new DapperRepository<VaccinePharmacyLinkDetail>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<ImmunizationHistory> ImmunizationHistory => this.immunizationHistoryRepository ??= new DapperRepository<ImmunizationHistory>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<SupplierProductHeader> SupplierProductHeaders => this.supplierProductHeaderRepository ??= new DapperRepository<SupplierProductHeader>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<SupplierProductDetail> SupplierProductDetails => this.supplierProductDetailRepository ??= new DapperRepository<SupplierProductDetail>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<SupplierProductFormulation> SupplierProductFormulations => this.supplierProductFormulationRepository ??= new DapperRepository<SupplierProductFormulation>(this.Current, this.config);
       
        /// <inheritdoc />
        public IDapperRepository<IncomingQuotationHeader> IncomingQuotationHeaders => this.incomingQuotationHeaderRepository ??= new DapperRepository<IncomingQuotationHeader>(this.Current, this.config);
                
        /// <inheritdoc />
        public IDapperRepository<IncomingQuotationDetail> IncomingQuotationDetails => this.incomingQuotationDetailRepository ??= new DapperRepository<IncomingQuotationDetail>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<AdmissionTransferRequest> AdmissionTransferRequests => this.admissionTransferRequestRepository ??= new DapperRepository<AdmissionTransferRequest>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<SurgeryService> SurgeryService => this.surgeryServiceRepository ??= new DapperRepository<SurgeryService>(this.Current, this.config);
        
        /// <inheritdoc />
        public IDapperRepository<PharmacyInPatientReturn> PharmacyInPatientReturns => this.pharmacyInPatientReturnRepository ??= new DapperRepository<PharmacyInPatientReturn>(this.Current, this.config);


        /// <inheritdoc />
        public IDapperRepository<ScanService> ScanService => this.scanServiceRepository ??= new DapperRepository<ScanService>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<PackageDocument> PackageDocuments => this.packageDocumentRepository ??= new DapperRepository<PackageDocument>(this.Current, this.config);
        
        /// <inheritdoc />
        public IDapperRepository<InventoryProductRequest> InventoryProductRequests => this.inventoryProductRequestRepository ??= new DapperRepository<InventoryProductRequest>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<WhatsAppTickets> WhatsAppTickets => this.whatsAppTicketsRepository ??= new DapperRepository<WhatsAppTickets>(this.Current, this.config);
        /// <inheritdoc />
        public IDapperRepository<Register> Registers => this.registerRepository ??= new DapperRepository<Register>(this.Current, this.config);
        /// <inheritdoc/>
        public IDapperRepository<PhysiotherapyEncounter> PhysiotherapyEncounters => this.physiotherapyEncounterRepository ??= new DapperRepository<PhysiotherapyEncounter>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<InsuranceTemplate> InsuranceTemplates => this.insuranceTemplateRepository ??= new DapperRepository<InsuranceTemplate>(this.Current, this.config);
        /// <inheritdoc />
        public IDapperRepository<GeneticSpecialityEncounter> GeneticSpecialityEncounter => this.geneticSpecialityEncounterRepository??= new  DapperRepository<GeneticSpecialityEncounter>(this.Current,this.config);

        public IDapperRepository<NeonatalIPEncounter> NeonatalIPEncounters => this.neonatalIPEncounterReository ??= new DapperRepository<NeonatalIPEncounter>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<EncounterOrderTemplates> EncounterOrderTemplates => this.encounterOrderTemplatesRepository ??= new DapperRepository<EncounterOrderTemplates>(this.Current, this.config);

        /// <inheritdoc />
        public IDapperRepository<EncountersLog> EncountersLogs => this.encountersLogRepository ??= new DapperRepository<EncountersLog>(this.Current, this.config);


        /// <summary>
        /// The open connection.
        /// </summary>
        public void OpenConnection()
        {
            if (this.connection.State != ConnectionState.Open && this.connection.State != ConnectionState.Connecting)
            {
                this.connection.Open();
            }
        }

        /// <inheritdoc />
        public IDbTransaction BeginTransaction() => this.Current.BeginTransaction();

        /// <inheritdoc />
        public Task<TEntity> ExecuteAsync<TEntity>(string functionName, object parameters) => this.Current.QueryFirstOrDefaultAsync<TEntity>(functionName, parameters, commandType: CommandType.StoredProcedure);

        /// <inheritdoc />
        public Task<IEnumerable<TEntity>> ExecuteAllAsync<TEntity>(string functionName, object parameters) => this.Current.QueryAsync<TEntity>(functionName, parameters, commandType: CommandType.StoredProcedure);


        /// <inheritdoc />
        public void Dispose()
        {
            this.Dispose(true);
            GC.SuppressFinalize(this);
        }

        /// <summary>
        /// The dispose.
        /// </summary>
        /// <param name="disposing">
        /// The disposing.
        /// </param>
        private void Dispose(bool disposing)
        {
            if (this.disposed)
            {
                return;
            }

            if (disposing && this.connection != null && this.connection.State != ConnectionState.Closed)
            {
                this.connection.Close();
                this.connection.Dispose();
            }

            this.disposed = true;
        }
    }
}
