﻿using Dapper;
using Hims.Domain.Entities;
using Hims.Domain.Repositories.UnitOfWork;
using Hims.Domain.Services;
using Hims.Shared.EntityModels;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading.Tasks;

namespace Hims.Infrastructure.Services
{
    public class DriverDetailService : IDriverDetailService
    {
        /// <summary>
        /// The unit of work.
        /// </summary>
        private readonly IUnitOfWork unitOfWork;

        /// <inheritdoc cref="IDriverDetailService" />
        public DriverDetailService(IUnitOfWork unitOfWork) => this.unitOfWork = unitOfWork;

        public async Task<int> InsertAsync(DriverDetailModel model)
        {
            var checkIf = await this.unitOfWork.Current.QuerySingleOrDefaultAsync<int>($@"select count(*) from ""DriverDetail"" where  lower(""DriverDetailName"") = '{model.DriverDetailName.ToLower()}'");
            if (checkIf > 0)
            {
                return -1;
            }
            var driverDetail = new DriverDetail
            {
                DriverDetailName = model.DriverDetailName,
                MobileNo = model.MobileNo,
                AadharNo = model.AadharNo,
                Active = true,
                CreatedBy = model.CreatedBy,
                CreatedDate = DateTime.Now,
                FromTime=model.FromTime,
                ToTime=model.ToTime,
                Address=model.Address
            };
            return await this.unitOfWork.DriverDetail.InsertAsync(driverDetail);
        }

        /// <inheritdoc/>
        public async Task<int> UpdateAsync(DriverDetailModel model)
        {

            var checkIf = await this.unitOfWork.Current.QuerySingleOrDefaultAsync<int>($@"select count(*) from ""DriverDetail"" where  lower (""DriverDetailName"") = '{model.DriverDetailName.ToLower()}' and ""DriverDetailId"" <> {model.DriverDetailId}");
            if (checkIf > 0)
            {
                return -1;
            }
            var record = await this.unitOfWork.DriverDetail.FindAsync(m => m.DriverDetailId == model.DriverDetailId);
            if (record == null)
            {
                return -2;
            }
            record.DriverDetailName = model.DriverDetailName;
            record.MobileNo = model.MobileNo;
            record.AadharNo = model.AadharNo;
            record.Active = true;
            record.ModifiedBy = model.CreatedBy;
            record.ModifiedDate = DateTime.Now;
            record.FromTime = model.FromTime;
            record.ToTime = model.ToTime;
            record.Address = model.Address;
            return await this.unitOfWork.DriverDetail.UpdateAsync(record);
        }
        public async Task<IEnumerable<DriverDetailModel>> FetchAllAsync(DriverDetailModel model)
        {
            var where = "where 1=1";
            if (model.DriverDetailId > 0)
            {
                where += $@" and  cs.""DriverDetailId"" = {model.DriverDetailId} ";
            }
            var query = $@"select count(dd.""DriverDetailId"") over() as ""TotalItems"",dd.*,
		                        C.""FullName"" as ""CreatedByName"", CR.""RoleName"" as ""CreatedByRole"",M.""FullName"" as ""ModifiedByName"", MR.""RoleName"" as ""ModifiedByRole""
                             FROM ""DriverDetail"" dd
                             join ""Account"" C on C.""AccountId"" = dd.""CreatedBy""
                             join ""Role"" CR on CR.""RoleId"" = C.""RoleId""
                             left join ""Account"" M on M.""AccountId"" = dd.""ModifiedBy""
                             left join ""Role"" MR on MR.""RoleId"" = M.""RoleId""
                                {where}
                             order by dd.""CreatedDate"" desc";

            return await this.unitOfWork.Current.QueryAsync<DriverDetailModel>(query);
        }

        //public Task<int> DeleteAsync(int driverDetailId)
        //{
        //    var query = $@"DELETE FROM ""DriverDetail"" WHERE ""DriverDetailId""= {driverDetailId}";
        //    return this.unitOfWork.Current.ExecuteAsync(query);
        //}

        public Task<int> ModifyStatusAsync(int driverDetailId, int modifiedBy, bool status)
        {
            var query = $@"UPDATE ""DriverDetail"" SET ""Active"" = {!status}, ""ModifiedBy"" = {modifiedBy}, ""ModifiedDate"" = NOW() AT TIME ZONE 'UTC' WHERE ""DriverDetailId""= {driverDetailId}";
            return this.unitOfWork.Current.ExecuteAsync(query);
        }


    }


}

