﻿#nullable enable
namespace Hims.Shared.Library
{
    using System;

    /// <summary>
    /// The account.
    /// </summary>
    public class UserAccount
    {
        /// <summary>
        /// Gets or sets the account id.
        /// </summary>
        public int AccountId { get; set; }

        /// <summary>
        /// Gets or sets the encrypted reference id.
        /// </summary>
        public int ReferenceId { get; set; }

        /// <summary>
        /// Gets or sets the encrypted reference id.
        /// </summary>
        public string EncryptedReferenceId { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the full name.
        /// </summary>
        public string FullName { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the role id.
        /// </summary>
        public int RoleId { get; set; }

        /// <summary>
        /// Gets or sets the role name.
        /// </summary>
        public string RoleName { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the email.
        /// </summary>
        public string? Email { get; set; }

        /// <summary>
        /// Gets or sets the mobile.
        /// </summary>
        public string Mobile { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the country id.
        /// </summary>
        public int CountryId { get; set; }

        /// <summary>
        /// Gets or sets the country code.
        /// </summary>
        public string CountryCode { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the country name.
        /// </summary>
        public string CountryName { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the ISO code.
        /// </summary>
        public string ISOCode { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the session id.
        /// </summary>
        public int? SessionId { get; set; }

        /// <summary>
        /// Gets or sets the last login date.
        /// </summary>
        public DateTime? LastLoginDate { get; set; }

        /// <summary>
        /// Gets or sets the thumbnail url.
        /// </summary>
        public string? ThumbnailUrl { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether is agreed.
        /// </summary>
        public bool IsAgreed { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether is new.
        /// </summary>
        public bool IsNew { get; set; }

        /// <summary>
        /// Gets or sets the access token.
        /// </summary>
        public string Token { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the refresh token.
        /// </summary>
        public string ReferenceToken { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the expires.
        /// </summary>
        public DateTime Expires { get; set; }

        /// <summary>
        /// Gets or sets the guid.
        /// </summary>
        public string? Guid { get; set; }

        /// <summary>
        /// Gets or sets the Referral Code.
        /// </summary>
        public string? ReferralCode { get; set; }

        /// <summary>
        /// Gets or sets the allow video call.
        /// </summary>
        public bool AllowVideoCall { get; set; }

        /// <summary>
        /// Gets or sets the location identifier.
        /// </summary>
        /// <value>
        /// The location identifier.
        /// </value>
        public int? LocationId { get; set; }

        /// <summary>
        /// Gets or sets the name of the location.
        /// </summary>
        /// <value>
        /// The name of the location.
        /// </value>
        public string? LocationName { get; set; }

        /// <summary>
        /// Gets or sets the user name.
        /// </summary>
        public string? UserName { get; set; }

        /// <summary>
        /// Gets or sets the umr no.
        /// </summary>
        public string? UMRNo { get; set; }
    }
}