﻿namespace Hims.Shared.UserModels.Inventory
{
    /// <summary>
    /// The raw products model.
    /// </summary>
    public class RawProductsModel
    {
        /// <summary>
        /// Gets or sets the product name.
        /// </summary>
        public string ProductName { get; set; }

        /// <summary>
        /// Gets or sets the company.
        /// </summary>
        public string Company { get; set; }

        /// <summary>
        /// Gets or sets the category.
        /// </summary>
        public string Category { get; set; }

        /// <summary>
        /// Gets or sets the rack.
        /// </summary>
        public string Rack { get; set; }

        /// <summary>
        /// Gets or sets the purchase quantity.
        /// </summary>
        public string PurchaseQuantity { get; set; }

        /// <summary>
        /// Gets or sets the purchase unit.
        /// </summary>
        public string PurchaseUnit { get; set; }

        /// <summary>
        /// Gets or sets the sale quantity.
        /// </summary>
        public string SaleQuantity { get; set; }

        /// <summary>
        /// Gets or sets the sale unit.
        /// </summary>
        public string SaleUnit { get; set; }

        /// <summary>
        /// Gets or sets the gst.
        /// </summary>
        public string Gst { get; set; }

        /// <summary>
        /// Gets or sets the min quantity.
        /// </summary>
        public string MinQuantity { get; set; }

        /// <summary>
        /// Gets or sets the max quantity.
        /// </summary>
        public string MaxQuantity { get; set; }

        /// <summary>
        /// Gets or sets the reorder quantity.
        /// </summary>
        public string ReorderQuantity { get; set; }

        /// <summary>
        /// Gets or sets the batch number required.
        /// </summary>
        public string BatchNumberRequired { get; set; }

        /// <summary>
        /// Gets or sets the product expire.
        /// </summary>
        public string ProductExpire { get; set; }

        /// <summary>
        /// Gets or sets the bill number.
        /// </summary>
        public string BillNumber { get; set; }

        /// <summary>
        /// Gets or sets the generic name.
        /// </summary>
        public string GenericName { get; set; }
    }
}
