﻿namespace Hims.Shared.UserModels.Laboratory
{
    using System;
    using System.Collections.Generic;
    using System.Text;

    /// <summary>
    /// The lab booking detail model.
    /// </summary>
    public class LabBookingDetailModel
    {
        /// <summary>
        /// Gets or sets the lab booking detail id.
        /// </summary>
        public int LabBookingDetailId { get; set; }

        /// <summary>
        /// Gets or sets the lab booking header id.
        /// </summary>
        public int LabBookingHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the lab header id.
        /// </summary>
        public int? LabHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the lab package id.
        /// </summary>
        public int? LabPackageId { get; set; }

        /// <summary>
        /// Gets or sets the lab service id.
        /// </summary>
        public int? LabServicesId { get; set; }

        /// <summary>
        /// Gets or sets the amount. 
        /// </summary>
        public double Amount { get; set; }

        /// <summary>
        /// Gets or sets the status.
        /// </summary>
        public string Status { get; set; }

        /// <summary>
        /// Gets or sets the lab name.
        /// </summary>
        public string LabName { get; set; }
        /// <summary>
        /// Gets or sets the lab id.
        /// </summary>
        public int? LabId { get; set; }

        /// <summary>
        /// Gets or sets the package name.
        /// </summary>
        public string PackageName { get; set; }

        /// <summary>
        /// Gets or sets a value indicating is report generated.
        /// </summary>
        public bool? IsReportGenerated { get; set; }

        /// <summary>
        /// Gets or sets the report date.
        /// </summary>
        public DateTime? ReportDate { get; set; }

        /// <summary>
        /// Gets or sets the discount amount. 
        /// </summary>
        public double? DiscountAmount { get; set; }

        /// <summary>
        /// Gets or sets the net amount. 
        /// </summary>
        public double NetAmount { get; set; }

        /// <summary>
        /// Gets or sets the discount percentage.
        /// </summary>
        public int? DiscountPercentage { get; set; }

        /// <summary>
        /// Gets or sets the labs in package.
        /// </summary>
        public List<BookingPackageLaboratoryModel> LabsInPackage { get; set; }

        /// <summary>
        /// Gets or sets the is sample collected.
        /// </summary>
        public bool? IsSampleCollected { get; set; }

        /// <summary>
        /// Gets or sets the sample date.
        /// </summary>
        public DateTime? SampleDate { get; set; }

        /// <summary>
        /// Gets or sets the typed by name.
        /// </summary>
        public string TypedByName { get; set; }

        /// <summary>
        /// Gets or sets the verified by name.
        /// </summary>
        public string VerifiedByName { get; set; }

        /// <summary>
        /// Gets or sets the  name of Sample Collector.
        /// </summary>
        public string? SampleCollectedBy { get; set; }

        /// <summary>
        /// Gets or sets the  name of lab dept.
        /// </summary>
        public string? DepartmentName { get; set; }

        /// <summary>
        /// Gets or sets the  lab code.
        /// </summary>
        public string? LabCode { get; set; }

        /// <summary>
        /// Gets or sets the name of Sample Receiver.
        /// </summary>
        public string? CollectedSampleReceivedBy { get; set; }

        /// <summary>
        /// Gets or sets the sample date.
        /// </summary>
        public DateTime? SampleReceivedDate { get; set; }

        /// <summary>
        /// Gets or sets theverified by doctor name.
        /// </summary>
        public string VerifiedByDoctorName { get; set; }
        /// <summary>
        /// Gets or sets the patient name.
        /// </summary>
        public string PatientName { get; set; }
        
        /// <summary>
        /// Gets or sets the barcode generated name.
        /// </summary>
        public string BarcodeGeneratedName { get; set; }
        /// <summary>
        /// Gets or sets the patient id.
        /// </summary>
        public int? PatientId { get; set; }
        /// <summary>
        /// Gets or sets the doctor name.
        /// </summary>
        public string? DoctorName { get; set; }
        /// <summary>
        /// Gets or sets the doctor name.
        /// </summary>
        public int? ProviderId { get; set; }
        /// <summary>
        /// Gets or sets the doctor name.
        /// </summary>
        public int? LabDepartmentId { get; set; }
        /// <summary>
        /// Gets or sets the from date .
        /// </summary>
        public DateTime? FromDate { get; set; }

        /// <summary>
        /// Gets or sets the to date.
        /// </summary>
        public DateTime? ToDate { get; set; }
        /// <summary>
        /// Gets or sets the to date.
        /// </summary>
        public int? AccountId { get; set; }
        /// <summary>
        /// Gets or sets the page size.
        /// </summary>
        public int? PageSize { get; set; }

        /// <summary>
        /// Gets or sets the page index.
        /// </summary>
        public int? PageIndex { get; set; }

        /// <summary>
        /// Gets or sets the barcode identifier.
        /// </summary>
        /// <value>
        /// The barcode identifier.
        /// </value>

        public bool Barcode { get; set; }

        /// <summary>
        /// Gets or sets the barcode generated by identifier.
        /// </summary>
        /// <value>
        /// The barcode  generated by identifier.
        /// </value>

        public int? BarcodeGeneratedBy { get; set; }

        /// <summary>
        /// Gets or sets the borcode generated date.
        /// </summary>
        /// <value>
        /// The borcode generated date identifier.
        /// </value>

        public DateTime? BarcodeGeneratedDate { get; set; }

    }
}
