﻿using System;
namespace Hims.Shared.UserModels.PharmacyRequest
{
    public class PharmacyInPatientReturnModel
    {
        /// <summary>
        /// Gets or sets the pharmacy in patient return identifier.
        /// </summary>
        /// <value>
        /// The pharmacy in patient return identifier.
        /// </value>
        public long PharmacyInPatientReturnId { get; set; }
        /// <summary>
        /// Gets or sets the pharmacy issue detail identifier.
        /// </summary>
        /// <value>
        /// The pharmacy issue detail identifier.
        /// </value>
        public int PharmacyIssueDetailId { get; set; }
        /// <summary>
        /// Gets or sets the return quantity.
        /// </summary>
        /// <value>
        /// The return quantity.
        /// </value>
        public int ReturnQuantity { get; set; }
        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        /// <value>
        /// The created by.
        /// </value>
        public int CreatedBy { get; set; }
        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        /// <value>
        /// The created date.
        /// </value>
        public DateTime CreatedDate { get; set; }
        /// <summary>
        /// Gets or sets the accepted by.
        /// </summary>
        /// <value>
        /// The accepted by.
        /// </value>
        public int? AcceptedBy { get; set; }
        /// <summary>
        /// Gets or sets the accepted date.
        /// </summary>
        /// <value>
        /// The accepted date.
        /// </value>
        public DateTime? AcceptedDate { get; set; }

        /// <summary>
        /// Gets or sets the name of the created by.
        /// </summary>
        /// <value>
        /// The name of the created by.
        /// </value>
        public string CreatedByName { get; set; }

        /// <summary>
        /// Gets or sets the name of the accepted by.
        /// </summary>
        /// <value>
        /// The name of the accepted by.
        /// </value>
        public string AcceptedByName { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy product identifier.
        /// </summary>
        /// <value>
        /// The pharmacy product identifier.
        /// </value>
        public int? PharmacyProductId { get; set; }
        /// <summary>
        /// Gets or sets the retail stock identifier.
        /// </summary>
        /// <value>
        /// The retail stock identifier.
        /// </value>
        public int? RetailStockId { get; set; }

        /// <summary>
        /// Gets or sets the name of the product.
        /// </summary>
        /// <value>
        /// The name of the product.
        /// </value>
        public string ProductName { get; set; }
        /// <summary>
        /// Gets or sets the name of the generic.
        /// </summary>
        /// <value>
        /// The name of the generic.
        /// </value>
        public string GenericName { get; set; }
        /// <summary>
        /// Gets or sets the name of the patient.
        /// </summary>
        /// <value>
        /// The name of the patient.
        /// </value>
        public string PatientName { get; set; }
        /// <summary>
        /// Gets or sets the mobile.
        /// </summary>
        /// <value>
        /// The mobile.
        /// </value>
        public string Mobile { get; set; }
        /// <summary>
        /// Gets or sets the umr no.
        /// </summary>
        /// <value>
        /// The umr no.
        /// </value>
        public string UMRNo { get; set; }
    }
}
